/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define GNOME_SCAN_TYPE_COLUMN (gnome_scan_column_get_type ())

#define GNOME_SCAN_TYPE_SCANNER_SELECTOR (gnome_scan_scanner_selector_get_type ())
#define GNOME_SCAN_SCANNER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelector))
#define GNOME_SCAN_SCANNER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorClass))
#define GNOME_SCAN_IS_SCANNER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR))
#define GNOME_SCAN_IS_SCANNER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER_SELECTOR))
#define GNOME_SCAN_SCANNER_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorClass))

typedef struct _GnomeScanScannerSelector GnomeScanScannerSelector;
typedef struct _GnomeScanScannerSelectorClass GnomeScanScannerSelectorClass;
typedef struct _GnomeScanScannerSelectorPrivate GnomeScanScannerSelectorPrivate;

#define GNOME_SCAN_TYPE_BACKEND (gnome_scan_backend_get_type ())
#define GNOME_SCAN_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackend))
#define GNOME_SCAN_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackendClass))
#define GNOME_SCAN_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_BACKEND))
#define GNOME_SCAN_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_BACKEND))
#define GNOME_SCAN_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackendClass))

typedef struct _GnomeScanBackend GnomeScanBackend;
typedef struct _GnomeScanBackendClass GnomeScanBackendClass;

#define GNOME_SCAN_TYPE_JOB (gnome_scan_job_get_type ())
#define GNOME_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJob))
#define GNOME_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))
#define GNOME_SCAN_IS_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_IS_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))

typedef struct _GnomeScanJob GnomeScanJob;
typedef struct _GnomeScanJobClass GnomeScanJobClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GNOME_SCAN_TYPE_NODE (gnome_scan_node_get_type ())
#define GNOME_SCAN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNode))
#define GNOME_SCAN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))
#define GNOME_SCAN_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))

typedef struct _GnomeScanNode GnomeScanNode;
typedef struct _GnomeScanNodeClass GnomeScanNodeClass;

#define GNOME_SCAN_TYPE_SCANNER (gnome_scan_scanner_get_type ())
#define GNOME_SCAN_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScanner))
#define GNOME_SCAN_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))
#define GNOME_SCAN_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))

typedef struct _GnomeScanScanner GnomeScanScanner;
typedef struct _GnomeScanScannerClass GnomeScanScannerClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define GNOME_SCAN_TYPE_STATUS (gnome_scan_status_get_type ())

typedef enum  {
	GNOME_SCAN_COLUMN_ICON,
	GNOME_SCAN_COLUMN_NAME,
	GNOME_SCAN_COLUMN_STATUS,
	GNOME_SCAN_COLUMN_OBJECT,
	GNOME_SCAN_COLUMN_LAST
} GnomeScanColumn;

struct _GnomeScanScannerSelector {
	GtkScrolledWindow parent_instance;
	GnomeScanScannerSelectorPrivate * priv;
};

struct _GnomeScanScannerSelectorClass {
	GtkScrolledWindowClass parent_class;
};

struct _GnomeScanScannerSelectorPrivate {
	GtkListStore* scanners;
	GtkTreeView* view;
	GtkTreeSelection* selection;
	GSList* backends;
	gint backends_probing_count;
	GnomeScanJob* _job;
};

typedef enum  {
	GNOME_SCAN_STATUS_UNKNOWN = 0,
	GNOME_SCAN_STATUS_FAILED = 100,
	GNOME_SCAN_STATUS_INITIALIZING = 200,
	GNOME_SCAN_STATUS_BUSY = 300,
	GNOME_SCAN_STATUS_UNCONFIGURED = 400,
	GNOME_SCAN_STATUS_READY = 500,
	GNOME_SCAN_STATUS_PROCESSING = 600,
	GNOME_SCAN_STATUS_DONE = 700
} GnomeScanStatus;


static gpointer gnome_scan_scanner_selector_parent_class = NULL;

GType gnome_scan_column_get_type (void);
GType gnome_scan_scanner_selector_get_type (void);
GType gnome_scan_backend_get_type (void);
GType gnome_scan_job_get_type (void);
#define GNOME_SCAN_SCANNER_SELECTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorPrivate))
enum  {
	GNOME_SCAN_SCANNER_SELECTOR_DUMMY_PROPERTY,
	GNOME_SCAN_SCANNER_SELECTOR_JOB
};
static void _g_slist_free_g_object_unref (GSList* self);
void gnome_scan_scanner_selector_set_job (GnomeScanScannerSelector* self, GnomeScanJob* value);
GnomeScanScannerSelector* gnome_scan_scanner_selector_new (GnomeScanJob* job);
GnomeScanScannerSelector* gnome_scan_scanner_selector_construct (GType object_type, GnomeScanJob* job);
void* gnome_scan_backend_probe_scanners (GnomeScanBackend* self);
static void* _gnome_scan_backend_probe_scanners_gthread_func (gpointer self);
static gboolean gnome_scan_scanner_selector_on_check_probe_done (GnomeScanScannerSelector* self);
static gboolean _gnome_scan_scanner_selector_on_check_probe_done_gsource_func (gpointer self);
void gnome_scan_scanner_selector_probe_scanners (GnomeScanScannerSelector* self);
GType gnome_scan_node_get_type (void);
GType gnome_scan_scanner_get_type (void);
static void gnome_scan_scanner_selector_on_scanner_added (GnomeScanScannerSelector* self, GnomeScanBackend* backend, GnomeScanScanner* new_scanner);
static void _gnome_scan_scanner_selector_on_scanner_added_gnome_scan_backend_scanner_added (GnomeScanBackend* _sender, GnomeScanScanner* scanner, gpointer self);
static void gnome_scan_scanner_selector_on_probe_done (GnomeScanScannerSelector* self, GnomeScanBackend* backend);
static void _gnome_scan_scanner_selector_on_probe_done_gnome_scan_backend_probe_done (GnomeScanBackend* _sender, gpointer self);
static void gnome_scan_scanner_selector_load_backends (GnomeScanScannerSelector* self);
const char* gnome_scan_scanner_get_icon_name (GnomeScanScanner* self);
const char* gnome_scan_scanner_get_name (GnomeScanScanner* self);
const char* gnome_scan_node_get_message (GnomeScanNode* self);
static void gnome_scan_scanner_selector_on_scanner_status_changed (GnomeScanScannerSelector* self, GnomeScanScanner* scanner, GParamSpec* pspec);
static void _gnome_scan_scanner_selector_on_scanner_status_changed_g_object_notify (GnomeScanScanner* _sender, GParamSpec* pspec, gpointer self);
void gnome_scan_job_set_scanner (GnomeScanJob* self, GnomeScanScanner* value);
GnomeScanJob* gnome_scan_scanner_selector_get_job (GnomeScanScannerSelector* self);
GType gnome_scan_status_get_type (void);
GnomeScanStatus gnome_scan_node_get_status (GnomeScanNode* self);
static gboolean gnome_scan_scanner_selector_select_scanner_if_usable (GnomeScanScannerSelector* self);
static gboolean _gnome_scan_scanner_selector_select_scanner_if_usable_gsource_func (gpointer self);
static void gnome_scan_scanner_selector_on_selection_changed (GnomeScanScannerSelector* self, GtkTreeSelection* selection);
static void _gnome_scan_scanner_selector_on_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GObject * gnome_scan_scanner_selector_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_scanner_selector_finalize (GObject* obj);
static void gnome_scan_scanner_selector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_scanner_selector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);




GType gnome_scan_column_get_type (void) {
	static GType gnome_scan_column_type_id = 0;
	if (G_UNLIKELY (gnome_scan_column_type_id == 0)) {
		static const GEnumValue values[] = {{GNOME_SCAN_COLUMN_ICON, "GNOME_SCAN_COLUMN_ICON", "icon"}, {GNOME_SCAN_COLUMN_NAME, "GNOME_SCAN_COLUMN_NAME", "name"}, {GNOME_SCAN_COLUMN_STATUS, "GNOME_SCAN_COLUMN_STATUS", "status"}, {GNOME_SCAN_COLUMN_OBJECT, "GNOME_SCAN_COLUMN_OBJECT", "object"}, {GNOME_SCAN_COLUMN_LAST, "GNOME_SCAN_COLUMN_LAST", "last"}, {0, NULL, NULL}};
		gnome_scan_column_type_id = g_enum_register_static ("GnomeScanColumn", values);
	}
	return gnome_scan_column_type_id;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


GnomeScanScannerSelector* gnome_scan_scanner_selector_construct (GType object_type, GnomeScanJob* job) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanScannerSelector * self;
	g_return_val_if_fail (job != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "job";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_JOB);
	g_value_set_object (&__params_it->value, job);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanScannerSelector* gnome_scan_scanner_selector_new (GnomeScanJob* job) {
	return gnome_scan_scanner_selector_construct (GNOME_SCAN_TYPE_SCANNER_SELECTOR, job);
}


static void* _gnome_scan_backend_probe_scanners_gthread_func (gpointer self) {
	return gnome_scan_backend_probe_scanners (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _gnome_scan_scanner_selector_on_check_probe_done_gsource_func (gpointer self) {
	return gnome_scan_scanner_selector_on_check_probe_done (self);
}


void gnome_scan_scanner_selector_probe_scanners (GnomeScanScannerSelector* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		GSList* backend_collection;
		GSList* backend_it;
		backend_collection = self->priv->backends;
		for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
			GnomeScanBackend* backend;
			backend = _g_object_ref0 ((GnomeScanBackend*) backend_it->data);
			{
				{
					self->priv->backends_probing_count++;
					g_thread_create (_gnome_scan_backend_probe_scanners_gthread_func, backend, FALSE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_THREAD_ERROR) {
							goto __catch3_g_thread_error;
						}
						goto __finally3;
					}
				}
				goto __finally3;
				__catch3_g_thread_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
						g_warning ("gnome-scan-scanner-selector.vala:93: Unable to create new thread : %s", _error_->message);
						self->priv->backends_probing_count--;
						_g_error_free0 (_error_);
					}
				}
				__finally3:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (backend);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (backend);
			}
		}
	}
	g_timeout_add_seconds ((guint) 1, _gnome_scan_scanner_selector_on_check_probe_done_gsource_func, self);
}


static void _gnome_scan_scanner_selector_on_scanner_added_gnome_scan_backend_scanner_added (GnomeScanBackend* _sender, GnomeScanScanner* scanner, gpointer self) {
	gnome_scan_scanner_selector_on_scanner_added (self, _sender, scanner);
}


static void _gnome_scan_scanner_selector_on_probe_done_gnome_scan_backend_probe_done (GnomeScanBackend* _sender, gpointer self) {
	gnome_scan_scanner_selector_on_probe_done (self, _sender);
}


static void gnome_scan_scanner_selector_load_backends (GnomeScanScannerSelector* self) {
	gint backend_types_size;
	gint backend_types_length1;
	GType* backend_types;
	GnomeScanBackend* backend;
	GType* _tmp1_;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	backend_types = (backend_types_length1 = 0, NULL);
	backend = NULL;
	backend_types = (_tmp1_ = g_type_children (GNOME_SCAN_TYPE_BACKEND, &_tmp0_), backend_types = (g_free (backend_types), NULL), backend_types_length1 = _tmp0_, backend_types_size = backend_types_length1, _tmp1_);
	{
		GType* type_collection;
		int type_collection_length1;
		int type_it;
		type_collection = backend_types;
		type_collection_length1 = backend_types_length1;
		for (type_it = 0; type_it < backend_types_length1; type_it = type_it + 1) {
			GType type;
			type = type_collection[type_it];
			{
				GnomeScanBackend* _tmp2_;
				backend = (_tmp2_ = GNOME_SCAN_BACKEND (g_object_new (type, NULL)), _g_object_unref0 (backend), _tmp2_);
				self->priv->backends = g_slist_append (self->priv->backends, _g_object_ref0 (backend));
				g_signal_connect_object (backend, "scanner-added", (GCallback) _gnome_scan_scanner_selector_on_scanner_added_gnome_scan_backend_scanner_added, self, 0);
				g_signal_connect_object (backend, "probe-done", (GCallback) _gnome_scan_scanner_selector_on_probe_done_gnome_scan_backend_probe_done, self, 0);
			}
		}
	}
	backend_types = (g_free (backend_types), NULL);
	_g_object_unref0 (backend);
}


static void _gnome_scan_scanner_selector_on_scanner_status_changed_g_object_notify (GnomeScanScanner* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_scanner_selector_on_scanner_status_changed (self, _sender, pspec);
}


static void gnome_scan_scanner_selector_on_scanner_added (GnomeScanScannerSelector* self, GnomeScanBackend* backend, GnomeScanScanner* new_scanner) {
	GtkTreeIter iter = {0};
	GtkTreePath* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (new_scanner != NULL);
	gtk_list_store_append (self->priv->scanners, &iter);
	gtk_list_store_set (self->priv->scanners, &iter, GNOME_SCAN_COLUMN_ICON, gnome_scan_scanner_get_icon_name (new_scanner), GNOME_SCAN_COLUMN_NAME, gnome_scan_scanner_get_name (new_scanner), GNOME_SCAN_COLUMN_STATUS, _ (gnome_scan_node_get_message ((GnomeScanNode*) new_scanner)), GNOME_SCAN_COLUMN_OBJECT, new_scanner, -1);
	g_object_set_data ((GObject*) new_scanner, "path", gtk_tree_path_to_string (_tmp0_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->scanners, &iter)));
	_gtk_tree_path_free0 (_tmp0_);
	g_signal_connect_object ((GObject*) new_scanner, "notify::status", (GCallback) _gnome_scan_scanner_selector_on_scanner_status_changed_g_object_notify, self, 0);
}


static void gnome_scan_scanner_selector_on_probe_done (GnomeScanScannerSelector* self, GnomeScanBackend* backend) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	self->priv->backends_probing_count--;
}


static gboolean gnome_scan_scanner_selector_on_check_probe_done (GnomeScanScannerSelector* self) {
	gboolean result;
	GtkTreeIter iter = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->scanners, &iter);
	if (gtk_list_store_iter_is_valid (self->priv->scanners, &iter)) {
		gtk_tree_selection_select_iter (gtk_tree_view_get_selection (self->priv->view), &iter);
	}
	if (self->priv->backends_probing_count == 0) {
		g_signal_emit_by_name (self, "probe-done");
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean gnome_scan_scanner_selector_select_scanner_if_usable (GnomeScanScannerSelector* self) {
	gboolean result;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GnomeScanScanner* scanner;
	GtkTreeModel* _tmp2_;
	gboolean _tmp1_;
	GtkTreeModel* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	model = NULL;
	scanner = NULL;
	_tmp0_ = NULL;
	if ((_tmp1_ = gtk_tree_selection_get_selected (self->priv->selection, &_tmp0_, &iter), model = (_tmp2_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (model), _tmp2_), _tmp1_)) {
		gtk_tree_model_get (model, &iter, GNOME_SCAN_COLUMN_OBJECT, &scanner, -1);
	} else {
		GnomeScanScanner* _tmp3_;
		scanner = (_tmp3_ = NULL, _g_object_unref0 (scanner), _tmp3_);
	}
	if (scanner == NULL) {
		gnome_scan_job_set_scanner (self->priv->_job, NULL);
		result = FALSE;
		_g_object_unref0 (model);
		_g_object_unref0 (scanner);
		return result;
	}
	if (gnome_scan_node_get_status ((GnomeScanNode*) scanner) == GNOME_SCAN_STATUS_FAILED) {
		gtk_tree_selection_unselect_all (self->priv->selection);
		result = FALSE;
		_g_object_unref0 (model);
		_g_object_unref0 (scanner);
		return result;
	}
	if (((gint) gnome_scan_node_get_status ((GnomeScanNode*) scanner)) >= ((gint) GNOME_SCAN_STATUS_UNCONFIGURED)) {
		gnome_scan_job_set_scanner (self->priv->_job, scanner);
		result = FALSE;
		_g_object_unref0 (model);
		_g_object_unref0 (scanner);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (model);
	_g_object_unref0 (scanner);
	return result;
}


static gboolean _gnome_scan_scanner_selector_select_scanner_if_usable_gsource_func (gpointer self) {
	return gnome_scan_scanner_selector_select_scanner_if_usable (self);
}


static void gnome_scan_scanner_selector_on_selection_changed (GnomeScanScannerSelector* self, GtkTreeSelection* selection) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	g_idle_add_full (0, _gnome_scan_scanner_selector_select_scanner_if_usable_gsource_func, g_object_ref (self), g_object_unref);
}


static void gnome_scan_scanner_selector_on_scanner_status_changed (GnomeScanScannerSelector* self, GnomeScanScanner* scanner, GParamSpec* pspec) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (pspec != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->scanners, &iter, (const char*) g_object_get_data ((GObject*) scanner, "path"));
	if (!gtk_list_store_iter_is_valid (self->priv->scanners, &iter)) {
		g_warning ("gnome-scan-scanner-selector.vala:191: Unable to update '%s' status in scanner selector!", gnome_scan_scanner_get_name (scanner));
	}
	gtk_list_store_set (self->priv->scanners, &iter, GNOME_SCAN_COLUMN_STATUS, _ (gnome_scan_node_get_message ((GnomeScanNode*) scanner)), -1);
}


GnomeScanJob* gnome_scan_scanner_selector_get_job (GnomeScanScannerSelector* self) {
	GnomeScanJob* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_job;
	return result;
}


void gnome_scan_scanner_selector_set_job (GnomeScanScannerSelector* self, GnomeScanJob* value) {
	GnomeScanJob* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_job = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_job), _tmp0_);
	g_object_notify ((GObject *) self, "job");
}


static void _gnome_scan_scanner_selector_on_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	gnome_scan_scanner_selector_on_selection_changed (self, _sender);
}


static GObject * gnome_scan_scanner_selector_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanScannerSelectorClass * klass;
	GObjectClass * parent_class;
	GnomeScanScannerSelector * self;
	klass = GNOME_SCAN_SCANNER_SELECTOR_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_SCANNER_SELECTOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_SCANNER_SELECTOR (obj);
	{
		GtkCellRenderer* renderer;
		GtkTreeViewColumn* col;
		GtkListStore* _tmp0_;
		GtkTreeView* _tmp1_;
		GtkTreeSelection* _tmp2_;
		GtkCellRenderer* _tmp3_;
		GtkTreeViewColumn* _tmp4_;
		GtkCellRenderer* _tmp5_;
		GtkTreeViewColumn* _tmp6_;
		GtkCellRenderer* _tmp7_;
		GtkTreeViewColumn* _tmp8_;
		renderer = NULL;
		col = NULL;
		self->priv->backends_probing_count = 0;
		gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		gnome_scan_scanner_selector_load_backends (self);
		self->priv->scanners = (_tmp0_ = gtk_list_store_new ((gint) GNOME_SCAN_COLUMN_LAST, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_OBJECT, NULL), _g_object_unref0 (self->priv->scanners), _tmp0_);
		self->priv->view = (_tmp1_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->scanners)), _g_object_unref0 (self->priv->view), _tmp1_);
		gtk_tree_view_set_headers_visible (self->priv->view, TRUE);
		self->priv->selection = (_tmp2_ = _g_object_ref0 (gtk_tree_view_get_selection (self->priv->view)), _g_object_unref0 (self->priv->selection), _tmp2_);
		gtk_tree_selection_set_mode (self->priv->selection, GTK_SELECTION_SINGLE);
		g_signal_connect_object (self->priv->selection, "changed", (GCallback) _gnome_scan_scanner_selector_on_selection_changed_gtk_tree_selection_changed, self, 0);
		renderer = (_tmp3_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), _g_object_unref0 (renderer), _tmp3_);
		col = (_tmp4_ = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (NULL, renderer, "icon-name", GNOME_SCAN_COLUMN_ICON, NULL)), _g_object_unref0 (col), _tmp4_);
		gtk_tree_view_append_column (self->priv->view, col);
		renderer = (_tmp5_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp5_);
		col = (_tmp6_ = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (_ ("Device"), renderer, "text", GNOME_SCAN_COLUMN_NAME, NULL)), _g_object_unref0 (col), _tmp6_);
		gtk_tree_view_append_column (self->priv->view, col);
		renderer = (_tmp7_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp7_);
		col = (_tmp8_ = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (_ ("Status"), renderer, "text", GNOME_SCAN_COLUMN_STATUS, NULL)), _g_object_unref0 (col), _tmp8_);
		gtk_tree_view_append_column (self->priv->view, col);
		gtk_scrolled_window_add_with_viewport ((GtkScrolledWindow*) self, (GtkWidget*) self->priv->view);
		_g_object_unref0 (renderer);
		_g_object_unref0 (col);
	}
	return obj;
}


static void gnome_scan_scanner_selector_class_init (GnomeScanScannerSelectorClass * klass) {
	gnome_scan_scanner_selector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanScannerSelectorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_scanner_selector_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_scanner_selector_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_scanner_selector_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_scanner_selector_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_SELECTOR_JOB, g_param_spec_object ("job", "job", "job", GNOME_SCAN_TYPE_JOB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("probe_done", GNOME_SCAN_TYPE_SCANNER_SELECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gnome_scan_scanner_selector_instance_init (GnomeScanScannerSelector * self) {
	self->priv = GNOME_SCAN_SCANNER_SELECTOR_GET_PRIVATE (self);
}


static void gnome_scan_scanner_selector_finalize (GObject* obj) {
	GnomeScanScannerSelector * self;
	self = GNOME_SCAN_SCANNER_SELECTOR (obj);
	_g_object_unref0 (self->priv->scanners);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->selection);
	__g_slist_free_g_object_unref0 (self->priv->backends);
	_g_object_unref0 (self->priv->_job);
	G_OBJECT_CLASS (gnome_scan_scanner_selector_parent_class)->finalize (obj);
}


GType gnome_scan_scanner_selector_get_type (void) {
	static GType gnome_scan_scanner_selector_type_id = 0;
	if (gnome_scan_scanner_selector_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanScannerSelectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_scanner_selector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanScannerSelector), 0, (GInstanceInitFunc) gnome_scan_scanner_selector_instance_init, NULL };
		gnome_scan_scanner_selector_type_id = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "GnomeScanScannerSelector", &g_define_type_info, 0);
	}
	return gnome_scan_scanner_selector_type_id;
}


static void gnome_scan_scanner_selector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanScannerSelector * self;
	self = GNOME_SCAN_SCANNER_SELECTOR (object);
	switch (property_id) {
		case GNOME_SCAN_SCANNER_SELECTOR_JOB:
		g_value_set_object (value, gnome_scan_scanner_selector_get_job (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_scanner_selector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanScannerSelector * self;
	self = GNOME_SCAN_SCANNER_SELECTOR (object);
	switch (property_id) {
		case GNOME_SCAN_SCANNER_SELECTOR_JOB:
		gnome_scan_scanner_selector_set_job (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




