<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                xmlns:ng="http://docbook.org/docbook-ng"
                xmlns:db="http://docbook.org/ns/docbook"
                exclude-result-prefixes="exsl"
                version='1.0'>

  <xsl:import href="docbook-xsl/html/docbook.xsl"/>
  <xsl:import href="docbook-xsl/html/manifest.xsl"/>
  <!-- * html-synop.xsl file is generated by build -->
  <xsl:import href="docbook-xsl/manpages/html-synop.xsl"/>
  <xsl:import href="docbook-xsl/manpages/synop.xsl"/>
  <xsl:import href="docbook-xsl/manpages/lists.xsl"/>
  <!-- we need to overrade apostroph escapment defined in other.xsl -->
  <xsl:import href="docbook-xsl/manpages/other.xsl"/>

  <xsl:output method="text"
              encoding="UTF-8"
              indent="no"/>
  <!-- ********************************************************************
       $Id: fvwm-man.xsl,v 1.12 2007/08/17 17:02:03 griph Exp $
       ********************************************************************

       This file is part of the XSL DocBook Stylesheet distribution.
       See ../README or http://docbook.sf.net/release/xsl/current/ for
       copyright and other information.

       ******************************************************************** -->

  <!-- ==================================================================== -->

  <xsl:include href="docbook-xsl/common/refentry.xsl"/>
  <xsl:include href="docbook-xsl/manpages/param.xsl"/>
  <xsl:include href="docbook-xsl/manpages/utility.xsl"/>
  <xsl:include href="docbook-xsl/manpages/info.xsl"/>
  <xsl:include href="docbook-xsl/manpages/refentry.xsl"/>
  <xsl:include href="docbook-xsl/manpages/block.xsl"/>
  <xsl:include href="docbook-xsl/manpages/inline.xsl"/>
  <xsl:include href="docbook-xsl/manpages/endnotes.xsl"/>
  <xsl:include href="docbook-xsl/manpages/table.xsl"/>

  <!-- * we rename the following just to avoid using params with "man" -->
  <!-- * prefixes in the table.xsl stylesheet (because that stylesheet -->
  <!-- * can potentially be reused for more than just man output) -->
  <xsl:param name="tbl.font.headings" select="$man.font.table.headings"/>
  <xsl:param name="tbl.font.title" select="$man.font.table.title"/>

  <!-- ==================================================================== -->

<!--xsl:variable name="arg.or.sep">|</xsl:variable-->
<xsl:variable name="arg.choice.plain.close.str"></xsl:variable>
<xsl:variable name="arg.rep.repeat.str"> ...</xsl:variable>

<xsl:template match="section">
	<xsl:apply-templates/>
</xsl:template>

<!-- don't escape apostrophs, but put them on the previous line if they start
     one -->
<xsl:template name="escape.apostrophe">
  <xsl:param name="content"/>
  <xsl:call-template name="string.subst">
    <xsl:with-param name="string" select="$content"/>
    <xsl:with-param name="target">&#10;'</xsl:with-param>
    <xsl:with-param name="replacement"> '</xsl:with-param>
  </xsl:call-template>
</xsl:template>


<xsl:template match="section/title">
	<xsl:text>.SH </xsl:text>
	<xsl:call-template name="string.upper">
		<xsl:with-param name="string">
			<xsl:apply-templates/>
		</xsl:with-param>
	</xsl:call-template>
	<xsl:text>&#10;</xsl:text>
</xsl:template>

<xsl:template match="section/section/title">
	<xsl:text>.SS </xsl:text>
	<xsl:apply-templates/>
	<xsl:text>&#10;</xsl:text>
</xsl:template>

<xsl:template match="section/section/section/title">

	<xsl:choose>
		<xsl:when test="parent::section//cmdsynopsis/@command = text()">
		</xsl:when>
		<xsl:when test="parent::section//cmdsynopsis/command/text() = text()">
			<!-- this is no good when there are multiple cmdsynopsis children -->
			<!--xsl:apply-templates select="parent::section//cmdsynopsis/*"/-->
		</xsl:when>
		<xsl:otherwise>
		  <xsl:text>.TP&#10;</xsl:text>
			<xsl:text>.B </xsl:text>
			<xsl:apply-templates/>
			<xsl:text>&#10;.RS&#10;</xsl:text>
			<!-- We don't want .PP from following paras, this is a hack for that -->
			<xsl:text>.\&quot;</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="section/section/section">
	<xsl:apply-templates/>
	<xsl:text>.RE&#10;</xsl:text>
</xsl:template>

<xsl:template match="section/section/section//cmdsynopsis">
	<xsl:choose>
		<xsl:when test="parent::section/title/text() = command/text() or @command = parent::section/title/text()">
			<xsl:if test="preceding-sibling::cmdsynopsis/command/text() = command/text()">
				<xsl:text>.RE&#10;</xsl:text>
			</xsl:if>
		  <xsl:text>.TP&#10;</xsl:text>
		  <xsl:apply-templates select="*"/>
		  <xsl:text>&#10;.RS&#10;</xsl:text>
			<!-- We don't want .PP from following paras, this is a hack for that -->
			<xsl:text>.\&quot;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-imports/>
			<!--xsl:text>&#10;</xsl:text-->
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="simplelist">
  <xsl:text>.nf&#10;</xsl:text>
  <xsl:text>.IP ""</xsl:text>
    <xsl:if test="not($list-indent = '')">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$list-indent"/>
    </xsl:if>
    <xsl:text>&#10;</xsl:text>
  <xsl:for-each select="member">
    <xsl:variable name="content">
      <xsl:apply-templates/>
    </xsl:variable>
    <xsl:value-of select="normalize-space($content)"/>
    <xsl:text>&#10;</xsl:text>
  </xsl:for-each>
  <xsl:text>.fi&#10;</xsl:text>
</xsl:template>

<xsl:template mode="small" match="*">
  <xsl:for-each select="node()">
    <xsl:text>&#10;.SM </xsl:text>
    <xsl:value-of select="normalize-space(.)"/>
    <xsl:text>&#10;</xsl:text>
  </xsl:for-each>
</xsl:template>

<xsl:template match="keysym">
  <xsl:apply-templates mode="small" select="."/>
</xsl:template>

<xsl:template match="envar">
  <xsl:apply-templates mode="italic" select="."/>
</xsl:template>

<!-- fvwmopt -->
<xsl:template match="fvwmopt">
	<xsl:text>\fI</xsl:text>
	<xsl:value-of select="@opt"/>
	<xsl:text>\fR</xsl:text>
</xsl:template>

<!-- * paragraphs starting with a blank line adds extra space in some
		 * cases were we don't want it. Work around that, and make sentenses
		 * have two spaces inbetween in the same time. -->

<xsl:template name="normalize-paragraph">
	<xsl:param name="content"/>
	<xsl:choose>
		<xsl:when test="starts-with($content,'&#10;') or starts-with($content,' ')">
			<xsl:call-template name="normalize-paragraph">
				<xsl:with-param name="content" select="substring($content,2)"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($content,'&#10;&#10;')">
			<xsl:variable name='pcontent'>
				<xsl:value-of select="substring-before($content,'&#10;&#10;')"/>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="contains($pcontent,'. ') or contains($pcontent,'&#10; ')">
					<xsl:call-template name="normalize-paragraph">
						<xsl:with-param name="content" select="$pcontent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pcontent"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>&#10;</xsl:text>
			<xsl:variable name="rcontent">
				<xsl:value-of select="substring-after($content,'&#10;&#10;')"/>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="starts-with($rcontent,'&#10;') or starts-with($rcontent,' ')">
					<xsl:call-template name="normalize-paragraph">
						<xsl:with-param name="content" select="substring($rcontent,2)"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="contains($rcontent,'&#10;&#10;') or contains($rcontent,'. ')">
					<xsl:call-template name="normalize-paragraph">
						<xsl:with-param name="content" select="$rcontent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$rcontent"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<!-- spaces at the start of lines must be removed -->
		<xsl:when test="contains($content,'&#10; ')">
			<xsl:variable name='pcontent'>
				<xsl:value-of select="substring-before($content,'&#10; ')"/>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="contains($pcontent,'. ')">
					<xsl:call-template name="normalize-paragraph">
						<xsl:with-param name="content" select="$pcontent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pcontent"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>&#10;</xsl:text>
			<xsl:variable name="rcontent">
				<xsl:value-of select="substring-after($content,'&#10; ')"/>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="starts-with($rcontent,'&#10;') or starts-with($rcontent,' ')">
					<xsl:call-template name="normalize-paragraph">
						<xsl:with-param name="content" select="substring($rcontent,2)"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="contains($rcontent,'&#10; ') or contains($rcontent,'&#10;&#10;') or contains($rcontent,'. ')">
					<xsl:call-template name="normalize-paragraph">
						<xsl:with-param name="content" select="$rcontent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$rcontent"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="contains($content,'. ')">
			<xsl:variable name='pcontent'>
				<xsl:value-of select="substring-before($content,'. ')"/>
			</xsl:variable>
			<xsl:variable name='spcontent'>
				<xsl:value-of select="substring($pcontent,string-length($pcontent)-3)"/>
			</xsl:variable>
			<xsl:value-of select="$pcontent"/>
			<xsl:text>. </xsl:text>
			<xsl:if test="not(contains($spcontent,'.')) or contains('0123456789)',substring($spcontent,3,1))">
				<xsl:text> </xsl:text>
			</xsl:if>
			<xsl:call-template name="normalize-paragraph">
				<xsl:with-param name="content" select="substring-after($content,'. ')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$content"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="para[ancestor::listitem]">
	<xsl:call-template name="normalize-paragraph">
		<xsl:with-param name="content">
			<xsl:apply-imports/>
		</xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template match="para">
	<!-- just &#10; is enough for most cases, and make less need for .RS
	     in all places, however it reduces spaces in some less desireable
			 places -->
	<xsl:text>.PP&#10;</xsl:text>
	<xsl:variable name="rawcontent">
    <xsl:apply-templates/>
  </xsl:variable>
	<xsl:variable name="content">
		<!-- normalize spaces, but not newlisnes -->
    <xsl:value-of select="translate(normalize-space(translate($rawcontent,'&#10;','&#63743;')),'&#63743;','&#10;')"/>
  </xsl:variable>
	<!-- * Add some check to remove double newlines within the paragraph
	     * but keep single newlines since there might be formatting -->
	<xsl:choose>
		<xsl:when test="contains($content,'&#10; ') or contains($content,'&#10;&#10;') or starts-with($content,'&#10;') or contains($content,'. ')">
			<xsl:call-template name="normalize-paragraph">
				<xsl:with-param name="content" select="$content"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$content"/>
		</xsl:otherwise>
	</xsl:choose>
<!--	<xsl:apply-templates/> -->
	<xsl:text>&#10;</xsl:text>
</xsl:template>


<!-- fvwmref -->
<xsl:template match="fvwmref">
	<xsl:choose>
		<xsl:when test="@sect">
			<xsl:text>\fB</xsl:text>
			<xsl:value-of select="@name"/>
			<xsl:text>\fR</xsl:text>
		</xsl:when>
		<xsl:when test="@opt">
			<xsl:text>\fI</xsl:text>
			<xsl:value-of select="@opt"/>
			<xsl:text>\fR</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>\fB</xsl:text>
			<xsl:choose>
				<xsl:when test="@cmd">
					<xsl:value-of select="@cmd"/>
				</xsl:when>
				<xsl:when test="@mod">
					<xsl:value-of select="@mod"/>
				</xsl:when>
				<!-- anything else should be an error -->
			</xsl:choose>
		<xsl:text>\fR</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="section/command">
	<xsl:text>&#10;</xsl:text>
	<xsl:text>.sp&#10;</xsl:text>
	<xsl:text>.RS</xsl:text>
	<xsl:text> </xsl:text>
	<xsl:value-of select="$man.indent.width"/>
	<xsl:text>&#10;</xsl:text>
	<xsl:text>.nf&#10;</xsl:text>
	<xsl:apply-templates/>
	<xsl:text>&#10;</xsl:text>
	<xsl:text>.fi&#10;</xsl:text>
	<xsl:text>.RE&#10;</xsl:text> 
	<xsl:text>.PP&#10;</xsl:text> 
</xsl:template>


<xsl:template name="get.fvwm.metadata">
<title>
	<xsl:value-of select="artheader/titleabbrev"/>
</title>
<section>
	<xsl:text>1</xsl:text>
</section>
<date>
	<xsl:value-of select="artheader/date"/>
</date>
<source>
</source>
<manual>
	<xsl:value-of select="artheader/title"/>
</manual>
</xsl:template>

<!-- escape special characters (as for <refentry>) -->
<xsl:template match="//article//text()">
  <xsl:call-template name="escape.roff.specials">
    <xsl:with-param name="content">
      <xsl:value-of select="."/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>


  <!-- ==================================================================== -->

  <xsl:template match="/">
        <xsl:choose>
          <xsl:when test="//article">
            <!-- * Check to see if we have any refentry children in this -->
            <!-- * document; if so, process them. -->
            <xsl:apply-templates select="//article"/>
            <!-- * if $man.output.manifest.enabled is non-zero, -->
            <!-- * generate a manifest file -->
            <xsl:if test="not($man.output.manifest.enabled = 0)">
              <xsl:call-template name="generate.manifest">
                <xsl:with-param name="filename">
                  <xsl:choose>
                    <xsl:when test="not($man.output.manifest.filename = '')">
                      <!-- * If a name for the manifest file is specified, -->
                      <!-- * use that name. -->
                      <xsl:value-of select="$man.output.manifest.filename"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <!-- * Otherwise, if user has unset -->
                      <!-- * $man.output.manifest.filename, default to -->
                      <!-- * using "MAN.MANIFEST" as the filename. Because -->
                      <!-- * $man.output.manifest.enabled is non-zero and -->
                      <!-- * so we must have a filename in order to -->
                      <!-- * generate the manifest. -->
                      <xsl:text>MAN.MANIFEST</xsl:text>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <!-- * Otherwise, the document does not contain any -->
            <!-- * refentry elements, so emit message and stop. -->
            <xsl:variable name="title">
              <!-- * Get a title so that we let the user know what -->
              <!-- * document we are processing at this point. -->
              <xsl:choose>
                <xsl:when test="title">
                  <xsl:value-of select="title[1]"/>
                </xsl:when>
                <xsl:when test="substring(local-name(*[1]),
                                string-length(local-name(*[1])-3) = 'info')
                                and *[1]/title">
                  <xsl:value-of select="*[1]/title[1]"/>
                </xsl:when>
              </xsl:choose>
            </xsl:variable>
            <xsl:message>
              <xsl:text>Note: No article elements found in "</xsl:text>
              <xsl:value-of select="local-name(.)"/>
              <xsl:if test="$title != ''">
                <xsl:choose>
                  <xsl:when test="string-length($title) &gt; 30">
                    <xsl:value-of select="substring($title,1,30)"/>
                    <xsl:text>...</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$title"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
              <xsl:text>"</xsl:text>
            </xsl:message>
          </xsl:otherwise>
        </xsl:choose>
  </xsl:template>

  <!-- ============================================================== -->

  <xsl:template match="article">
    <xsl:param name="lang">
      <xsl:call-template name="l10n.language"/>
    </xsl:param>
    <!-- * Just use the first refname found as the "name" of the man -->
    <!-- * page (which may different from the "title"...) -->
<!--
    <xsl:variable name="first.refname" select="refnamediv[1]/refname[1]"/>
-->
    <xsl:variable name="first.refname" select="artheader/titleabbrev"/>

    <xsl:call-template name="root.messages">
      <xsl:with-param name="refname" select="$first.refname"/>
    </xsl:call-template>

    <!-- * Because there are several times when we need to check *info of -->
    <!-- * each refentry and its ancestors, we get those and store the -->
    <!-- * data from them as a node-set in memory. -->

    <!-- * Make a node-set with contents of *info -->
    <xsl:variable name="get.info"
                  select="ancestor-or-self::*/*[substring(local-name(),
                          string-length(local-name()) - 3) = 'info']"
                  />
    <xsl:variable name="info" select="exsl:node-set($get.info)"/>

    <!-- * The get.refentry.metadata template is in -->
    <!-- * ../common/refentry.xsl. It looks for metadata in $info -->
    <!-- * and in various other places and then puts it into a form -->
    <!-- * that's easier for us to digest. -->

    <xsl:variable name="get.refentry.metadata">
      <xsl:call-template name="get.fvwm.metadata">
        <xsl:with-param name="refname" select="$first.refname"/>
        <xsl:with-param name="info" select="$info"/>
        <xsl:with-param name="prefs" select="$refentry.metadata.prefs"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="refentry.metadata" select="exsl:node-set($get.refentry.metadata)"/>


    <!-- * Assemble the various parts into a complete page, then store into -->
    <!-- * $manpage.contents so that we can manipluate them further. -->
    <xsl:variable name="manpage.contents">
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <!-- * top.comment = commented-out section at top of roff source -->
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <xsl:call-template name="top.comment">
        <xsl:with-param name="info"       select="$info"/>
        <xsl:with-param name="date"       select="$refentry.metadata/date"/>
        <xsl:with-param name="title"      select="$refentry.metadata/title"/>
        <xsl:with-param name="manual"     select="$refentry.metadata/manual"/>
        <xsl:with-param name="source"     select="$refentry.metadata/source"/>
      </xsl:call-template>
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <!-- * TH.title.line = title line in header/footer of man page -->
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <xsl:call-template name="TH.title.line">
        <!-- * .TH TITLE  section  extra1  extra2  extra3 -->
        <!-- *  -->
        <!-- * According to the man(7) man page: -->
        <!-- *  -->
        <!-- * extra1 = date,   "the date of the last revision" -->
        <!-- * extra2 = source, "the source of the command" -->
        <!-- * extra3 = manual, "the title of the manual -->
        <!-- *                  (e.g., Linux Programmer's Manual)" -->
        <!-- * -->
        <!-- * So, we end up with: -->
        <!-- *  -->
        <!-- * .TH TITLE  section  date  source  manual -->
        <!-- * -->
        <xsl:with-param name="title"   select="$refentry.metadata/title"/>
        <xsl:with-param name="section" select="$refentry.metadata/section"/>
        <xsl:with-param name="extra1"  select="$refentry.metadata/date"/>
        <xsl:with-param name="extra2"  select="$refentry.metadata/source"/>
        <xsl:with-param name="extra3"  select="$refentry.metadata/manual"/>
      </xsl:call-template>
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <!-- * Set default hyphenation, justification, indentation, and -->
      <!-- * line-breaking -->
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <xsl:call-template name="set.default.formatting"/>
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <!-- * Main body of man page -->
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <xsl:apply-templates/>
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <!-- * AUTHOR section -->
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <xsl:call-template name="author.section">
        <xsl:with-param name="info" select="$info"/>
      </xsl:call-template>
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <!-- * COPYRIGHT section -->
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <xsl:call-template name="copyright.section">
        <xsl:with-param name="info" select="$info"/>
      </xsl:call-template>
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <!-- * NOTES list (only if user wants endnotes numbered and/or listed) -->
      <!-- * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
      <xsl:if test="$man.endnotes.list.enabled != 0 or
                    $man.endnotes.are.numbered != 0">
        <xsl:call-template name="endnotes.list"/>
      </xsl:if>
    </xsl:variable> <!-- * end of manpage.contents -->

    <!-- * Prepare the page contents for final output, then store in -->
    <!-- * $manpage.contents.prepared so the we can pass it on to the -->
    <!-- * write.text.chunk() function -->
    <xsl:variable name="manpage.contents.prepared">
      <!-- * "Preparing" the page contents involves, at a minimum, -->
      <!-- * doubling any backslashes found (so they aren't interpreted -->
      <!-- * as roff escapes). -->
      <!-- * -->
      <!-- * If $charmap.enabled is true, "preparing" the page contents also -->
      <!-- * involves applying a character map to convert Unicode symbols and -->
      <!-- * special characters into corresponding roff escape sequences. -->
      <xsl:call-template name="prepare.manpage.contents">
        <xsl:with-param name="content" select="$manpage.contents"/>
      </xsl:call-template>
    </xsl:variable>
    
    <!-- * Write the prepared page contents to disk to create -->
    <!-- * the final man page. -->
    <xsl:call-template name="write.man.file">
      <xsl:with-param name="name" select="$first.refname"/>
      <xsl:with-param name="section" select="$refentry.metadata/section"/>
      <xsl:with-param name="lang" select="$lang"/>
      <xsl:with-param name="content" select="$manpage.contents.prepared"/>
    </xsl:call-template>

    <!-- * Generate "stub" (alias) pages (if any needed) -->
    <xsl:call-template name="write.stubs">
      <xsl:with-param name="first.refname" select="$first.refname"/>
      <xsl:with-param name="section" select="$refentry.metadata/section"/>
      <xsl:with-param name="lang" select="$lang"/>
    </xsl:call-template>

  </xsl:template>

</xsl:stylesheet>

<!-- vim:ts=2 sw=2
-->
