/***************************************************************************
 *   Copyright (C) 2003 by Gav Wood                                        *
 *   gav@cs.york.ac.uk                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 ***************************************************************************/
#ifndef __MARSYASPROCESSOR_H
#define __MARSYASPROCESSOR_H

#define __GEDDEI_BUILD

#include "processor.h"
using namespace geddei;

/**
@author Gav Wood
*/

class MarSystem;

class MarsyasProcessor: public Processor
{
	mutable MarSystem *theSystem;
	unsigned theNumInputs, theNumOutputs;

	virtual void processor();
	virtual const bool verifyAndSpecifyTypes(const SignalTypeRefs &inTypes, SignalTypeRefs &outTypes);
	virtual void initFromProperties(const Properties &properties);
	virtual PropertiesInfo specifyProperties() const;

public:
	MarsyasProcessor(MarSystem *system, const unsigned numInputs = 1, const unsigned numOutputs = 1);
	~MarsyasProcessor();
};

#endif
