/***************************************************************************
 *   Copyright (C) 2003 by Gav Wood                                        *
 *   gav@cs.york.ac.uk                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 ***************************************************************************/
#define __GEDDEI_BUILD

#include "marsyasprocessor.h"

#include <iostream>
#include <string>
using namespace std;

#include <qstring.h>

#include "wave.h"
#include "spectrum.h"
#include "properties.h"
using namespace geddei;

#include "marsyas/MarSystem.h"
#include "marsyas/MarControls.h"

#define MESSAGES 0

MarsyasProcessor::MarsyasProcessor(MarSystem *system, const unsigned numInputs, const unsigned numOutputs) : Processor("Marsyas"), theSystem(system), theNumInputs(numInputs), theNumOutputs(numOutputs)
{
}

MarsyasProcessor::~MarsyasProcessor()
{
	delete theSystem;
}

void MarsyasProcessor::processor()
{
	theSystem->update();
	unsigned osamples = theSystem->getctrl("natural/onSamples").toNatural();
	unsigned oscope = theSystem->getctrl("natural/onObservations").toNatural();
	unsigned isamples = theSystem->getctrl("natural/inSamples").toNatural();
	unsigned iscope = theSystem->getctrl("natural/inObservations").toNatural();
	if(MESSAGES) qDebug("%d,%d -> %d,%d", oscope, osamples, iscope, isamples);

	if(theNumInputs)
	{
		// TODO: need an equivalevt call...
//		unsigned maxElements = input(0).size();

//		if(maxElements < isamples * iscope)
//			cerr << "Not enough buffer!" << endl;
		// TODO: use maxelements to figure out if multiple marsyas cycles can be made in a single geddei cycle

		while(guard())
		{
			BufferData oData = output(0).makeScratchSamples(osamples);
			{	const BufferData iData = input(0).readSamples(isamples);
				realvec in((float *)iData.asArray(true), iscope, isamples);		// george hasn't go tthe const suff sorted yet...
				realvec out(oData.asArray(), oscope, osamples);
				if(!oData.isNull()) theSystem->process(in, out);
			}
			output(0) << oData;
		}
	}
	else
	{	realvec in(iscope, isamples);
		while(guard())
		{
			BufferData oData = output(0).makeScratchSamples(osamples);
			realvec out(oData.asArray(false), oscope, osamples);
			theSystem->process(in, out);
			output(0) << oData;
		}
	}
}

PropertiesInfo MarsyasProcessor::specifyProperties() const
{
	theSystem->setName(name());
	Properties p;
	map<string, MarControlValue> c = theSystem->getControls();
	for(map<string, MarControlValue>::iterator i = c.begin(); i != c.end(); i++)
	{	QString s = i->first;
		s.remove(("/" + theSystem->getPrefix()).c_str());
		// TODO: check if s is a real property
		switch(i->second.getType())
		{	case mar_real: p.set(s, i->second.toReal(), s); break;
			case mar_natural: p.set(s, (int)i->second.toNatural(), s); break;
			case mar_bool: p.set(s, bool(i->second.toBool()), s); break;
			case mar_string: p.set(s, i->second.toString().c_str(), s); break;
			default: cerr << "Property type not supported!" << endl;
		}
	}

	return p;
}

void MarsyasProcessor::initFromProperties(const Properties &properties)
{
	theSystem->setName(name());
	map<string, MarControlValue> c = theSystem->getControls();
	for(map<string, MarControlValue>::iterator i = c.begin(); i != c.end(); i++)
	{	QString s = i->first;
		s.remove(("/" + theSystem->getPrefix()).c_str());
		// TODO: check if s is a real property
		switch(i->second.getType())
		{	case mar_real: theSystem->updctrl(s.latin1(), properties.get(s.latin1()).toDouble()); break;
			case mar_natural: theSystem->updctrl(s.latin1(), (long)properties.get(s.latin1()).toInt()); break;
			case mar_bool: theSystem->updctrl(s.latin1(), properties.get(s.latin1()).toBool()); break;
			case mar_string: theSystem->updctrl(s.latin1(), (const char *)properties.get(s.latin1()).toString()); break;
			default: cerr << "Property type not supported!" << endl;
		}
	}
	setupIO(theNumInputs, theNumOutputs);
}

const bool MarsyasProcessor::verifyAndSpecifyTypes(const SignalTypeRefs &inTypes, SignalTypeRefs &outTypes)
{
	if(theNumInputs)
	{	theSystem->updctrl("natural/inObservations", (long)inTypes[0]->scope());
		theSystem->updctrl("real/israte", (float)inTypes[0]->frequency());
	}
	unsigned scope = theSystem->getctrl("natural/onObservations").toNatural();
	float freq = theSystem->getctrl("real/osrate").toReal();
	// TODO: this is bollocks
	if(scope == 1)
		outTypes[0] = new signaltypes::Wave(freq);
/*	else
		outTypes[0] = Spectrum(scope, freq);
*/	return true;
}



