#!/bin/bash

. ./common.sh $*

cd $SRCDIR
if [ "$FLG_RP" = "TRUE" ] ;then
  zpatch 0 $TLSRCDIR/reautoconf-parallel.diff
fi
./reautoconf || exit 1 # ǻ֤
TL_MAKE=$MAKE ./Build --enable-multiplatform --disable-native-texlive-build || exit 1

#
. $TLSRCDIR/common.sh $*

cd $SRCDIR/inst
cp -r texmf texmf.orig
cp -r $TLINSTDIR/texmf . 
cp texmf.orig/web2c/fmtutil.cnf texmf/web2c/fmtutil.cnf 
cp texmf.orig/web2c/texmf.cnf texmf/web2c/texmf.cnf
rm -rf texmf.orig
if [ "$FLG_UP" = "TRUE" ] ;then
  cd texmf
  zpatch 0 $TLSRCDIR/uptex/uptex-*-texmf-texlive2010.diff
  tarz $TLSRCDIR/uptex_font-*.tar.gz
  cd fonts/uptex_min/pl
  echo -e "\e[0;33m[building]  \e[0m umin7.tfm etc."
  $MAKE pl5 tfm5 vf5 &>/dev/null || exit 1
  cp u*.tfm ../../tfm/uptex/
  cp u*.vf ../../vf/uptex/
  cd ../../..
  rm -rf fonts/uptex_jis fonts/uptex_upjis fonts/uptex_map  fonts/uptex_min 
  cd ..
fi
if [ "$FLG_EP" = "TRUE" ] ;then
    cd texmf
    mkdir -p tex/ptex/base
    mkdir -p tex/ptexgeneric/config
    cp $TLSRCDIR/eptex/eptex.src tex/ptex/base
    cp $TLSRCDIR/eptex/euptex.src tex/ptex/base
    cp $TLSRCDIR/eptex/language.def tex/ptex/base
    cp $TLSRCDIR/eptex/eptexdefs.lib tex/ptex/base
    cd ..
fi

# map for dvipdfmx
sedwrite texmf/dvipdfmx/dvipdfmx.cfg "s/cid-x.map/kanjix.map/"
echo -e "\e[0;33m[rewriting] \e[0m updmap.cfg"
cat <<EOF >> texmf/web2c/updmap.cfg || exit
#
# map for pTeX
KanjiMap morisawa.map
EOF

mkdir -p $XMAP
echo -e "\e[0;33m[writing]   \e[0m morisawa.map"
cat <<EOF > $XMAP/morisawa.map
%%
%% Morisawa
%%
ryumin-l    H   Ryumin-Light
ryumin-l-v  V   Ryumin-Light
gtbbb-m     H   GothicBBB-Medium
gtbbb-m-v   V   GothicBBB-Medium
futomin-b   H   FutoMinA101-Bold
futomin-b-v V   FutoMinA101-Bold
futogo-b    H   FutoGoB101-Bold
futogo-b-v  V   FutoGoB101-Bold
jun101-l    H   Jun101-Light
jun101-l-v  V   Jun101-Light
EOF

if [ "$FLG_UP" = "TRUE" ] ;then
  echo -e "\e[0;33m[rewriting] \e[0m updmap.cfg"
  echo "KanjiMap uptex-ckt.map" >> texmf/web2c/updmap.cfg || exit
  echo -e "\e[0;33m[writing]   \e[0m uptex-ckt.map"
  cat <<EOF > $XMAP/uptex-ckt.map
%%
%% Chinese/Korean fonts for upTeX
%%
upstsl-h        UniGB-UTF16-H           !STSong-Light
upstsl-v        UniGB-UTF16-V           !STSong-Light
upstht-h        UniGB-UTF16-H           !STHeiti-Regular
upstht-v        UniGB-UTF16-V           !STHeiti-Regular
upmsl-h         UniCNS-UTF16-H          !MSung-Light
upmsl-v         UniCNS-UTF16-V          !MSung-Light
upmhm-h         UniCNS-UTF16-H          !MHei-Medium
upmhm-v         UniCNS-UTF16-V          !MHei-Medium
uphysmjm-h      UniKS-UTF16-H           !HYSMyeongJo-Medium
uphysmjm-v      UniKS-UTF16-V           !HYSMyeongJo-Medium
uphygt-h        UniKS-UTF16-H           !HYGoThic-Medium
uphygt-v        UniKS-UTF16-V           !HYGoThic-Medium
EOF
  cp $TLSRCDIR/uptex/convbkmk.rb $SRCDIR/inst/bin/$ARCH/
fi
exit 0
