#ifndef __DBUS_PROXY_DBUS_HAL_MANAGER_H
#define __DBUS_PROXY_DBUS_HAL_MANAGER_H

#include <dbus-cxx.h>


namespace DBus {
  namespace Hal {

    class ManagerProxy : public ::DBus::ObjectProxy
    {
      protected:
        ManagerProxy( ::DBus::Connection::pointer conn, const std::string& dest="org.freedesktop.Hal", const std::string& path="/org/freedesktop/Hal/Manager"):
          ::DBus::ObjectProxy(conn, dest, path)
        {
          ::DBus::Path child_path;

          m_method_DeviceExists_bs = this->create_method< bool,std::string >( "org.freedesktop.Hal.Manager", "DeviceExists" );
          m_method_NewDevice_s = this->create_method< std::string >( "org.freedesktop.Hal.Manager", "NewDevice" );
          m_method_Remove_vs = this->create_method< void,std::string >( "org.freedesktop.Hal.Manager", "Remove" );
          m_method_CommitToGdl_vss = this->create_method< void,std::string,std::string >( "org.freedesktop.Hal.Manager", "CommitToGdl" );
          m_method_AcquireGlobalInterfaceLock_vsb = this->create_method< void,std::string,bool >( "org.freedesktop.Hal.Manager", "AcquireGlobalInterfaceLock" );
          m_method_ReleaseGlobalInterfaceLock_vs = this->create_method< void,std::string >( "org.freedesktop.Hal.Manager", "ReleaseGlobalInterfaceLock" );
          m_method_SingletonAddonIsReady_vs = this->create_method< void,std::string >( "org.freedesktop.Hal.Manager", "SingletonAddonIsReady" );
          m_signal_DeviceAdded = this->create_signal<void,std::string>( "org.freedesktop.Hal.Manager", "DeviceAdded" );
          m_signal_DeviceRemoved = this->create_signal<void,std::string>( "org.freedesktop.Hal.Manager", "DeviceRemoved" );
          m_signal_NewCapability = this->create_signal<void,std::string,std::string>( "org.freedesktop.Hal.Manager", "NewCapability" );
          m_signal_GlobalInterfaceLockAcquired = this->create_signal<void,std::string,std::string,int32_t>( "org.freedesktop.Hal.Manager", "GlobalInterfaceLockAcquired" );
          m_signal_GlobalInterfaceLockReleased = this->create_signal<void,std::string,std::string,int32_t>( "org.freedesktop.Hal.Manager", "GlobalInterfaceLockReleased" );
        }

      public:

        typedef DBusCxxPointer<ManagerProxy> pointer;

        static pointer create( ::DBus::Connection::pointer conn,
                               const std::string& dest="org.freedesktop.Hal",
                               const std::string& path="/org/freedesktop/Hal/Manager"
                             )
        { return pointer( new ManagerProxy(conn, dest, path)); }


        /* can't create proxy for method GetAllDevices */

        /* can't create proxy for method GetAllDevicesWithProperties */

        bool DeviceExists( std::string udi ) { return (*m_method_DeviceExists_bs)( udi); }

        /* can't create proxy for method FindDeviceStringMatch */

        /* can't create proxy for method FindDeviceByCapability */

        std::string NewDevice( ) { return (*m_method_NewDevice_s)(); }

        void Remove( std::string udi ) { return (*m_method_Remove_vs)( udi); }

        void CommitToGdl( std::string temporary_udi, std::string global_udi ) { return (*m_method_CommitToGdl_vss)( temporary_udi, global_udi); }

        void AcquireGlobalInterfaceLock( std::string interface_name, bool exclusive ) { return (*m_method_AcquireGlobalInterfaceLock_vsb)( interface_name, exclusive); }

        void ReleaseGlobalInterfaceLock( std::string interface_name ) { return (*m_method_ReleaseGlobalInterfaceLock_vs)( interface_name); }

        void SingletonAddonIsReady( std::string command_line ) { return (*m_method_SingletonAddonIsReady_vs)( command_line); }

        ::DBus::signal_proxy<void,std::string >& signal_DeviceAdded() { return *m_signal_DeviceAdded; }

        ::DBus::signal_proxy<void,std::string >& signal_DeviceRemoved() { return *m_signal_DeviceRemoved; }

        ::DBus::signal_proxy<void,std::string,std::string >& signal_NewCapability() { return *m_signal_NewCapability; }

        ::DBus::signal_proxy<void,std::string,std::string,int32_t >& signal_GlobalInterfaceLockAcquired() { return *m_signal_GlobalInterfaceLockAcquired; }

        ::DBus::signal_proxy<void,std::string,std::string,int32_t >& signal_GlobalInterfaceLockReleased() { return *m_signal_GlobalInterfaceLockReleased; }


      protected:


        ::DBus::MethodProxy<bool,std::string>::pointer m_method_DeviceExists_bs;
        ::DBus::MethodProxy<std::string>::pointer m_method_NewDevice_s;
        ::DBus::MethodProxy<void,std::string>::pointer m_method_Remove_vs;
        ::DBus::MethodProxy<void,std::string,std::string>::pointer m_method_CommitToGdl_vss;
        ::DBus::MethodProxy<void,std::string,bool>::pointer m_method_AcquireGlobalInterfaceLock_vsb;
        ::DBus::MethodProxy<void,std::string>::pointer m_method_ReleaseGlobalInterfaceLock_vs;
        ::DBus::MethodProxy<void,std::string>::pointer m_method_SingletonAddonIsReady_vs;
        ::DBus::signal_proxy<void,std::string>::pointer m_signal_DeviceAdded;
        ::DBus::signal_proxy<void,std::string>::pointer m_signal_DeviceRemoved;
        ::DBus::signal_proxy<void,std::string,std::string>::pointer m_signal_NewCapability;
        ::DBus::signal_proxy<void,std::string,std::string,int32_t>::pointer m_signal_GlobalInterfaceLockAcquired;
        ::DBus::signal_proxy<void,std::string,std::string,int32_t>::pointer m_signal_GlobalInterfaceLockReleased;


    };

  }
}

#endif
