#ifndef __DBUS_ADAPTER_DBUS_EXAMPLE_COMPUTER_H
#define __DBUS_ADAPTER_DBUS_EXAMPLE_COMPUTER_H

#include <dbus-cxx.h>

#include "computer.h"

#include "calculator_adapter.h"

#ifndef __DBUS_EXAMPLES__COMPUTER__OPERATION_ITERATOR_SUPPORT
  #define __DBUS_EXAMPLES__COMPUTER__OPERATION_ITERATOR_SUPPORT
  DBUS_CXX_ITERATOR_SUPPORT( Examples::Computer::Operation , uint32_t )
#endif


namespace DBus {
  namespace Example {

    class ComputerAdapter : public CalculatorAdapter
    {
      protected:
        ComputerAdapter( Examples::Computer* adaptee=NULL, const std::string& path="/dbuscxx/example/Computer"):
          CalculatorAdapter(adaptee, path),
          m_adaptee(adaptee)
        {

          ::DBus::MethodBase::pointer temp_method;

          temp_method = this->create_method<uint64_t,Examples::Computer::Operation,uint8_t>( "Computer.Basic", "compute", sigc::mem_fun(*this, &ComputerAdapter::compute_adapter_stub_tuy) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "op" );
          temp_method->set_arg_name( 2, "n" );
          temp_method = this->create_method<uint64_t,uint8_t>( "Computer.Basic", "factorial", sigc::mem_fun(*this, &ComputerAdapter::factorial_adapter_stub_ty) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "n" );
          temp_method = this->create_method<uint64_t,uint8_t>( "Computer.Basic", "fibonacci", sigc::mem_fun(*this, &ComputerAdapter::fibonacci_adapter_stub_ty) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "n" );
          temp_method = this->create_method<uint64_t,uint8_t>( "Computer.Basic", "thue_morse", sigc::mem_fun(*this, &ComputerAdapter::thue_morse_adapter_stub_ty) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "n" );
          temp_method = this->create_method<Examples::Computer::Operation>( "Computer.Basic", "last_op", sigc::mem_fun(*this, &ComputerAdapter::last_op_adapter_stub_u) );
          temp_method->set_arg_name( 0, "op" );
          m_signal_adapter_computation = this->create_signal<void,std::string,uint64_t,uint8_t>("Computer.Basic","computation");
          m_signal_adapter_computation->set_arg_name( 0, "algorithm" );
          m_signal_adapter_computation->set_arg_name( 1, "result" );
          m_signal_adapter_computation->set_arg_name( 2, "n" );
          if ( m_adaptee ) m_signal_adapter_connection_computation = m_adaptee->signal_computation().connect( *m_signal_adapter_computation );
          m_signal_adapter_operation = this->create_signal<void,Examples::Computer::Operation>("Computer.Basic","operation");
          m_signal_adapter_operation->set_arg_name( 0, "type" );
          if ( m_adaptee ) m_signal_adapter_connection_operation = m_adaptee->signal_op().connect( *m_signal_adapter_operation );
        }

      public:

        typedef DBusCxxPointer<ComputerAdapter> pointer;

        static pointer create( Examples::Computer* adaptee=NULL, const std::string& path="/dbuscxx/example/Computer")
          { return pointer( new ComputerAdapter(adaptee, path)); }

        Examples::Computer* adaptee() { return m_adaptee; }

        void set_adaptee( Examples::Computer* adaptee ) {
          m_adaptee = adaptee;
          m_signal_adapter_connection_computation.disconnect();
          m_signal_adapter_connection_operation.disconnect();
          if ( m_adaptee ) m_signal_adapter_connection_computation = m_adaptee->signal_computation().connect( *m_signal_adapter_computation );
          if ( m_adaptee ) m_signal_adapter_connection_operation = m_adaptee->signal_op().connect( *m_signal_adapter_operation );
        }

        void set_adaptee( Examples::Computer& adaptee ) {
          this->set_adaptee(&adaptee);
        }


      private:

        Examples::Computer* m_adaptee;


        void check_adaptee() { if ( not m_adaptee) throw ::DBus::ErrorInvalidAdaptee::create(); }

        uint64_t compute_adapter_stub_tuy( Examples::Computer::Operation op, uint8_t n ) { this->check_adaptee(); return m_adaptee->compute( op, n); }
        uint64_t factorial_adapter_stub_ty( uint8_t n ) { this->check_adaptee(); return m_adaptee->factorial( n); }
        uint64_t fibonacci_adapter_stub_ty( uint8_t n ) { this->check_adaptee(); return m_adaptee->fibonacci( n); }
        uint64_t thue_morse_adapter_stub_ty( uint8_t n ) { this->check_adaptee(); return m_adaptee->thue_morse( n); }
        Examples::Computer::Operation last_op_adapter_stub_u( ) { this->check_adaptee(); return m_adaptee->last_op(); }
        ::DBus::signal<void,std::string,uint64_t,uint8_t>::pointer m_signal_adapter_computation;
        sigc::connection m_signal_adapter_connection_computation;
        ::DBus::signal<void,Examples::Computer::Operation>::pointer m_signal_adapter_operation;
        sigc::connection m_signal_adapter_connection_operation;


    };

  }
}

#endif
