#ifndef __DBUS_ADAPTER_DBUS_EXAMPLE_COMPUTER_H
#define __DBUS_ADAPTER_DBUS_EXAMPLE_COMPUTER_H

#include <dbus-cxx.h>

#include "computer.h"

#include "calculator_adapter.h"

namespace DBus {
  namespace Example {

    class ComputerAdapter : public ::DBus::Object
    {
      protected:
        ComputerAdapter( Examples::Computer* adaptee=NULL, const std::string& path="/dbuscxx/example/Computer"):
          ::DBus::Object(path),
          m_adaptee(adaptee)
        {

          ::DBus::MethodBase::pointer temp_method;

          temp_method = this->create_method<uint64_t,uint8_t>( "Computer.Basic", "factorial", sigc::mem_fun(*this, &ComputerAdapter::factorial_adapter_stub_ty) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "n" );
          temp_method = this->create_method<uint64_t,uint8_t>( "Computer.Basic", "fibonacci", sigc::mem_fun(*this, &ComputerAdapter::fibonacci_adapter_stub_ty) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "n" );
          temp_method = this->create_method<uint64_t,uint8_t>( "Computer.Basic", "thue_morse", sigc::mem_fun(*this, &ComputerAdapter::thue_morse_adapter_stub_ty) );
          temp_method->set_arg_name( 0, "result" );
          temp_method->set_arg_name( 1, "n" );
          m_signal_adapter_computation = this->create_signal<void,std::string,uint64_t,uint8_t>("Computer.Basic","computation");
          m_signal_adapter_computation->set_arg_name( 0, "algorithm" );
          m_signal_adapter_computation->set_arg_name( 1, "result" );
          m_signal_adapter_computation->set_arg_name( 2, "n" );
          if ( m_adaptee ) m_signal_adapter_connection_computation = m_adaptee->signal_computation().connect( *m_signal_adapter_computation );

          ::DBus::Path child_path;
          
          child_path = path;
          child_path.append_element("Calculator");
          DBUS_CXX_DEBUG( "Calculator:constructor: child path = " << child_path);
          m_Calculator = CalculatorAdapter::create(NULL, child_path);          this->add_child("Calculator", m_Calculator);
          if ( adaptee ) m_Calculator->set_adaptee(&(adaptee->calculator()));
        }

      public:

        typedef DBusCxxPointer<ComputerAdapter> pointer;

        static pointer create( Examples::Computer* adaptee=NULL, const std::string& path="/dbuscxx/example/Computer")
          { return pointer( new ComputerAdapter(adaptee, path)); }

        Examples::Computer* adaptee() { return m_adaptee; }

        void set_adaptee( Examples::Computer* adaptee ) {
          m_adaptee = adaptee;
          m_signal_adapter_connection_computation.disconnect();
          if ( m_adaptee ) m_signal_adapter_connection_computation = m_adaptee->signal_computation().connect( *m_signal_adapter_computation );
          if ( m_adaptee ) {
            m_Calculator->set_adaptee( m_adaptee->calculator() );
          }
          else {
            m_Calculator->set_adaptee( NULL );
          }
        }

        CalculatorAdapter::pointer calculator() { return m_Calculator; }

        void set_adaptee( Examples::Computer& adaptee ) {
          this->set_adaptee(&adaptee);
        }


      private:

        Examples::Computer* m_adaptee;

        CalculatorAdapter::pointer m_Calculator;

        void check_adaptee() { if ( not m_adaptee) throw ::DBus::ErrorInvalidAdaptee::create(); }

        uint64_t factorial_adapter_stub_ty( uint8_t n ) { this->check_adaptee(); return m_adaptee->factorial( n); }
        uint64_t fibonacci_adapter_stub_ty( uint8_t n ) { this->check_adaptee(); return m_adaptee->fibonacci( n); }
        uint64_t thue_morse_adapter_stub_ty( uint8_t n ) { this->check_adaptee(); return m_adaptee->thue_morse( n); }
        ::DBus::signal<void,std::string,uint64_t,uint8_t>::pointer m_signal_adapter_computation;
        sigc::connection m_signal_adapter_connection_computation;


    };

  }
}

#endif
