#ifndef DEBUG
#ifdef __GNUC__
#if __GNUC_MINOR__ >= 3
# define HIDDEN  __attribute__((visibility ("hidden")))
# define USED    __attribute__((__used__))
#else
# define USED    __attribute__((__unused__))
#endif
#endif
#endif

#ifndef HIDDEN
#define HIDDEN
#endif

#ifndef USED
#define USED
#endif

extern void crc_init(int a, int b, int c, int d, int e) HIDDEN;
extern void crc_put(unsigned int y) HIDDEN;
extern void crc_block(unsigned int *q, int n) HIDDEN;
extern char *crc_get() HIDDEN;

extern int  real_execv(const char *name, char *const argv[]) HIDDEN;
extern int  real_execve(const char *name, char *const argv[], char *const envp[]) HIDDEN;

extern int  exec_cachecc1(char *name, char *argv[], char *envp[]) HIDDEN;

extern int  distcc1(char *name, char *argv[], char *nargv[],
                    char*input, char *output, char*compname) HIDDEN;

extern int  send(int f, void *p, int n) HIDDEN;
extern void copy(int f, int g, char *despair) HIDDEN;
extern char **read_env(char *envp[])  HIDDEN;
extern char *env_log HIDDEN;
extern char *env_dir HIDDEN;
extern char *env_opts HIDDEN;
extern char *env_ifgcc3 HIDDEN;
extern char *env_distcc HIDDEN;
extern char *env_distccdir HIDDEN;
extern char *env_ignorewarnings HIDDEN;
extern unsigned char opts[256] HIDDEN;

/*
 * opts that control the cache behaviour
 */
#define OPTS_NO_R_C   opts['c']
#define OPTS_NO_W_C   opts['C']
#define OPTS_NO_R_CPP opts['p']
#define OPTS_NO_W_CPP opts['P']
#define OPTS_NO_R_AS  opts['s']
#define OPTS_NO_W_AS  opts['S']

#ifdef DEBUG
extern void debug_str(char *s);
extern void debug_int(unsigned int n);
#endif

/* arch-tag: 734846b8-ca84-440b-a368-9c9c1d9b5bc7 */
