// BESUtil.h

// This file is part of bes, A C++ back-end server implementation framework
// for the OPeNDAP Data Access Protocol.

// Copyright (c) 2004-2009 University Corporation for Atmospheric Research
// Author: Patrick West <pwest@ucar.edu> and Jose Garcia <jgarcia@ucar.edu>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact University Corporation for Atmospheric Research at
// 3080 Center Green Drive, Boulder, CO 80301
 
// (c) COPYRIGHT University Corporation for Atmospheric Research 2004-2005
// Please read the full copyright statement in the file COPYRIGHT_UCAR.
//
// Authors:
//      pwest       Patrick West <pwest@ucar.edu>
//      jgarcia     Jose Garcia <jgarcia@ucar.edu>

#ifndef E_BESUtil_h
#define E_BESUtil_h 1

#include <string>
#include <list>
#include <iostream>

using std::string ;
using std::list ;
using std::ostream ;

class BESUtil
{
private:
    static string		rfc822_date( const time_t t ) ;

    static string		entity( char c ) ;
public:
    /** These functions are used to create the MIME headers for a message
	from a server to a client.

	NB: These functions actually write both the response status line
	<i>and</i> the header.

	@name MIME utility functions
	@see DODSFilter
    */
    static void			set_mime_text( ostream &strm ) ;
    static void			set_mime_html( ostream &strm ) ;

    /** This functions are used to unescape hex characters from strings **/
    static string		www2id( const string &in,
				        const string &escape = "%",
				        const string &except = "" ) ;
    static string		unhexstring( string s ) ;

    /** Convert a string to all lower case **/
    static string		lowercase( const string &s ) ;

    /** Unescape characters with backslash before them **/
    static string		unescape( const string &s ) ;

    /** Check if the specified path is valid **/
    static void			check_path( const string &path,
					    const string &root,
					    bool follow_sym_links ) ;

    /** convert pid and place in provided buffer **/
    static char *		fastpidconverter( char *buf,
						  int base ) ;
    static char *		fastpidconverter( long val,
						  char *buf,
						  int base ) ;

    /** remove leading and trailing blanks from a string **/
    static void			removeLeadingAndTrailingBlanks( string &key ) ;

    /** convert characters not allowed in xml to escaped characters **/
    static string		id2xml( string in,
				        const string &not_allowed = "><&'\"" ) ;

    /** unescape xml escaped characters **/
    static string		xml2id( string in ) ;

    /** explode a string into an array given a delimiter **/
    static void			explode( char delim, const string &str,
					 list<string> &values ) ;

    /** implode a list of values into a single string delimited by delim **/
    static string		implode( const list<string> &values,
					 char delim ) ;
} ;

#endif // E_BESUtil_h

