#!/bin/bash
# -*- shell-script -*-

test_fns_copies()
{
    typeset result='bogus'

#     _Dbg_copies 'a' 'b'
#     assertFalse '_Dbg_copies "a" "b" should fail' "$?"

    _Dbg_copies 'a' -1
    assertFalse '_Dbg_copies "a" -1 should fail' "$?"

    _Dbg_copies 'a' 3
    assertTrue '_Dbg_copies "a" 3 should succeed' "$?"
    assertEquals 'aaa' $result

    _Dbg_copies ' ab' 4
    assertTrue '_Dbg_copies " ab" 4 should succeed' "$?"
    assertEquals ' ab ab ab ab' "$result"
}

test_fns_defined()
{
    typeset p=5
    _Dbg_defined p
    assertTrue 'p should be defined' "$?"
    unset p
    _Dbg_defined p
    assertFalse 'p should now not defined' "$?"
}

test_fns_esc_dq()
{
    check_esc_dq () {
	local orig="$1"
	local transform="$(_Dbg_esc_dq "$orig")"
	eval 'got=$(echo "$1")'
	assertEquals "$orig" "$got"
    }
    check_esc_dq 'Now is the time'
    check_esc_dq '"Now is the time"'
    check_esc_dq 'Make $$'

    assertEquals 'abc' $(_Dbg_esc_dq abc)
    assertEquals '\\\"abc\\\"' $(_Dbg_esc_dq '\"abc\"')
    assertEquals '\\\"a\\bc\\\"' $(_Dbg_esc_dq '\"a\bc\"')
}

test_fns_is_function()
{
    _Dbg_is_function 
    assertFalse 'No function given; is_function should report false' $? 

    unset -f function_test
    _Dbg_is_function function_test
    assertFalse 'function_test should not be defined' "$?"

    typeset -i function_test=1
    _Dbg_is_function function_test
    assertFalse 'test_function should still not be defined' "$?"

    function_test() { :; }
    _Dbg_is_function function_test
    assertTrue 'test_function should now be defined' "$?"

    function another_function_test { :; }
    _Dbg_is_function another_function_test "$?"

    _function_test() { :; }
    _Dbg_is_function _function_test
    assertFalse 'fn _function_test is system fn; is_function should report false' $? 

    _Dbg_is_function _function_test 1 
    assertTrue 'fn _function_test is system fn which we want; should report true' $? 

}

test_fns_traced()
{
    set +x
    _Dbg_is_traced 
    assertFalse 'is_traced should be false' "$?"

    { 
      set -x
      _Dbg_is_traced 
      rc=$?
      set +x
    } 2>/dev/null
    assertTrue 'is_traced should be true' "$rc"
}

test_fns_onoff()
{
    assertEquals 'on.' $(_Dbg_onoff 1)
    assertEquals 'off.' $(_Dbg_onoff 0)
}

test_fns_parse_linespec()
{
    # Necessary set up for function call.
    typeset _seteglob='local __eopt=-u ; shopt -q extglob && __eopt=-s ; shopt -s extglob'
    shopt -s extdebug
    typeset int_pat="[0-9]*([0-9])"
    typeset -i _Dbg_set_debug=1

    function foo { echo 'foo here'; }
    typeset -a words=( $(_Dbg_parse_linespec 'foo:4') )
    assertEquals  'a' '4' ${words[0]}
    assertEquals  'b' '0' ${words[1]}

    typeset -a words=( $(_Dbg_parse_linespec 'test_fns_defined') )
    assertEquals 'c' '23' ${words[0]}
    assertEquals  'd' '1' ${words[1]}

    typeset -a words=( $(_Dbg_parse_linespec '_Dbg_parse_linespec') )
    assertEquals  'e' '3' ${#words[@]}

    typeset _Dbg_set_debug=0
    typeset -a words=( $(_Dbg_parse_linespec '_Dbg_parse_linespec') )
    assertEquals  'e' '0' ${#words[@]}

    unset foo
    typeset -a words=( $(_Dbg_parse_linespec 'foo') )
    assertEquals 'f' '0' ${#words[@]}
}

test_set_debugger_internal()
{
    typeset  _Dbg_space_IFS=' '
    _Dbg_set_debugger_internal
    assertEquals "$_Dbg_space_IFS" "$IFS"
    assertEquals '+ dbg (${BASH_SOURCE}:${LINENO}[$BASH_SUBSHELL]): ${FUNCNAME[0]}\n' "$PS4"
}

# Test _Dbg_set_dol_q
test_fns_set_q()
{
    _Dbg_set_dol_q 1 
    assertFalse '$? should have been set to 1==false' $? 
    _Dbg_set_dol_q 0 
    assertTrue '$? should have been set to 0==true' $? 
    # Test without giving a parameter
    local _Ddg_debugged_exit_code=0
    _Dbg_set_dol_q 
    assertTrue '$? should be set true via _Dbg_debugged_exit_code' $? 
    _Ddg_debugged_exit_code=1
    # _Dbg_set_dol_q
    # assertFalse '$? should be set false via _Dbg_debugged_exit_code' $? 
}

test_fns_split()
{
    typeset -a words
    words=($(_Dbg_split ':' 'foo:bar'))
    assertEquals 'foo' ${words[0]}
    assertEquals 'bar' ${words[1]}
    words=($(_Dbg_split ':' 'foo'))
    assertEquals 'foo' ${words[0]}
}

abs_top_srcdir=/src/external-vcs/sourceforge/bashdb
# Make sure $abs_top_srcrdir has a trailing slash
abs_top_srcdir=${abs_top_srcdir%%/}/
. ${abs_top_srcdir}test/unit/helper.sh
. ${abs_top_srcdir}init/pre.sh
. ${abs_top_srcdir}lib/fns.sh
. ${abs_top_srcdir}lib/journal.sh
. ${abs_top_srcdir}lib/save-restore.sh
. ${abs_top_srcdir}lib/validate.sh
set -- # reset $# so shunit2 doesn't get confused.

[[ $0 == ${BASH_SOURCE} ]] && . ${shunit_file}
