#!/usr/bin/env python

from ez_setup import use_setuptools
use_setuptools()
from setuptools import setup, find_packages

setup(
	name='TGExpandingFormWidget',
    version='0.1.3',
    description='This module provides a dynamically expandable form widget for TurboGears.',
	long_description="""\
TGExpandingFormWidget is a type of repeating form widget for TurboGears. It contains groups of widgets which are repeated on the page. The user is able to dynamically add or remove widget groups as required before submitting the form.

This widget is based on dynwidget by Randall Smith.  It has been cleaned up and bug-fixed by Chris Miles and released with Randall's permission.
""",
    author='Chris Miles',
    author_email='miles.chris@gmail.com',
    url='http://www.psychofx.com/TGExpandingFormWidget/',
    license='MIT',
    packages=['tg_expanding_form_widget'],
    install_requires = ["TurboGears>=1.0.1"],
    include_package_data = True,
    zip_safe=False,
    keywords = [
        'turbogears.widgets',
    ],
    classifiers = [
        'Development Status :: 3 - Alpha',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Framework :: TurboGears',
        'Framework :: TurboGears :: Widgets',
    ],
)
