package Rast::Db;

use strict;

use Rast;
use Rast::Result;

DESTROY {
    my $self = shift;
    $self->close();
}
sub new {
    my $class = shift;
    my $self = bless {}, $class;
    return $self;
}

sub register {
    my $self = shift;
    $self->update(@_, 0);
}

sub update {
    my $self = shift;
    my $content = shift;
    my $properties = shift;
    my $old_id = shift;
    my @to = ();

    Carp::croak("not content")
	unless $content;

    Carp::croak("not array of properties")
	if (ref($properties) ne 'ARRAY');
    
    my $num = $self->get_num_properties;

    $old_id = 0
	unless $old_id =~ /^\d+$/;

    for (my $i = 0;$i < $num;$i++) {
	my $type = $self->get_properties_type($i);
        if ($properties->[$i]) {
	    if ($type eq Rast::RAST_TYPE_STRING()) {
		$to[$i] = $properties->[$i];
	    } elsif ($type eq Rast::RAST_TYPE_DATE()) {
		if ($properties->[$i] =~ /^\d\d\d\d-\d\d-\d\dT\d\d:\d\d:\d\d$/) {
		    $to[$i] = $properties->[$i];
		} else {
		    Carp::croak("properties format error");
		}
	    } elsif ($type eq Rast::RAST_TYPE_UINT()) {
		if ($properties->[$i] =~ /^\d+$/) {
		    $to[$i] = $properties->[$i];
		} else {
		    Carp::croak("properties format error");
		}
	    } else {
		Carp::croak("properties type error");
	    }
        } else {
	    if ($type eq Rast::RAST_TYPE_STRING()) {
		$to[$i] = "";
	    } elsif ($type eq Rast::RAST_TYPE_DATE()) {
		$to[$i] = "0000-00-00T00:00:00";
	    } elsif ($type eq Rast::RAST_TYPE_UINT()) {
		$to[$i] = 0;
	    } else {
		Carp::croak("properties type error");
	    }
        }
    }

    $self->_update_register($content, length($content), \@to, $old_id);
}

sub search {
    my $self    = shift;
    my $query   = shift;
    my $options = shift;

    Carp::croak("no query")
	unless $query;

    $options->{start_no} = 0
	unless $options->{start_no} =~ /^\d+$/;

    $options->{num_items} = Rast::RAST_RESULT_ALL_ITEMS()
	unless $options->{num_items} =~ /^\d+$/ || $options->{num_items} eq Rast::RAST_RESULT_ALL_ITEMS();

    $options->{need_summary} = 0
	unless $options->{need_summary} eq 1;

    $options->{summary_nchars} = 100
	unless $options->{summary_nchars} =~ /^\d+$/;

    if ($options->{sort_property}) {
	$options->{sort_method} = Rast::RAST_SORT_METHOD_PROPERTY();
    } else {
	$options->{sort_method} = Rast::RAST_SORT_METHOD_SCORE();
    }

    $options->{sort_order} = Rast::RAST_SORT_ORDER_DEFAULT()
	unless ($options->{sort_order} eq Rast::RAST_SORT_ORDER_DEFAULT() ||
		$options->{sort_order} eq Rast::RAST_SORT_ORDER_ASCENDING() ||
		$options->{sort_order} eq Rast::RAST_SORT_ORDER_DESCENDING());

    $options->{score_method} = Rast::RAST_SCORE_METHOD_TFIDF()
	unless ($options->{score_method} eq Rast::RAST_SCORE_METHOD_NONE() || $options->{score_method} eq Rast::RAST_SCORE_METHOD_TFIDF());

    $options->{num_properties} = 0;
    my %pstack;
    my @properties;
    foreach my $p (@{$options->{properties}}) {
	#check property name
        next if $pstack{$p};
        $pstack{$p} = 1;
        push(@properties, $p);
	$options->{num_properties}++;
    }
    $options->{properties} = \@properties;
    $self = $self->_search($query, $options);
    return undef unless $self;
}

1;
