"""
File:		Main.py
Purpose:	Controller

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException("Python")

# PyQt4
try :

	#from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui

except :
	Import.slException("PyQt4")

# App 2
import	Archive, Event, File, Help, Input, Settings
try :
	from	Main_rc			import *
	from	Settings_rc		import *
	from	Ui_Main			import Ui_Main
	from	Ui_Settings		import Ui_Settings
except :
	Import.slException(Settings.Application.sName)


### Variables

# Visible?
if not Import.Init.bInvisible :

	# Main
	aMain			= QtGui.QApplication(sys.argv)
	mwMain			= QtGui.QMainWindow()
	uiMain			= Ui_Main()
	uiMain.setupUi(mwMain)

	# Settings
	dSettings		= QtGui.QDialog()
	uiSettings		= Ui_Settings()
	uiSettings.setupUi(dSettings)


### Slots


### Execution

# Test dirs
File.slTestDirs()

# Info
File.slAbout()

# Events
Event.slConnections()

# CLI Arguments
Input.slArgTest()

# Settings
Settings.slInits()

# Test profiles
File.slTestProfiles()

# Start
Archive.slStart()

# Update
Help.slUCheck()

# Visible?
if not Import.Init.bInvisible :
	# Event Loop
	aMain.exec_()

# Temporary
