"""
File:		File.py
Purpose:	File handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# Python
try :
	from subprocess import *
except :
	Import.slException("Python")

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException("PyQt4")

# App 2
import	Display, Help, Profile, Settings


### Variables


### Slots

# Review output
def slReview() :

	sName = ""
	sPath = Settings.Path.App.sConfig + "/Output/"

	# Choose file
	if len(sName) :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getOpenFileName(None, Settings.Application.sName + " - Open File", sPath, "Outputs (*.txt)")

	if len(sPath) :

		if not sPath.lower().endswith(".txt") :
			sPath += ".txt"

		# Read list file
		fLog = QtCore.QFile(sPath)

		# Determine filename
		sName = fLog.fileName().rsplit("/", 1)[1].rsplit('.', 1)[0]

		# Test existence
		if not fLog.exists() :
			# Messages
			Display.slMessage(Settings.Message.iError, "Can't review the '" + sName + "' output")
		else :
			Help.slUOpen(QtCore.QUrl("file:" + sPath))


# About
def slAbout() :

	slMessage(Settings.Message.iInformation, "\n- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n")

	# Message
	slMessage(Settings.Message.iInformation, Settings.Application.sAbout1)


# Variables
def slVariables() :

	# Message
	slMessage(Settings.Message.iInformation, "OS = " + Settings.sOS)

	slMessage(Settings.Message.iInformation, "KDE Version = " + Settings.Env.sKDESV)
	slMessage(Settings.Message.iInformation, "KDE Config = " + Settings.Path.KDE.sConfig)
	slMessage(Settings.Message.iInformation, "KDE Prefix = " + Settings.Path.KDE.sPrefix)
	slMessage(Settings.Message.iInformation, "KDE Local Prefix = " + Settings.Path.KDE.sLocalPrefix)
	slMessage(Settings.Message.iInformation, "Sys Prefix = " + Settings.Path.Sys.sPrefix)
	slMessage(Settings.Message.iInformation, "Sys SBin = " + Settings.Path.Sys.sSBin)
	slMessage(Settings.Message.iInformation, "Sys Bin = " + Settings.Path.Sys.sBin)

	slMessage(Settings.Message.iInformation, "Local Prefix = " + Settings.Path.Local.sPrefix)
	slMessage(Settings.Message.iInformation, "Local SBin = " + Settings.Path.Local.sSBin)
	slMessage(Settings.Message.iInformation, "Local Bin = " + Settings.Path.Local.sBin)

	slMessage(Settings.Message.iInformation, Settings.Application.sName + " Prefix = " + Settings.Path.App.sPrefix)
	slMessage(Settings.Message.iInformation, Settings.Application.sName + " Config = " + Settings.Path.App.sConfig)

	slMessage(Settings.Message.iInformation, "Proxy = " + Settings.Path.Proxy.user() + " : " + Settings.Path.Proxy.password() + " @ " + Settings.Path.Proxy.hostName() + " : " + str(Settings.Path.Proxy.port()) + "\n")


# Message
def slMessage(iType, sMessage) :

	sDate = Settings.Env.sDate
	sMessage = sMessage.replace("<br>", "\n")

	if Import.Init.bVerbose :

		# Output file
		fOutput = QtCore.QFile(Settings.Path.App.sConfig + "/Output/" + sDate + ".txt")

		if fOutput.open(QtCore.QIODevice.Append | QtCore.QIODevice.Text) :

			# Prepare text stream
			tsOutput = QtCore.QTextStream(fOutput)

			if iType == Settings.Message.iClear :
				tsOutput << "\n"
			elif iType == Settings.Message.iStatus :
				tsOutput << "[S]: " + sMessage + "\n"
			elif iType == Settings.Message.iInformation :
				#tsOutput << sMessage + "\n"
				tsOutput << "[I]: " + sMessage + "\n"
			elif iType == Settings.Message.iWarning :
				tsOutput << "[W]: " + sMessage + "\n"
			elif iType == Settings.Message.iError :
				tsOutput << "[E]: " + sMessage + "\n"
				if Import.Init.bInvisible :
					Display.slQuit()
			elif iType == Settings.Message.iQuestion :
				tsOutput << "[Q]: " + sMessage + "\n"

			fOutput.close()


# Choose binary
def slChooseBinary(sTask, sFallback) :

	# Open file
	fTask = QtCore.QFile(Settings.Path.App.sPrefix + Settings.Path.App.sInstall + "/Options/" + sTask + ".txt")

	# Initialise
	bFound 		= False
	sCommand		= ""
	sArgs			= ""

	if not fTask.open(QtCore.QIODevice.ReadOnly | QtCore.QIODevice.Text) :

		# Messages
		Display.slMessage(Settings.Message.iError, "Can't load the " + sTask + " options file.")

	else :

		# Prepare text stream
		tsTask = QtCore.QTextStream(fTask)

		while not tsTask.atEnd() :
			sLine = tsTask.readLine()

			# Relevant data?
			if len(sLine) and not sLine.startswith('#') :

				slLine = sLine.split(' ', 1)
				pShell = Popen(["which", slLine[0]], stdout=PIPE, stderr=PIPE)
				if len(bytes.decode(pShell.communicate()[0])) :
					bFound = True
					sCommand = slLine[0]
					if len(slLine) > 1 :
						sArgs = slLine[1]
					slMessage(Settings.Message.iInformation, "For the " + sTask + " task, the chosen command is: " + sLine)
					break
				else :
					slMessage(Settings.Message.iWarning, "For the " + sTask + " task, an absent command is: " + sLine)

		fTask.close()

	# Fallback
	if not bFound and len(sFallback) :

		slFallback = sFallback.split(' ', 1)
		pShell = Popen(["which", slFallback[0]], stdout=PIPE, stderr=PIPE)
		if len(bytes.decode(pShell.communicate()[0])) :
			bFound = True
			sCommand	+= Settings.Exec.Terminal.sCommand
			sArgs		+= Settings.Exec.Terminal.sArgs + " " + sFallback
			slMessage(Settings.Message.iInformation, "For the " + sTask + " task, the chosen fallback command is: " + sFallback)
		else :
			slMessage(Settings.Message.iWarning, "For the " + sTask + " task, an absent fallback command is: " + sFallback)

	return sCommand, sArgs


# Test directory
def slTestDir(sDir) :

	bRet = True
	dPath = QtCore.QDir(Settings.Path.App.sConfig + "/" + sDir + "/")

	# Create directory
	if not dPath.exists() :
		bRet = dPath.mkpath(dPath.path())

	return bRet

# Test directories
def slTestDirs() :

	bRet = True

	bRet &= slTestDir("Lists")
	bRet &= slTestDir("Output")
	bRet &= slTestDir("Profiles")

	# Failed
	if not bRet :
		Display.slMessage(Settings.Message.iError, "The required directories can't be created.")

	return bRet

# Test profile
def slTestProfile(sName) :

	bRet = True

	if not QtCore.QFile.exists(Settings.Path.App.sConfig + "/Profiles/" + sName + ".txt") :
		bRet = Profile.slReset(sName)

	return bRet

# Test profiles
def slTestProfiles() :

	bRet = True

	bRet &= slTestProfile("Default")
	bRet &= slTestProfile("Flash")
	bRet &= slTestProfile("Local")
	bRet &= slTestProfile("Remote")
	bRet &= slTestProfile("Secure")
	bRet &= slTestProfile("Storage")

	if not bRet :
		Display.slMessage(Settings.Message.iError, "The required profiles can't be created.")

	return bRet
