"""
File:		Archive.py
Purpose:	Archive handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

"""
# Python
try :
	import	sys
except :
	Import.slException("Python")
"""

"""
# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException("PyQt4")
"""

# App 2
import	Display, List, Profile, Settings, Thread


### Slots

# Start the 'create' thread
def slCreate() :

	# Quit threads
	slQuit()

	# Manually killed
	Settings.Exec.bKilled = False

	# Add MRU items
	Display.slCAddMRU()

	# Disable GUI
	Display.slDisableGUI()

	# Invisible?
	if Import.Init.bInvisible :
		# Start
		Thread.tiCreate.run()
		# Start event loop
		#Thread.tiCreate.exec_()
	else :
		# Start
		Thread.tiCreate.start()
		#Thread.tiCreate.setPriority(QtCore.QThread.LowPriority)
		Thread.tiCreate.msleep(50)


# Start the 'extract' thread
def slExtract() :

	# Quit threads
	slQuit()

	# Manually killed
	Settings.Exec.bKilled = False

	# Add MRU items
	Display.slEAddMRU()

	# Disable GUI
	Display.slDisableGUI()

	# Invisible?
	if Import.Init.bInvisible :
		# Start
		Thread.tiExtract.run()
		# Start event loop
		#Thread.tiExtract.exec_()
	else :
		# Start
		Thread.tiExtract.start()
		#Thread.tiExtract.setPriority(QtCore.QThread.LowPriority)
		Thread.tiExtract.msleep(50)


# Start
def slStart():

	# Profile
	Profile.slLoad(Settings.Init.Create.sProfile)

	# Supplied arguments
	if Settings.Input.iNumArgs >= 3 :

		# List
		if len(Settings.Init.Create.sList) :
			List.slLoad(Settings.Init.Create.sList)

		# External
		if Settings.Operation.iActive != Settings.Operation.iAny :
			Display.slGUIExternal(Settings.Operation.iActive)

		# Auto-Quit
		if Settings.Init.bAutoQuit :

			# Create
			if Settings.Operation.iActive == Settings.Operation.iCreate :
				slCreate()
			# Extract
			elif Settings.Operation.iActive == Settings.Operation.iExtract :
				slExtract()
			# Test
			elif Settings.Operation.iActive == Settings.Operation.iTest :
				slExtract()


# Stop
def slStop() :

	# Manually killed
	Settings.Exec.bKilled = True

	# Quit threads
	slQuit()

	# Enable GUI
	Display.slEnableGUI()


# Done
def slDone(iRetVal) :

	# Quit threads
	#slQuit()

	# Progress
	Display.slProgress(iRetVal)

	# Reset GUI
	if iRetVal == 100 :
		# Enable GUI
		Display.slEnableGUI()

	# Default and storage
	if iRetVal == 100 and Settings.Input.iNumArgs >= 3 :
		if Settings.Init.bAutoQuit :
			Display.slQuit()


# Error
def slError(sError) :

	# Stop
	slStop()

	# Error
	if len(sError) :
		Display.slMessage(Settings.Message.iError, sError)


# Quit threads
def slQuit() :

	# Create
	if Thread.tiCreate.isRunning() :
		Thread.tiCreate.stop()
		#Thread.tiCreate.terminate()
		Thread.tiCreate.exit()
		Thread.tiCreate.wait(Settings.Timer.Process.iPause)

	# Extract
	if Thread.tiExtract.isRunning() :
		Thread.tiExtract.stop()
		#Thread.tiExtract.terminate()
		Thread.tiExtract.exit()
		Thread.tiExtract.wait(Settings.Timer.Process.iPause)
