#!/bin/bash
#
#  Package the sources to a tar archive
#
PROJECT_DIR=`basename "$PWD" | sed 's/-.*$//'`

VERSION="$1"
if [ -z "$VERSION" ]; then
   VERSION=`grep 'set.*VERSION' CMakeLists.txt | sed -e 's/^.*VERSION *//' -e 's/ *).*$//'`
fi

set -x
tar -jcf "../koverartist_$VERSION.orig.tar.bz2" \
   -C .. --owner=root --transform "s/^$PROJECT_DIR/koverartist-$VERSION/" \
   --exclude-vcs --exclude-backups --exclude-from=tools/mktar-excludes.lst \
   $PROJECT_DIR
