/*
   Copyright (C) 2006-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* renderer.h
 */
#ifndef renderer_h
#define renderer_h

#include "rendererbase.h"



namespace KoverArtist
{
/** This class renders the project on a @ref QPaintDevice.
 */
class Renderer: public RendererBase
{
   typedef RendererBase Inherited;

public:
   Renderer(Project* p);
   virtual ~Renderer();

   /** Render the project on the paint device pd. */
   virtual void render(QPaintDevice* pd, bool autoFit=false);

   /** Control rendering of front side. */
   bool isEnabledFront() const { return mRenderFront; }
   void setEnabledFront(bool f) { mRenderFront = f; }

   /** Control rendering of back side. */
   bool isEnabledBack() const { return mRenderBack; }
   void setEnabledBack(bool f) { mRenderBack = f; }

   /** Test if renderer is rendering. */
   bool isRendering() const { return mRendering; }

   /** Abort rendering. */
   void abortRendering() { mRendering = false; }

protected:
   /** Draw front. */
   virtual void renderFront(QPaintDevice* dev, const QMatrix& wm);

   /** Draw back. */
   virtual void renderBack(QPaintDevice* dev, const QMatrix& wm);

   /** Render the contents of all discs into the rectangle bb. */
   virtual void renderContents(QRect bb);

   /** Set surface background. */
   virtual void renderSurfaceBackground(int x, int y, const QPixmap& pix);

   /** Render side text. */
   virtual void renderSideText(int width, int height, int lWidth, int rWidth, bool rotated);

   /** Render outlines. */
   virtual void renderOutlines(int lw, int rw);

   virtual void doRender(QPaintDevice* pd, bool autoFit);

private:
   Renderer(const Renderer&);
   Renderer& operator=(const Renderer&);

protected:
   bool mLandscape, mRenderFront, mRenderBack;
   bool mRendering, mAbort, mAbortable;
};

}

#endif /*renderer_h*/
