/*
   Copyright (C) 2006-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// prefgeneral.cpp

#include "prefgeneral.h"

#include "settings.h"

#include <klocale.h>
#include <kmessagebox.h>

#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qregexp.h>



KoverArtistPrefGeneral::KoverArtistPrefGeneral(QWidget *parent)
:QFrame(parent)
{
   QVBoxLayout *vbox = new QVBoxLayout(this);
   QLabel *lbl;

   mCbxLocalImages = new QCheckBox(i18n("Copy pictures into the project directory when the project is saved."), this);
   mCbxLocalImages->setFixedSize(mCbxLocalImages->sizeHint());
   vbox->addWidget(mCbxLocalImages);

   mCbxRemoveImageBorders = new QCheckBox(i18n("When loading pictures, remove black borders on both sides."), this);
   mCbxRemoveImageBorders->setFixedSize(mCbxRemoveImageBorders->sizeHint());
   vbox->addWidget(mCbxRemoveImageBorders);

   vbox->addSpacing(16);

   lbl = new QLabel(i18n("URL for searching cover images "
      "(%1 is replaced by the search string):"), this);
   lbl->setFixedSize(lbl->sizeHint());
   vbox->addWidget(lbl);

   mEdtCoverImageSearchUrl = new QLineEdit(this);
   mEdtCoverImageSearchUrl->setFixedHeight(mEdtCoverImageSearchUrl->sizeHint().height());
   vbox->addWidget(mEdtCoverImageSearchUrl);

   vbox->addSpacing(16);

   vbox->addStretch(1000);
   vbox->activate();
}


void KoverArtistPrefGeneral::fromConfig(const KoverArtist::Settings* aStg)
{
   mCbxLocalImages->setChecked(aStg->localImages);
   mCbxRemoveImageBorders->setChecked(aStg->removeImageBorders);
   mEdtCoverImageSearchUrl->setText(aStg->coverImageSearchUrl);
}


void KoverArtistPrefGeneral::toConfig(KoverArtist::Settings* aStg) const
{
   aStg->localImages = mCbxLocalImages->isChecked();
   aStg->removeImageBorders = mCbxRemoveImageBorders->isChecked();
   aStg->coverImageSearchUrl = mEdtCoverImageSearchUrl->text();
}


bool KoverArtistPrefGeneral::isValid() const
{
   QString str = mEdtCoverImageSearchUrl->text();
   int idx = str.indexOf(QRegExp("%1[^0-9]|%1$"));
   if (idx<0)
   {
      KMessageBox::error((QWidget*)this,
         i18n("The image search url must contain a %1"));
      mEdtCoverImageSearchUrl->setFocus();
      return false;
   }

   return true;
}
