# -*- coding: utf-8 -*-
# vim: set noet ts=4:
#
# scim-python
#
# Copyright (c) 2007-2008 Yu Fan <yufanyufan@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA
#
# $Id: $
#

from ZhengJu import *
import scim
import os
from scim import KeyCode
from scim import KeyMask
from scim import Property
from QuanPin import QuanPinEngine

import traceback
import sys
from PYDict import *
from gettext import dgettext
from QuanPin import strip
_ = lambda a : dgettext ("scim-python", a)
class JianPinEngine(QuanPinEngine):
	def __init__ (self, factory, config, encoding, id):
		QuanPinEngine.__init__(self, factory, config, encoding, id)

	def split(self, strs):
		if strip(strs) in PINYIN_LIST \
			or strip(strs) in PINYIN_PARTIAL_LIST	\
			or strip(strs) in SHENGMU_LIST \
			or strs == "'":
			yield (strs,  "")
		else:
			for i in range(len(strs), 0, -1):
				if strs[:i][-1] == "'":
					continue
				if strip(strs[:i]) in PINYIN_LIST or strip(strs[:i]) in SHENGMU_LIST:
					yield ( strs[:i], strs[i:] )
					if strip(strs[:i-1]) in PINYIN_LIST and strip(strs[:i])[-1] in SHENGMU_LIST and self.is_valid_head(strs[i-1:]):
						yield ( strs[:i-1], strs[i-1:])
					break
 
class JianPinFactory (IMEngineFactory):
	def __init__ (self, config):
		IMEngineFactory.__init__ (self, config)
		self.name 		= _(u"JianPin")
		self.uuid 		= "908ce256-ddd8-44b7-b6c0-5833024bd445"
		self.authors	= u"Yu Fan <yufanyufan@gmail.com>"
		self.icon_file 	= "/usr/share/scim/icons/scim-python.png"
		self.credits 	= u"GPL"
		self.help		= _(u"Help For JianPin")
		self.set_languages ("zh")
		self._config	= config
	def create_instance (self, encoding, id):
		engine =  JianPinEngine (self, self._config, encoding, id)
		return engine

	def reload_config (self, config):
		pass
