/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.bitmap;

import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;

public final class BitmapHeader {
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    private static final int BMPH_DATA_OFFSET = 6;
    private static final int BMPH_HEADERSIZE = 10;
    private static final int BMPH_WIDTH = 14;
    private static final int BMPH_HEIGHT = 18;
    private static final int BMPH_NO_PLANES = 20;
    private static final int BMPH_BPP = 22;
    private static final int BMPH_COMPRESSION = 26;
    private static final int BMPH_DATASIZE = 30;
    private static final int BMPH_HRES = 34;
    private static final int BMPH_VRES = 38;
    private static final int BMPH_NO_COLORS = 42;
    private static final int BMPH_NO_IMPORTANT_COLORS = 46;
    private int dataOffset;
    private int headerSize;
    private int width;
    private int height;
    private int noPlanes;
    private int bitPerPixel;
    private int compression;
    private int dataSize;
    private int hres;
    private int vres;
    private int noColors;
    private int noImportantColors;
    private boolean isTopDown;

    public void setRecord(MfRecord record, int offset) {
        this.dataOffset = record.getInt(offset + 6);
        this.headerSize = record.getInt(offset + 10);
        this.width = record.getInt(offset + 14);
        this.height = record.getInt(offset + 18);
        this.noPlanes = record.getShort(offset + 20);
        this.bitPerPixel = record.getShort(offset + 22);
        this.compression = record.getInt(offset + 26);
        this.dataSize = record.getInt(offset + 30);
        this.hres = record.getInt(offset + 34);
        this.vres = record.getInt(offset + 38);
        this.noColors = record.getInt(offset + 42);
        this.noImportantColors = record.getInt(offset + 46);
        if (this.height < 0) {
            this.isTopDown = true;
            this.height = -this.height;
        }
        this.fixPalette();
    }

    private void fixPalette() {
        if (this.bitPerPixel < 16) {
            if (this.noColors == 0) {
                this.noColors = (int)StrictMath.pow(2.0, this.bitPerPixel);
            }
            if (this.noImportantColors == 0) {
                this.noImportantColors = (int)StrictMath.pow(2.0, this.bitPerPixel);
            }
        }
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getBitsPerPixel() {
        return this.bitPerPixel;
    }

    public int getHRes() {
        return this.hres;
    }

    public int getVRes() {
        return this.vres;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNoOfColors() {
        return this.noColors;
    }

    public int getNoOfImportantColors() {
        return this.noImportantColors;
    }

    public boolean isTopDown() {
        return this.isTopDown;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getNoPlanes() {
        return this.noPlanes;
    }
}

