/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBitmapBlip;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.eventmodel.EventRecordFactory;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HSSFWorkbook {
    private static final int DEBUG = 1;
    public static final int INITIAL_CAPACITY = 3;
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;
    private static POILogger log;
    public static final byte ENCODING_COMPRESSED_UNICODE = 0;
    public static final byte ENCODING_UTF_16 = 1;
    private Workbook workbook;
    protected ArrayList sheets;
    private ArrayList names;
    private boolean preserveNodes;
    private POIFSFileSystem poifs;
    private HSSFDataFormat formatter;
    static /* synthetic */ Class class$org$apache$poi$hssf$usermodel$HSSFWorkbook;

    private final void setPropertiesFromWorkbook(Workbook book) {
        this.workbook = book;
    }

    private final void convertLabelRecords(List records, int offset) {
        if (log.check(1)) {
            log.log(1, "convertLabelRecords called");
        }
        int k = offset;
        while (k < records.size()) {
            Record rec = (Record)records.get(k);
            if (rec.getSid() == 516) {
                LabelRecord oldrec = (LabelRecord)rec;
                records.remove(k);
                LabelSSTRecord newrec = new LabelSSTRecord();
                int stringid = this.workbook.addSSTString(new UnicodeString(oldrec.getValue()));
                newrec.setRow(oldrec.getRow());
                newrec.setColumn(oldrec.getColumn());
                newrec.setXFIndex(oldrec.getXFIndex());
                newrec.setSSTIndex(stringid);
                records.add(k, newrec);
            }
            ++k;
        }
        if (log.check(1)) {
            log.log(1, "convertLabelRecords exit");
        }
    }

    public void setSheetOrder(String sheetname, int pos) {
        this.sheets.add(pos, this.sheets.remove(this.getSheetIndex(sheetname)));
        this.workbook.setSheetOrder(sheetname, pos);
    }

    public void setSelectedTab(short index) {
        this.workbook.getWindowOne().setSelectedTab(index);
    }

    public short getSelectedTab() {
        return this.workbook.getWindowOne().getSelectedTab();
    }

    public void setDisplayedTab(short index) {
        this.workbook.getWindowOne().setDisplayedTab(index);
    }

    public short getDisplayedTab() {
        return this.workbook.getWindowOne().getDisplayedTab();
    }

    public void setSheetName(int sheet, String name) {
        if (this.workbook.doesContainsSheetName(name, sheet)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        if (sheet > this.sheets.size() - 1) {
            throw new RuntimeException("Sheet out of bounds");
        }
        this.workbook.setSheetName(sheet, name);
    }

    public void setSheetName(int sheet, String name, short encoding) {
        if (this.workbook.doesContainsSheetName(name, sheet)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        if (sheet > this.sheets.size() - 1) {
            throw new RuntimeException("Sheet out of bounds");
        }
        switch (encoding) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported encoding");
            }
        }
        this.workbook.setSheetName(sheet, name, encoding);
    }

    public String getSheetName(int sheet) {
        if (sheet > this.sheets.size() - 1) {
            throw new RuntimeException("Sheet out of bounds");
        }
        return this.workbook.getSheetName(sheet);
    }

    public int getSheetIndex(String name) {
        int retval = this.workbook.getSheetIndex(name);
        return retval;
    }

    public HSSFSheet createSheet() {
        HSSFSheet sheet = new HSSFSheet(this.workbook);
        this.sheets.add(sheet);
        this.workbook.setSheetName(this.sheets.size() - 1, "Sheet" + (this.sheets.size() - 1));
        WindowTwoRecord windowTwo = (WindowTwoRecord)sheet.getSheet().findFirstRecordBySid((short)574);
        boolean bl = false;
        if (this.sheets.size() == 1) {
            bl = true;
        }
        windowTwo.setSelected(bl);
        boolean bl2 = false;
        if (this.sheets.size() == 1) {
            bl2 = true;
        }
        windowTwo.setPaged(bl2);
        return sheet;
    }

    public HSSFSheet cloneSheet(int sheetNum) {
        HSSFSheet srcSheet = (HSSFSheet)this.sheets.get(sheetNum);
        String srcName = this.workbook.getSheetName(sheetNum);
        if (srcSheet != null) {
            String index;
            String name;
            HSSFSheet clonedSheet = srcSheet.cloneSheet(this.workbook);
            WindowTwoRecord windowTwo = (WindowTwoRecord)clonedSheet.getSheet().findFirstRecordBySid((short)574);
            boolean bl = false;
            if (this.sheets.size() == 1) {
                bl = true;
            }
            windowTwo.setSelected(bl);
            boolean bl2 = false;
            if (this.sheets.size() == 1) {
                bl2 = true;
            }
            windowTwo.setPaged(bl2);
            this.sheets.add(clonedSheet);
            int i = 1;
            do {
                name = srcName;
                index = Integer.toString(i++);
            } while (this.workbook.getSheetIndex(name = name.length() + index.length() + 2 < 31 ? name + '(' + index + ')' : name.substring(0, 31 - index.length() - 2) + '(' + index + ')') != -1);
            this.workbook.setSheetName(this.sheets.size() - 1, name);
            return clonedSheet;
        }
        return null;
    }

    public HSSFSheet createSheet(String sheetname) {
        if (this.workbook.doesContainsSheetName(sheetname, this.sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        HSSFSheet sheet = new HSSFSheet(this.workbook);
        this.sheets.add(sheet);
        this.workbook.setSheetName(this.sheets.size() - 1, sheetname);
        WindowTwoRecord windowTwo = (WindowTwoRecord)sheet.getSheet().findFirstRecordBySid((short)574);
        boolean bl = false;
        if (this.sheets.size() == 1) {
            bl = true;
        }
        windowTwo.setSelected(bl);
        boolean bl2 = false;
        if (this.sheets.size() == 1) {
            bl2 = true;
        }
        windowTwo.setPaged(bl2);
        return sheet;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public HSSFSheet getSheetAt(int index) {
        return (HSSFSheet)this.sheets.get(index);
    }

    public HSSFSheet getSheet(String name) {
        HSSFSheet retval = null;
        int k = 0;
        while (k < this.sheets.size()) {
            String sheetname = this.workbook.getSheetName(k);
            if (sheetname.equals(name)) {
                retval = (HSSFSheet)this.sheets.get(k);
            }
            ++k;
        }
        return retval;
    }

    public void removeSheetAt(int index) {
        this.sheets.remove(index);
        this.workbook.removeSheet(index);
    }

    public void setBackupFlag(boolean backupValue) {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        backupRecord.setBackup((short)(backupValue ? 1 : 0));
    }

    public boolean getBackupFlag() {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        int n = 0;
        if (backupRecord.getBackup() == 0) {
            n = 1;
        }
        return 1 - n;
    }

    public void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        if (startColumn == -1 && endColumn != -1) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow == -1 && endRow != -1) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (startColumn < -1 || startColumn >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (endColumn < -1 || endColumn >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow < -1 || startRow > (char)-1) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (endRow < -1 || endRow > (char)-1) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (startColumn > endColumn) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow > endRow) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        HSSFSheet sheet = this.getSheetAt(sheetIndex);
        short externSheetIndex = this.getWorkbook().checkExternSheet(sheetIndex);
        boolean bl = false;
        if (startColumn != -1 && endColumn != -1 && startRow != -1 && endRow != -1) {
            bl = true;
        }
        boolean settingRowAndColumn = bl;
        boolean bl2 = false;
        if (startColumn == -1 && endColumn == -1 && startRow == -1 && endRow == -1) {
            bl2 = true;
        }
        boolean removingRange = bl2;
        boolean isNewRecord = false;
        NameRecord nameRecord = this.findExistingRowColHeaderNameRecord(sheetIndex);
        if (removingRange) {
            if (nameRecord != null) {
                this.workbook.removeName(this.findExistingRowColHeaderNameRecordIdx(sheetIndex + 1));
            }
            return;
        }
        if (nameRecord == null) {
            nameRecord = this.workbook.createBuiltInName((byte)7, sheetIndex + 1);
            isNewRecord = true;
        }
        short definitionTextLength = settingRowAndColumn ? (short)26 : 11;
        nameRecord.setDefinitionTextLength(definitionTextLength);
        Stack<Ptg> ptgs = new Stack<Ptg>();
        if (settingRowAndColumn) {
            MemFuncPtg memFuncPtg = new MemFuncPtg();
            memFuncPtg.setLenRefSubexpression(23);
            ptgs.add(memFuncPtg);
        }
        if (startColumn >= 0) {
            Area3DPtg area3DPtg1 = new Area3DPtg();
            area3DPtg1.setExternSheetIndex(externSheetIndex);
            area3DPtg1.setFirstColumn((short)startColumn);
            area3DPtg1.setLastColumn((short)endColumn);
            area3DPtg1.setFirstRow((short)0);
            area3DPtg1.setLastRow((short)-1);
            ptgs.add(area3DPtg1);
        }
        if (startRow >= 0) {
            Area3DPtg area3DPtg2 = new Area3DPtg();
            area3DPtg2.setExternSheetIndex(externSheetIndex);
            area3DPtg2.setFirstColumn((short)0);
            area3DPtg2.setLastColumn((short)255);
            area3DPtg2.setFirstRow((short)startRow);
            area3DPtg2.setLastRow((short)endRow);
            ptgs.add(area3DPtg2);
        }
        if (settingRowAndColumn) {
            UnionPtg unionPtg = new UnionPtg();
            ptgs.add(unionPtg);
        }
        nameRecord.setNameDefinition(ptgs);
        if (isNewRecord) {
            HSSFName newName = new HSSFName(this.workbook, nameRecord);
            this.names.add(newName);
        }
        HSSFPrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setValidSettings(false);
        WindowTwoRecord w2 = (WindowTwoRecord)sheet.getSheet().findFirstRecordBySid((short)574);
        w2.setPaged(true);
    }

    private final NameRecord findExistingRowColHeaderNameRecord(int sheetIndex) {
        int index = this.findExistingRowColHeaderNameRecordIdx(sheetIndex);
        if (index == -1) {
            return null;
        }
        return (NameRecord)this.workbook.findNextRecordBySid((short)24, index);
    }

    private final int findExistingRowColHeaderNameRecordIdx(int sheetIndex) {
        int index = 0;
        NameRecord r = null;
        while ((r = (NameRecord)this.workbook.findNextRecordBySid((short)24, index)) != null) {
            int indexToSheet = r.getEqualsToIndexToSheet() - 1;
            if (indexToSheet > -1) {
                int nameRecordSheetIndex = this.workbook.getSheetIndexFromExternSheetIndex(indexToSheet);
                if (this.isRowColHeaderRecord(r) && nameRecordSheetIndex == sheetIndex) {
                    return index;
                }
            }
            ++index;
        }
        return -1;
    }

    private final boolean isRowColHeaderRecord(NameRecord r) {
        boolean bl = false;
        if (r.getOptionFlag() == 32 && "\u0007".equals(r.getNameText())) {
            bl = true;
        }
        return bl;
    }

    public HSSFFont createFont() {
        FontRecord font = this.workbook.createNewFont();
        short fontindex = (short)(this.getNumberOfFonts() - 1);
        if (fontindex > 3) {
            fontindex = (short)(fontindex + 1);
        }
        HSSFFont retval = new HSSFFont(fontindex, font);
        return retval;
    }

    public HSSFFont findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        short i = 0;
        while (i < this.workbook.getNumberOfFontRecords()) {
            FontRecord font;
            HSSFFont hssfFont;
            if (i != 4 && (hssfFont = new HSSFFont(i, font = this.workbook.getFontRecordAt(i))).getBoldweight() == boldWeight && hssfFont.getColor() == color && hssfFont.getFontHeight() == fontHeight && hssfFont.getFontName().equals(name) && hssfFont.getItalic() == italic && hssfFont.getStrikeout() == strikeout && hssfFont.getTypeOffset() == typeOffset && hssfFont.getUnderline() == underline) {
                return hssfFont;
            }
            i = (short)(i + 1);
        }
        return null;
    }

    public short getNumberOfFonts() {
        return (short)this.workbook.getNumberOfFontRecords();
    }

    public HSSFFont getFontAt(short idx) {
        FontRecord font = this.workbook.getFontRecordAt(idx);
        HSSFFont retval = new HSSFFont(idx, font);
        return retval;
    }

    public HSSFCellStyle createCellStyle() {
        ExtendedFormatRecord xfr = this.workbook.createCellXF();
        short index = (short)(this.getNumCellStyles() - 1);
        HSSFCellStyle style = new HSSFCellStyle(index, xfr);
        return style;
    }

    public short getNumCellStyles() {
        return (short)this.workbook.getNumExFormats();
    }

    public HSSFCellStyle getCellStyleAt(short idx) {
        ExtendedFormatRecord xfr = this.workbook.getExFormatAt(idx);
        HSSFCellStyle style = new HSSFCellStyle(idx, xfr);
        return style;
    }

    public void write(OutputStream stream) throws IOException {
        byte[] bytes = this.getBytes();
        POIFSFileSystem fs = new POIFSFileSystem();
        fs.createDocument(new ByteArrayInputStream(bytes), "Workbook");
        if (this.preserveNodes) {
            ArrayList<String> excepts = new ArrayList<String>(1);
            excepts.add("Workbook");
            this.copyNodes(this.poifs, fs, excepts);
        }
        fs.writeFilesystem(stream);
    }

    public byte[] getBytes() {
        int wbsize;
        if (log.check(1)) {
            log.log(1, "HSSFWorkbook.getBytes()");
        }
        int k = 0;
        while (k < this.sheets.size()) {
            ((HSSFSheet)this.sheets.get(k)).getSheet().preSerialize();
            ++k;
        }
        int totalsize = wbsize = this.workbook.getSize();
        int k2 = 0;
        while (k2 < this.sheets.size()) {
            this.workbook.setSheetBof(k2, totalsize);
            totalsize += ((HSSFSheet)this.sheets.get(k2)).getSheet().getSize();
            ++k2;
        }
        byte[] retval = new byte[totalsize];
        int pos = this.workbook.serialize(0, retval);
        int k3 = 0;
        while (k3 < this.sheets.size()) {
            int len = ((HSSFSheet)this.sheets.get(k3)).getSheet().serialize(pos, retval);
            pos += len;
            ++k3;
        }
        return retval;
    }

    public int addSSTString(String string) {
        return this.workbook.addSSTString(new UnicodeString(string));
    }

    public String getSSTString(int index) {
        return this.workbook.getSSTString(index).getString();
    }

    Workbook getWorkbook() {
        return this.workbook;
    }

    public int getNumberOfNames() {
        int result = this.names.size();
        return result;
    }

    public HSSFName getNameAt(int index) {
        HSSFName result = (HSSFName)this.names.get(index);
        return result;
    }

    public String getNameName(int index) {
        String result = this.getNameAt(index).getNameName();
        return result;
    }

    public void setPrintArea(int sheetIndex, String reference) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            name = this.workbook.createBuiltInName((byte)6, sheetIndex + 1);
        }
        short externSheetIndex = this.getWorkbook().checkExternSheet(sheetIndex);
        name.setExternSheetNumber(externSheetIndex);
        name.setAreaReference(reference);
    }

    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        CellReference cell = new CellReference(startRow, startColumn, true, true);
        String reference = cell.toString();
        cell = new CellReference(endRow, endColumn, true, true);
        reference = reference + ':' + cell.toString();
        this.setPrintArea(sheetIndex, reference);
    }

    public String getPrintArea(int sheetIndex) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            return null;
        }
        return name.getAreaReference(this.workbook);
    }

    public void removePrintArea(int sheetIndex) {
        this.getWorkbook().removeBuiltinRecord((byte)6, sheetIndex + 1);
    }

    public HSSFName createName() {
        NameRecord nameRecord = this.workbook.createName();
        HSSFName newName = new HSSFName(this.workbook, nameRecord);
        this.names.add(newName);
        return newName;
    }

    public int getNameIndex(String name) {
        int retval = -1;
        int k = 0;
        while (k < this.names.size()) {
            String nameName = this.getNameName(k);
            if (nameName.equalsIgnoreCase(name)) {
                retval = k;
                break;
            }
            ++k;
        }
        return retval;
    }

    public void removeName(int index) {
        this.names.remove(index);
        this.workbook.removeName(index);
    }

    public HSSFDataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new HSSFDataFormat(this.workbook);
        }
        return this.formatter;
    }

    public void removeName(String name) {
        int index = this.getNameIndex(name);
        this.removeName(index);
    }

    public HSSFPalette getCustomPalette() {
        return new HSSFPalette(this.workbook.getCustomPalette());
    }

    private final void copyNodes(POIFSFileSystem source, POIFSFileSystem target, List excepts) throws IOException {
        DirectoryEntry root = source.getRoot();
        DirectoryEntry newRoot = target.getRoot();
        Iterator entries = root.getEntries();
        while (entries.hasNext()) {
            Entry entry = (Entry)entries.next();
            if (this.isInList(entry.getName(), excepts)) continue;
            this.copyNodeRecursively(entry, newRoot);
        }
    }

    private final boolean isInList(String entry, List list) {
        int k = 0;
        while (k < list.size()) {
            if (list.get(k).equals(entry)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private final void copyNodeRecursively(Entry entry, DirectoryEntry target) throws IOException {
        DirectoryEntry newTarget = null;
        if (entry.isDirectoryEntry()) {
            newTarget = target.createDirectory(entry.getName());
            Iterator entries = ((DirectoryEntry)entry).getEntries();
            while (entries.hasNext()) {
                this.copyNodeRecursively((Entry)entries.next(), newTarget);
            }
        } else {
            DocumentEntry dentry = (DocumentEntry)entry;
            DocumentInputStream dstream = new DocumentInputStream(dentry);
            target.createDocument(dentry.getName(), dstream);
            dstream.close();
        }
    }

    public void insertChartRecord() {
        int loc = this.workbook.findFirstRecordLocBySid((short)252);
        byte[] byArray = new byte[90];
        byArray[0] = 15;
        byArray[3] = -16;
        byArray[4] = 82;
        byArray[10] = 6;
        byArray[11] = -16;
        byArray[12] = 24;
        byArray[16] = 1;
        byArray[17] = 8;
        byArray[20] = 2;
        byArray[24] = 2;
        byArray[28] = 1;
        byArray[32] = 1;
        byArray[36] = 3;
        byArray[40] = 51;
        byArray[42] = 11;
        byArray[43] = -16;
        byArray[44] = 18;
        byArray[48] = -65;
        byArray[50] = 8;
        byArray[52] = 8;
        byArray[54] = -127;
        byArray[55] = 1;
        byArray[56] = 9;
        byArray[59] = 8;
        byArray[60] = -64;
        byArray[61] = 1;
        byArray[62] = 64;
        byArray[65] = 8;
        byArray[66] = 64;
        byArray[68] = 30;
        byArray[69] = -15;
        byArray[70] = 16;
        byArray[74] = 13;
        byArray[77] = 8;
        byArray[78] = 12;
        byArray[81] = 8;
        byArray[82] = 23;
        byArray[85] = 8;
        byArray[86] = -9;
        byArray[89] = 16;
        byte[] data = byArray;
        UnknownRecord r = new UnknownRecord(235, data);
        this.workbook.getRecords().add(loc, r);
    }

    public void dumpDrawingGroupRecords(boolean fat) {
        DrawingGroupRecord r = (DrawingGroupRecord)this.workbook.findFirstRecordBySid((short)235);
        r.decode();
        List escherRecords = r.getEscherRecords();
        PrintWriter w = new PrintWriter(System.out);
        Iterator iterator = escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w, 0);
        }
        w.flush();
    }

    public int addPicture(byte[] pictureData, int format) {
        byte[] uid = this.newUID();
        EscherBitmapBlip blipRecord = new EscherBitmapBlip();
        blipRecord.setRecordId((short)(-4072 + format));
        switch (format) {
            case 2: {
                blipRecord.setOptions((short)15680);
                break;
            }
            case 3: {
                blipRecord.setOptions((short)8544);
                break;
            }
            case 4: {
                blipRecord.setOptions((short)21536);
                break;
            }
            case 6: {
                blipRecord.setOptions((short)28160);
                break;
            }
            case 5: {
                blipRecord.setOptions((short)18080);
                break;
            }
            case 7: {
                blipRecord.setOptions((short)31360);
                break;
            }
        }
        blipRecord.setUID(uid);
        blipRecord.setMarker((byte)-1);
        blipRecord.setPictureData(pictureData);
        EscherBSERecord r = new EscherBSERecord();
        r.setRecordId((short)-4089);
        r.setOptions((short)(2 | format << 4));
        r.setBlipTypeMacOS((byte)format);
        r.setBlipTypeWin32((byte)format);
        r.setUid(uid);
        r.setTag((short)255);
        r.setSize(pictureData.length + 25);
        r.setRef(1);
        r.setOffset(0);
        r.setBlipRecord(blipRecord);
        return this.workbook.addBSERecord(r);
    }

    public List getAllPictures() {
        ArrayList pictures = new ArrayList();
        Iterator recordIter = this.workbook.getRecords().iterator();
        while (recordIter.hasNext()) {
            Object obj = recordIter.next();
            if (!(obj instanceof AbstractEscherHolderRecord)) continue;
            ((AbstractEscherHolderRecord)obj).decode();
            List escherRecords = ((AbstractEscherHolderRecord)obj).getEscherRecords();
            this.searchForPictures(escherRecords, pictures);
        }
        return pictures;
    }

    private final void searchForPictures(List escherRecords, List pictures) {
        Iterator recordIter = escherRecords.iterator();
        while (recordIter.hasNext()) {
            EscherBlipRecord blip;
            Object obj = recordIter.next();
            if (!(obj instanceof EscherRecord)) continue;
            EscherRecord escherRecord = (EscherRecord)obj;
            if (escherRecord instanceof EscherBSERecord && (blip = ((EscherBSERecord)escherRecord).getBlipRecord()) instanceof EscherBitmapBlip) {
                pictures.add(new HSSFPictureData((EscherBitmapBlip)blip));
            }
            this.searchForPictures(escherRecord.getChildRecords(), pictures);
        }
    }

    private final byte[] newUID() {
        byte[] bytes = new byte[16];
        return bytes;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public HSSFWorkbook() {
        this(Workbook.createWorkbook());
    }

    protected HSSFWorkbook(Workbook book) {
        this.workbook = book;
        this.sheets = new ArrayList(3);
        this.names = new ArrayList(3);
    }

    public HSSFWorkbook(POIFSFileSystem fs) throws IOException {
        this(fs, true);
    }

    public HSSFWorkbook(POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        this.preserveNodes = preserveNodes;
        if (preserveNodes) {
            this.poifs = fs;
        }
        this.sheets = new ArrayList(3);
        this.names = new ArrayList(3);
        String workbookName = "Workbook";
        try {
            fs.getRoot().getEntry(workbookName);
        }
        catch (FileNotFoundException fe) {
            try {
                workbookName = "WORKBOOK";
                fs.getRoot().getEntry(workbookName);
            }
            catch (FileNotFoundException wfe) {
                throw new IllegalArgumentException("The supplied POIFSFileSystem contained neither a 'Workbook' entry, nor a 'WORKBOOK' entry. Is it really an excel file?");
            }
        }
        DocumentInputStream stream = fs.createDocumentInputStream(workbookName);
        EventRecordFactory factory = new EventRecordFactory();
        List records = RecordFactory.createRecords(stream);
        this.workbook = Workbook.createWorkbook(records);
        this.setPropertiesFromWorkbook(this.workbook);
        int recOffset = this.workbook.getNumRecords();
        int sheetNum = 0;
        this.convertLabelRecords(records, recOffset);
        while (recOffset < records.size()) {
            Sheet sheet;
            if ((recOffset = (sheet = Sheet.createSheet(records, sheetNum++, recOffset)).getEofLoc() + 1) == 1) break;
            HSSFSheet hsheet = new HSSFSheet(this.workbook, sheet);
            this.sheets.add(hsheet);
        }
        int i = 0;
        while (i < this.workbook.getNumNames()) {
            HSSFName name = new HSSFName(this.workbook, this.workbook.getNameRecord(i));
            this.names.add(name);
            ++i;
        }
    }

    public HSSFWorkbook(InputStream s) throws IOException {
        this(s, true);
    }

    public HSSFWorkbook(InputStream s, boolean preserveNodes) throws IOException {
        this(new POIFSFileSystem(s), preserveNodes);
    }

    static {
        Class clazz = class$org$apache$poi$hssf$usermodel$HSSFWorkbook;
        if (clazz == null) {
            clazz = class$org$apache$poi$hssf$usermodel$HSSFWorkbook = HSSFWorkbook.class("[Lorg.apache.poi.hssf.usermodel.HSSFWorkbook;", false);
        }
        log = POILogFactory.getLogger(clazz);
    }
}

