/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.DrawingRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.UnknownRecord;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordFactory {
    private static int NUM_RECORDS;
    private static final Class[] records;
    private static Map recordsMap;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BOFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$InterfaceHdrRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MMSRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$InterfaceEndRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WriteAccessRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CodepageRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DSFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$TabIdRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FnGroupCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PasswordRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ProtectionRev4Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PasswordRev4Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowOneRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BackupRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HideObjRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DateWindow1904Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrecisionRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RefreshAllRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BookBoolRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FontRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FormatRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExtendedFormatRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$StyleRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$UseSelFSRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BoundSheetRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CountryRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExtSSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$EOFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$IndexRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CalcModeRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CalcCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RefModeRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$IterationRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DeltaRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SaveRecalcRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintHeadersRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintGridlinesRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$GridsetRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$GutsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DefaultRowHeightRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WSBoolRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HeaderRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FooterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HCenterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$VCenterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintSetupRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DefaultColWidthRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DimensionsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RowRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LabelSSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RKRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NumberRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DBCellRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowTwoRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SelectionRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ContinueRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LabelRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BlankRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ColumnInfoRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MulRKRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MulBlankRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MergeCellsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FormulaRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BoolErrRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExternSheetRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NameRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LeftMarginRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RightMarginRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$TopMarginRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BottomMarginRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DrawingRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DrawingGroupRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DrawingSelectionRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ObjRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$TextObjectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PaletteRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$StringRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RecalcIdRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SharedFormulaRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HorizontalPageBreakRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$VerticalPageBreakRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WriteProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FilePassRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PaneRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NoteRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RecordInputStream;

    public static void setCapacity(int capacity) {
        NUM_RECORDS = capacity;
    }

    public static List createRecords(InputStream in) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>(NUM_RECORDS);
        RecordInputStream recStream = new RecordInputStream(in);
        DrawingRecord lastDrawingRecord = new DrawingRecord();
        Record lastRecord = null;
        while (recStream.hasNextRecord()) {
            recStream.nextRecord();
            if (recStream.getSid() == 0) continue;
            Record[] recs = RecordFactory.createRecord(recStream);
            if (recs.length > 1) {
                int k = 0;
                while (k < recs.length) {
                    records.add(recs[k]);
                    ++k;
                }
                continue;
            }
            Record record = recs[0];
            if (record == null) continue;
            if (record.getSid() == 235 && lastRecord instanceof DrawingGroupRecord) {
                DrawingGroupRecord lastDGRecord = (DrawingGroupRecord)lastRecord;
                lastDGRecord.join((AbstractEscherHolderRecord)record);
                continue;
            }
            if (record.getSid() == 60 && (lastRecord instanceof ObjRecord || lastRecord instanceof TextObjectRecord)) {
                lastDrawingRecord.processContinueRecord(((ContinueRecord)record).getData());
                continue;
            }
            if (record.getSid() == 60 && lastRecord instanceof DrawingGroupRecord) {
                ((DrawingGroupRecord)lastRecord).processContinueRecord(((ContinueRecord)record).getData());
                continue;
            }
            if (record.getSid() == 60) {
                if (lastRecord instanceof UnknownRecord) {
                    records.add(record);
                    continue;
                }
                throw new RecordFormatException("Unhandled Continue Record");
            }
            lastRecord = record;
            if (record instanceof DrawingRecord) {
                lastDrawingRecord = (DrawingRecord)record;
            }
            records.add(record);
        }
        return records;
    }

    public static Record[] createRecord(RecordInputStream in) {
        Record retval;
        Record[] realretval = null;
        try {
            Constructor constructor = (Constructor)recordsMap.get(new Short(in.getSid()));
            retval = constructor != null ? (Record)constructor.newInstance(in) : new UnknownRecord(in);
        }
        catch (Exception introspectionException) {
            throw new RecordFormatException("Unable to construct record instance", introspectionException);
        }
        if (retval instanceof RKRecord) {
            RKRecord rk = (RKRecord)retval;
            NumberRecord num = new NumberRecord();
            num.setColumn(rk.getColumn());
            num.setRow(rk.getRow());
            num.setXFIndex(rk.getXFIndex());
            num.setValue(rk.getRKNumber());
            retval = num;
        } else if (retval instanceof DBCellRecord) {
            retval = null;
        } else if (retval instanceof MulRKRecord) {
            MulRKRecord mrk = (MulRKRecord)retval;
            realretval = new Record[mrk.getNumColumns()];
            int k = 0;
            while (k < mrk.getNumColumns()) {
                NumberRecord nr = new NumberRecord();
                nr.setColumn((short)(k + mrk.getFirstColumn()));
                nr.setRow(mrk.getRow());
                nr.setXFIndex(mrk.getXFAt(k));
                nr.setValue(mrk.getRKNumberAt(k));
                realretval[k] = nr;
                ++k;
            }
        } else if (retval instanceof MulBlankRecord) {
            MulBlankRecord mb = (MulBlankRecord)retval;
            realretval = new Record[mb.getNumColumns()];
            int k = 0;
            while (k < mb.getNumColumns()) {
                BlankRecord br = new BlankRecord();
                br.setColumn((short)(k + mb.getFirstColumn()));
                br.setRow(mb.getRow());
                br.setXFIndex(mb.getXFAt(k));
                realretval[k] = br;
                ++k;
            }
        }
        if (realretval == null) {
            realretval = new Record[]{retval};
        }
        return realretval;
    }

    public static short[] getAllKnownRecordSIDs() {
        short[] results = new short[recordsMap.size()];
        int i = 0;
        Iterator iterator = recordsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Short sid = (Short)iterator.next();
            results[i++] = sid;
        }
        return results;
    }

    private static final Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        int i = 0;
        while (i < records.length) {
            Constructor constructor;
            short sid;
            Class record = records[i];
            try {
                sid = record.getField("sid").getShort(null);
                Class[] classArray = new Class[1];
                Class clazz = class$org$apache$poi$hssf$record$RecordInputStream;
                if (clazz == null) {
                    clazz = RecordFactory.class("[Lorg.apache.poi.hssf.record.RecordInputStream;", false);
                }
                classArray[0] = clazz;
                constructor = record.getConstructor(classArray);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types", illegalArgumentException);
            }
            result.put(new Short(sid), constructor);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz;
        Class clazz2;
        Class clazz3;
        Class clazz4;
        Class clazz5;
        Class clazz6;
        Class clazz7;
        Class clazz8;
        Class clazz9;
        Class clazz10;
        Class clazz11;
        Class clazz12;
        Class clazz13;
        Class clazz14;
        Class clazz15;
        Class clazz16;
        Class clazz17;
        Class clazz18;
        Class clazz19;
        Class clazz20;
        Class clazz21;
        Class clazz22;
        Class clazz23;
        Class clazz24;
        Class clazz25;
        Class clazz26;
        Class clazz27;
        Class clazz28;
        Class clazz29;
        Class clazz30;
        Class clazz31;
        Class clazz32;
        Class clazz33;
        Class clazz34;
        Class clazz35;
        Class clazz36;
        Class clazz37;
        Class clazz38;
        Class clazz39;
        Class clazz40;
        Class clazz41;
        Class clazz42;
        Class clazz43;
        Class clazz44;
        Class clazz45;
        Class clazz46;
        Class clazz47;
        Class clazz48;
        Class clazz49;
        Class clazz50;
        Class clazz51;
        Class clazz52;
        Class clazz53;
        Class clazz54;
        Class clazz55;
        Class clazz56;
        Class clazz57;
        Class clazz58;
        Class clazz59;
        Class clazz60;
        Class clazz61;
        Class clazz62;
        Class clazz63;
        Class clazz64;
        Class clazz65;
        Class clazz66;
        Class clazz67;
        Class clazz68;
        Class clazz69;
        Class clazz70;
        Class clazz71;
        Class clazz72;
        Class clazz73;
        Class clazz74;
        Class clazz75;
        Class clazz76;
        Class clazz77;
        Class clazz78;
        Class clazz79;
        Class clazz80;
        Class clazz81;
        Class clazz82;
        Class clazz83;
        Class clazz84;
        Class clazz85;
        Class clazz86;
        Class clazz87;
        NUM_RECORDS = 10000;
        Class[] classArray = new Class[88];
        Class clazz88 = class$org$apache$poi$hssf$record$BOFRecord;
        if (clazz88 == null) {
            clazz88 = classArray[0] = (class$org$apache$poi$hssf$record$BOFRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.BOFRecord;", false));
        }
        if ((clazz87 = class$org$apache$poi$hssf$record$InterfaceHdrRecord) == null) {
            clazz87 = classArray[1] = (class$org$apache$poi$hssf$record$InterfaceHdrRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.InterfaceHdrRecord;", false));
        }
        if ((clazz86 = class$org$apache$poi$hssf$record$MMSRecord) == null) {
            clazz86 = classArray[2] = (class$org$apache$poi$hssf$record$MMSRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.MMSRecord;", false));
        }
        if ((clazz85 = class$org$apache$poi$hssf$record$InterfaceEndRecord) == null) {
            clazz85 = classArray[3] = (class$org$apache$poi$hssf$record$InterfaceEndRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.InterfaceEndRecord;", false));
        }
        if ((clazz84 = class$org$apache$poi$hssf$record$WriteAccessRecord) == null) {
            clazz84 = classArray[4] = (class$org$apache$poi$hssf$record$WriteAccessRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.WriteAccessRecord;", false));
        }
        if ((clazz83 = class$org$apache$poi$hssf$record$CodepageRecord) == null) {
            clazz83 = classArray[5] = (class$org$apache$poi$hssf$record$CodepageRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.CodepageRecord;", false));
        }
        if ((clazz82 = class$org$apache$poi$hssf$record$DSFRecord) == null) {
            clazz82 = classArray[6] = (class$org$apache$poi$hssf$record$DSFRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DSFRecord;", false));
        }
        if ((clazz81 = class$org$apache$poi$hssf$record$TabIdRecord) == null) {
            clazz81 = classArray[7] = (class$org$apache$poi$hssf$record$TabIdRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.TabIdRecord;", false));
        }
        if ((clazz80 = class$org$apache$poi$hssf$record$FnGroupCountRecord) == null) {
            clazz80 = classArray[8] = (class$org$apache$poi$hssf$record$FnGroupCountRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.FnGroupCountRecord;", false));
        }
        if ((clazz79 = class$org$apache$poi$hssf$record$WindowProtectRecord) == null) {
            clazz79 = classArray[9] = (class$org$apache$poi$hssf$record$WindowProtectRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.WindowProtectRecord;", false));
        }
        if ((clazz78 = class$org$apache$poi$hssf$record$ProtectRecord) == null) {
            clazz78 = classArray[10] = (class$org$apache$poi$hssf$record$ProtectRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.ProtectRecord;", false));
        }
        if ((clazz77 = class$org$apache$poi$hssf$record$PasswordRecord) == null) {
            clazz77 = classArray[11] = (class$org$apache$poi$hssf$record$PasswordRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.PasswordRecord;", false));
        }
        if ((clazz76 = class$org$apache$poi$hssf$record$ProtectionRev4Record) == null) {
            clazz76 = classArray[12] = (class$org$apache$poi$hssf$record$ProtectionRev4Record = RecordFactory.class("[Lorg.apache.poi.hssf.record.ProtectionRev4Record;", false));
        }
        if ((clazz75 = class$org$apache$poi$hssf$record$PasswordRev4Record) == null) {
            clazz75 = classArray[13] = (class$org$apache$poi$hssf$record$PasswordRev4Record = RecordFactory.class("[Lorg.apache.poi.hssf.record.PasswordRev4Record;", false));
        }
        if ((clazz74 = class$org$apache$poi$hssf$record$WindowOneRecord) == null) {
            clazz74 = classArray[14] = (class$org$apache$poi$hssf$record$WindowOneRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.WindowOneRecord;", false));
        }
        if ((clazz73 = class$org$apache$poi$hssf$record$BackupRecord) == null) {
            clazz73 = classArray[15] = (class$org$apache$poi$hssf$record$BackupRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.BackupRecord;", false));
        }
        if ((clazz72 = class$org$apache$poi$hssf$record$HideObjRecord) == null) {
            clazz72 = classArray[16] = (class$org$apache$poi$hssf$record$HideObjRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.HideObjRecord;", false));
        }
        if ((clazz71 = class$org$apache$poi$hssf$record$DateWindow1904Record) == null) {
            clazz71 = classArray[17] = (class$org$apache$poi$hssf$record$DateWindow1904Record = RecordFactory.class("[Lorg.apache.poi.hssf.record.DateWindow1904Record;", false));
        }
        if ((clazz70 = class$org$apache$poi$hssf$record$PrecisionRecord) == null) {
            clazz70 = classArray[18] = (class$org$apache$poi$hssf$record$PrecisionRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.PrecisionRecord;", false));
        }
        if ((clazz69 = class$org$apache$poi$hssf$record$RefreshAllRecord) == null) {
            clazz69 = classArray[19] = (class$org$apache$poi$hssf$record$RefreshAllRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.RefreshAllRecord;", false));
        }
        if ((clazz68 = class$org$apache$poi$hssf$record$BookBoolRecord) == null) {
            clazz68 = classArray[20] = (class$org$apache$poi$hssf$record$BookBoolRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.BookBoolRecord;", false));
        }
        if ((clazz67 = class$org$apache$poi$hssf$record$FontRecord) == null) {
            clazz67 = classArray[21] = (class$org$apache$poi$hssf$record$FontRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.FontRecord;", false));
        }
        if ((clazz66 = class$org$apache$poi$hssf$record$FormatRecord) == null) {
            clazz66 = classArray[22] = (class$org$apache$poi$hssf$record$FormatRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.FormatRecord;", false));
        }
        if ((clazz65 = class$org$apache$poi$hssf$record$ExtendedFormatRecord) == null) {
            clazz65 = classArray[23] = (class$org$apache$poi$hssf$record$ExtendedFormatRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.ExtendedFormatRecord;", false));
        }
        if ((clazz64 = class$org$apache$poi$hssf$record$StyleRecord) == null) {
            clazz64 = classArray[24] = (class$org$apache$poi$hssf$record$StyleRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.StyleRecord;", false));
        }
        if ((clazz63 = class$org$apache$poi$hssf$record$UseSelFSRecord) == null) {
            clazz63 = classArray[25] = (class$org$apache$poi$hssf$record$UseSelFSRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.UseSelFSRecord;", false));
        }
        if ((clazz62 = class$org$apache$poi$hssf$record$BoundSheetRecord) == null) {
            clazz62 = classArray[26] = (class$org$apache$poi$hssf$record$BoundSheetRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.BoundSheetRecord;", false));
        }
        if ((clazz61 = class$org$apache$poi$hssf$record$CountryRecord) == null) {
            clazz61 = classArray[27] = (class$org$apache$poi$hssf$record$CountryRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.CountryRecord;", false));
        }
        if ((clazz60 = class$org$apache$poi$hssf$record$SSTRecord) == null) {
            clazz60 = classArray[28] = (class$org$apache$poi$hssf$record$SSTRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.SSTRecord;", false));
        }
        if ((clazz59 = class$org$apache$poi$hssf$record$ExtSSTRecord) == null) {
            clazz59 = classArray[29] = (class$org$apache$poi$hssf$record$ExtSSTRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.ExtSSTRecord;", false));
        }
        if ((clazz58 = class$org$apache$poi$hssf$record$EOFRecord) == null) {
            clazz58 = classArray[30] = (class$org$apache$poi$hssf$record$EOFRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.EOFRecord;", false));
        }
        if ((clazz57 = class$org$apache$poi$hssf$record$IndexRecord) == null) {
            clazz57 = classArray[31] = (class$org$apache$poi$hssf$record$IndexRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.IndexRecord;", false));
        }
        if ((clazz56 = class$org$apache$poi$hssf$record$CalcModeRecord) == null) {
            clazz56 = classArray[32] = (class$org$apache$poi$hssf$record$CalcModeRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.CalcModeRecord;", false));
        }
        if ((clazz55 = class$org$apache$poi$hssf$record$CalcCountRecord) == null) {
            clazz55 = classArray[33] = (class$org$apache$poi$hssf$record$CalcCountRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.CalcCountRecord;", false));
        }
        if ((clazz54 = class$org$apache$poi$hssf$record$RefModeRecord) == null) {
            clazz54 = classArray[34] = (class$org$apache$poi$hssf$record$RefModeRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.RefModeRecord;", false));
        }
        if ((clazz53 = class$org$apache$poi$hssf$record$IterationRecord) == null) {
            clazz53 = classArray[35] = (class$org$apache$poi$hssf$record$IterationRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.IterationRecord;", false));
        }
        if ((clazz52 = class$org$apache$poi$hssf$record$DeltaRecord) == null) {
            clazz52 = classArray[36] = (class$org$apache$poi$hssf$record$DeltaRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DeltaRecord;", false));
        }
        if ((clazz51 = class$org$apache$poi$hssf$record$SaveRecalcRecord) == null) {
            clazz51 = classArray[37] = (class$org$apache$poi$hssf$record$SaveRecalcRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.SaveRecalcRecord;", false));
        }
        if ((clazz50 = class$org$apache$poi$hssf$record$PrintHeadersRecord) == null) {
            clazz50 = classArray[38] = (class$org$apache$poi$hssf$record$PrintHeadersRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.PrintHeadersRecord;", false));
        }
        if ((clazz49 = class$org$apache$poi$hssf$record$PrintGridlinesRecord) == null) {
            clazz49 = classArray[39] = (class$org$apache$poi$hssf$record$PrintGridlinesRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.PrintGridlinesRecord;", false));
        }
        if ((clazz48 = class$org$apache$poi$hssf$record$GridsetRecord) == null) {
            clazz48 = classArray[40] = (class$org$apache$poi$hssf$record$GridsetRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.GridsetRecord;", false));
        }
        if ((clazz47 = class$org$apache$poi$hssf$record$GutsRecord) == null) {
            clazz47 = classArray[41] = (class$org$apache$poi$hssf$record$GutsRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.GutsRecord;", false));
        }
        if ((clazz46 = class$org$apache$poi$hssf$record$DefaultRowHeightRecord) == null) {
            clazz46 = classArray[42] = (class$org$apache$poi$hssf$record$DefaultRowHeightRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DefaultRowHeightRecord;", false));
        }
        if ((clazz45 = class$org$apache$poi$hssf$record$WSBoolRecord) == null) {
            clazz45 = classArray[43] = (class$org$apache$poi$hssf$record$WSBoolRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.WSBoolRecord;", false));
        }
        if ((clazz44 = class$org$apache$poi$hssf$record$HeaderRecord) == null) {
            clazz44 = classArray[44] = (class$org$apache$poi$hssf$record$HeaderRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.HeaderRecord;", false));
        }
        if ((clazz43 = class$org$apache$poi$hssf$record$FooterRecord) == null) {
            clazz43 = classArray[45] = (class$org$apache$poi$hssf$record$FooterRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.FooterRecord;", false));
        }
        if ((clazz42 = class$org$apache$poi$hssf$record$HCenterRecord) == null) {
            clazz42 = classArray[46] = (class$org$apache$poi$hssf$record$HCenterRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.HCenterRecord;", false));
        }
        if ((clazz41 = class$org$apache$poi$hssf$record$VCenterRecord) == null) {
            clazz41 = classArray[47] = (class$org$apache$poi$hssf$record$VCenterRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.VCenterRecord;", false));
        }
        if ((clazz40 = class$org$apache$poi$hssf$record$PrintSetupRecord) == null) {
            clazz40 = classArray[48] = (class$org$apache$poi$hssf$record$PrintSetupRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.PrintSetupRecord;", false));
        }
        if ((clazz39 = class$org$apache$poi$hssf$record$DefaultColWidthRecord) == null) {
            clazz39 = classArray[49] = (class$org$apache$poi$hssf$record$DefaultColWidthRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DefaultColWidthRecord;", false));
        }
        if ((clazz38 = class$org$apache$poi$hssf$record$DimensionsRecord) == null) {
            clazz38 = classArray[50] = (class$org$apache$poi$hssf$record$DimensionsRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DimensionsRecord;", false));
        }
        if ((clazz37 = class$org$apache$poi$hssf$record$RowRecord) == null) {
            clazz37 = classArray[51] = (class$org$apache$poi$hssf$record$RowRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.RowRecord;", false));
        }
        if ((clazz36 = class$org$apache$poi$hssf$record$LabelSSTRecord) == null) {
            clazz36 = classArray[52] = (class$org$apache$poi$hssf$record$LabelSSTRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.LabelSSTRecord;", false));
        }
        if ((clazz35 = class$org$apache$poi$hssf$record$RKRecord) == null) {
            clazz35 = classArray[53] = (class$org$apache$poi$hssf$record$RKRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.RKRecord;", false));
        }
        if ((clazz34 = class$org$apache$poi$hssf$record$NumberRecord) == null) {
            clazz34 = classArray[54] = (class$org$apache$poi$hssf$record$NumberRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.NumberRecord;", false));
        }
        if ((clazz33 = class$org$apache$poi$hssf$record$DBCellRecord) == null) {
            clazz33 = classArray[55] = (class$org$apache$poi$hssf$record$DBCellRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DBCellRecord;", false));
        }
        if ((clazz32 = class$org$apache$poi$hssf$record$WindowTwoRecord) == null) {
            clazz32 = classArray[56] = (class$org$apache$poi$hssf$record$WindowTwoRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.WindowTwoRecord;", false));
        }
        if ((clazz31 = class$org$apache$poi$hssf$record$SelectionRecord) == null) {
            clazz31 = classArray[57] = (class$org$apache$poi$hssf$record$SelectionRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.SelectionRecord;", false));
        }
        if ((clazz30 = class$org$apache$poi$hssf$record$ContinueRecord) == null) {
            clazz30 = classArray[58] = (class$org$apache$poi$hssf$record$ContinueRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.ContinueRecord;", false));
        }
        if ((clazz29 = class$org$apache$poi$hssf$record$LabelRecord) == null) {
            clazz29 = classArray[59] = (class$org$apache$poi$hssf$record$LabelRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.LabelRecord;", false));
        }
        if ((clazz28 = class$org$apache$poi$hssf$record$BlankRecord) == null) {
            clazz28 = classArray[60] = (class$org$apache$poi$hssf$record$BlankRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.BlankRecord;", false));
        }
        if ((clazz27 = class$org$apache$poi$hssf$record$ColumnInfoRecord) == null) {
            clazz27 = classArray[61] = (class$org$apache$poi$hssf$record$ColumnInfoRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.ColumnInfoRecord;", false));
        }
        if ((clazz26 = class$org$apache$poi$hssf$record$MulRKRecord) == null) {
            clazz26 = classArray[62] = (class$org$apache$poi$hssf$record$MulRKRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.MulRKRecord;", false));
        }
        if ((clazz25 = class$org$apache$poi$hssf$record$MulBlankRecord) == null) {
            clazz25 = classArray[63] = (class$org$apache$poi$hssf$record$MulBlankRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.MulBlankRecord;", false));
        }
        if ((clazz24 = class$org$apache$poi$hssf$record$MergeCellsRecord) == null) {
            clazz24 = classArray[64] = (class$org$apache$poi$hssf$record$MergeCellsRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.MergeCellsRecord;", false));
        }
        if ((clazz23 = class$org$apache$poi$hssf$record$FormulaRecord) == null) {
            clazz23 = classArray[65] = (class$org$apache$poi$hssf$record$FormulaRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.FormulaRecord;", false));
        }
        if ((clazz22 = class$org$apache$poi$hssf$record$BoolErrRecord) == null) {
            clazz22 = classArray[66] = (class$org$apache$poi$hssf$record$BoolErrRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.BoolErrRecord;", false));
        }
        if ((clazz21 = class$org$apache$poi$hssf$record$ExternSheetRecord) == null) {
            clazz21 = classArray[67] = (class$org$apache$poi$hssf$record$ExternSheetRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.ExternSheetRecord;", false));
        }
        if ((clazz20 = class$org$apache$poi$hssf$record$NameRecord) == null) {
            clazz20 = classArray[68] = (class$org$apache$poi$hssf$record$NameRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.NameRecord;", false));
        }
        if ((clazz19 = class$org$apache$poi$hssf$record$LeftMarginRecord) == null) {
            clazz19 = classArray[69] = (class$org$apache$poi$hssf$record$LeftMarginRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.LeftMarginRecord;", false));
        }
        if ((clazz18 = class$org$apache$poi$hssf$record$RightMarginRecord) == null) {
            clazz18 = classArray[70] = (class$org$apache$poi$hssf$record$RightMarginRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.RightMarginRecord;", false));
        }
        if ((clazz17 = class$org$apache$poi$hssf$record$TopMarginRecord) == null) {
            clazz17 = classArray[71] = (class$org$apache$poi$hssf$record$TopMarginRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.TopMarginRecord;", false));
        }
        if ((clazz16 = class$org$apache$poi$hssf$record$BottomMarginRecord) == null) {
            clazz16 = classArray[72] = (class$org$apache$poi$hssf$record$BottomMarginRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.BottomMarginRecord;", false));
        }
        if ((clazz15 = class$org$apache$poi$hssf$record$DrawingRecord) == null) {
            clazz15 = classArray[73] = (class$org$apache$poi$hssf$record$DrawingRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DrawingRecord;", false));
        }
        if ((clazz14 = class$org$apache$poi$hssf$record$DrawingGroupRecord) == null) {
            clazz14 = classArray[74] = (class$org$apache$poi$hssf$record$DrawingGroupRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DrawingGroupRecord;", false));
        }
        if ((clazz13 = class$org$apache$poi$hssf$record$DrawingSelectionRecord) == null) {
            clazz13 = classArray[75] = (class$org$apache$poi$hssf$record$DrawingSelectionRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.DrawingSelectionRecord;", false));
        }
        if ((clazz12 = class$org$apache$poi$hssf$record$ObjRecord) == null) {
            clazz12 = classArray[76] = (class$org$apache$poi$hssf$record$ObjRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.ObjRecord;", false));
        }
        if ((clazz11 = class$org$apache$poi$hssf$record$TextObjectRecord) == null) {
            clazz11 = classArray[77] = (class$org$apache$poi$hssf$record$TextObjectRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.TextObjectRecord;", false));
        }
        if ((clazz10 = class$org$apache$poi$hssf$record$PaletteRecord) == null) {
            clazz10 = classArray[78] = (class$org$apache$poi$hssf$record$PaletteRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.PaletteRecord;", false));
        }
        if ((clazz9 = class$org$apache$poi$hssf$record$StringRecord) == null) {
            clazz9 = classArray[79] = (class$org$apache$poi$hssf$record$StringRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.StringRecord;", false));
        }
        if ((clazz8 = class$org$apache$poi$hssf$record$RecalcIdRecord) == null) {
            clazz8 = classArray[80] = (class$org$apache$poi$hssf$record$RecalcIdRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.RecalcIdRecord;", false));
        }
        if ((clazz7 = class$org$apache$poi$hssf$record$SharedFormulaRecord) == null) {
            clazz7 = classArray[81] = (class$org$apache$poi$hssf$record$SharedFormulaRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.SharedFormulaRecord;", false));
        }
        if ((clazz6 = class$org$apache$poi$hssf$record$HorizontalPageBreakRecord) == null) {
            clazz6 = classArray[82] = (class$org$apache$poi$hssf$record$HorizontalPageBreakRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.HorizontalPageBreakRecord;", false));
        }
        if ((clazz5 = class$org$apache$poi$hssf$record$VerticalPageBreakRecord) == null) {
            clazz5 = classArray[83] = (class$org$apache$poi$hssf$record$VerticalPageBreakRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.VerticalPageBreakRecord;", false));
        }
        if ((clazz4 = class$org$apache$poi$hssf$record$WriteProtectRecord) == null) {
            clazz4 = classArray[84] = (class$org$apache$poi$hssf$record$WriteProtectRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.WriteProtectRecord;", false));
        }
        if ((clazz3 = class$org$apache$poi$hssf$record$FilePassRecord) == null) {
            clazz3 = classArray[85] = (class$org$apache$poi$hssf$record$FilePassRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.FilePassRecord;", false));
        }
        if ((clazz2 = class$org$apache$poi$hssf$record$PaneRecord) == null) {
            clazz2 = classArray[86] = (class$org$apache$poi$hssf$record$PaneRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.PaneRecord;", false));
        }
        if ((clazz = class$org$apache$poi$hssf$record$NoteRecord) == null) {
            clazz = class$org$apache$poi$hssf$record$NoteRecord = RecordFactory.class("[Lorg.apache.poi.hssf.record.NoteRecord;", false);
        }
        classArray[87] = clazz;
        records = classArray;
        recordsMap = RecordFactory.recordsToMap(records);
    }
}

