/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;

public class StaticArrayCallback
implements ArrayCallback {
    private TypeValuePair[][] backend;
    private int rowCount;
    private int colCount;

    public StaticArrayCallback(ArrayCallback source) throws EvaluationException {
        this.rowCount = source.getRowCount();
        this.colCount = source.getColumnCount();
        this.backend = new TypeValuePair[this.rowCount][this.colCount];
        for (int row = 0; row < this.rowCount; ++row) {
            for (int col = 0; col < this.colCount; ++col) {
                Type type = source.getType(row, col);
                Object value = source.getValue(row, col);
                this.backend[row][col] = new TypeValuePair(type, value);
            }
        }
    }

    public LValue getRaw(int row, int column) throws EvaluationException {
        return new StaticValue(this.getValue(row, column), this.getType(row, column));
    }

    public Object getValue(int row, int column) throws EvaluationException {
        return this.backend[row][column].getValue();
    }

    public Type getType(int row, int column) throws EvaluationException {
        return this.backend[row][column].getType();
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

