/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DrawingManager2 {
    EscherDggRecord dgg;
    List drawingGroups;

    public EscherDgRecord createDgRecord() {
        EscherDgRecord dg = new EscherDgRecord();
        dg.setRecordId((short)-4088);
        short dgId = this.findNewDrawingGroupId();
        dg.setOptions((short)(dgId << 4));
        dg.setNumShapes(0);
        dg.setLastMSOSPID(-1);
        this.drawingGroups.add(dg);
        this.dgg.addCluster(dgId, 0);
        this.dgg.setDrawingsSaved(this.dgg.getDrawingsSaved() + 1);
        return dg;
    }

    public int allocateShapeId(short drawingGroupId) {
        this.dgg.setNumShapesSaved(this.dgg.getNumShapesSaved() + 1);
        int i = 0;
        while (i < this.dgg.getFileIdClusters().length) {
            EscherDggRecord.FileIdCluster c = this.dgg.getFileIdClusters()[i];
            if (c.getDrawingGroupId() == drawingGroupId && c.getNumShapeIdsUsed() != 1024) {
                int result = c.getNumShapeIdsUsed() + 1024 * (i + 1);
                c.incrementShapeId();
                EscherDgRecord dg = this.getDrawingGroup(drawingGroupId);
                dg.setNumShapes(dg.getNumShapes() + 1);
                dg.setLastMSOSPID(result);
                if (result >= this.dgg.getShapeIdMax()) {
                    this.dgg.setShapeIdMax(result + 1);
                }
                return result;
            }
            ++i;
        }
        this.dgg.addCluster(drawingGroupId, 0);
        this.dgg.getFileIdClusters()[this.dgg.getFileIdClusters().length - 1].incrementShapeId();
        EscherDgRecord dg = this.getDrawingGroup(drawingGroupId);
        dg.setNumShapes(dg.getNumShapes() + 1);
        int result = 1024 * this.dgg.getFileIdClusters().length;
        dg.setLastMSOSPID(result);
        if (result >= this.dgg.getShapeIdMax()) {
            this.dgg.setShapeIdMax(result + 1);
        }
        return result;
    }

    short findNewDrawingGroupId() {
        short dgId = 1;
        while (this.drawingGroupExists(dgId)) {
            dgId = (short)(dgId + 1);
        }
        return dgId;
    }

    EscherDgRecord getDrawingGroup(int drawingGroupId) {
        return (EscherDgRecord)this.drawingGroups.get(drawingGroupId - 1);
    }

    boolean drawingGroupExists(short dgId) {
        int i = 0;
        while (i < this.dgg.getFileIdClusters().length) {
            if (this.dgg.getFileIdClusters()[i].getDrawingGroupId() == dgId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int findFreeSPIDBlock() {
        int max = this.dgg.getShapeIdMax();
        int next = (max / 1024 + 1) * 1024;
        return next;
    }

    public EscherDggRecord getDgg() {
        return this.dgg;
    }

    private final /* synthetic */ void this() {
        this.drawingGroups = new ArrayList();
    }

    public DrawingManager2(EscherDggRecord dgg) {
        this.this();
        this.dgg = dgg;
    }
}

