/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import org.apache.poi.ddf.EscherBoolProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRGBProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hssf.model.CommentShape;
import org.apache.poi.hssf.model.ConvertAnchor;
import org.apache.poi.hssf.model.LineShape;
import org.apache.poi.hssf.model.PictureShape;
import org.apache.poi.hssf.model.PolygonShape;
import org.apache.poi.hssf.model.SimpleFilledShape;
import org.apache.poi.hssf.model.TextboxShape;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPolygon;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.hssf.usermodel.HSSFTextbox;

public abstract class AbstractShape {
    public static AbstractShape createShape(HSSFShape hssfShape, int shapeId) {
        AbstractShape shape;
        if (hssfShape instanceof HSSFComment) {
            shape = new CommentShape((HSSFComment)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFTextbox) {
            shape = new TextboxShape((HSSFTextbox)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFPolygon) {
            shape = new PolygonShape((HSSFPolygon)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFSimpleShape) {
            HSSFSimpleShape simpleShape = (HSSFSimpleShape)hssfShape;
            switch (simpleShape.getShapeType()) {
                case 8: {
                    shape = new PictureShape(simpleShape, shapeId);
                    break;
                }
                case 1: {
                    shape = new LineShape(simpleShape, shapeId);
                    break;
                }
                case 2: 
                case 3: {
                    shape = new SimpleFilledShape(simpleShape, shapeId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Do not know how to handle this type of shape");
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown shape type");
        }
        EscherSpRecord sp = ((AbstractShape)shape).getSpContainer().getChildById((short)-4086);
        if (hssfShape.getParent() != null) {
            sp.setFlags(sp.getFlags() | 2);
        }
        return shape;
    }

    public abstract EscherContainerRecord getSpContainer();

    public abstract ObjRecord getObjRecord();

    protected EscherRecord createAnchor(HSSFAnchor userAnchor) {
        return ConvertAnchor.createAnchor(userAnchor);
    }

    protected int addStandardOptions(HSSFShape shape, EscherOptRecord opt) {
        opt.addEscherProperty(new EscherBoolProperty(191, 524288));
        if (shape.isNoFill()) {
            opt.addEscherProperty(new EscherBoolProperty(447, 0x110000));
        } else {
            opt.addEscherProperty(new EscherBoolProperty(447, 65536));
        }
        opt.addEscherProperty(new EscherRGBProperty(385, shape.getFillColor()));
        opt.addEscherProperty(new EscherBoolProperty(959, 524288));
        opt.addEscherProperty(new EscherRGBProperty(448, shape.getLineStyleColor()));
        int options = 5;
        if (shape.getLineWidth() != 9525) {
            opt.addEscherProperty(new EscherSimpleProperty(459, shape.getLineWidth()));
            ++options;
        }
        if (shape.getLineStyle() != 0) {
            opt.addEscherProperty(new EscherSimpleProperty(462, shape.getLineStyle()));
            opt.addEscherProperty(new EscherSimpleProperty(471, 0));
            if (shape.getLineStyle() == -1) {
                opt.addEscherProperty(new EscherBoolProperty(511, 524288));
            } else {
                opt.addEscherProperty(new EscherBoolProperty(511, 524296));
            }
            options += 3;
        }
        opt.sortProperties();
        return options;
    }

    protected AbstractShape() {
    }
}

