/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;

public class Util {
    public static final long EPOCH_DIFF = 11644473600000L;

    public static boolean equal(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void copy(byte[] src, int srcOffset, int length, byte[] dst, int dstOffset) {
        int i = 0;
        while (i < length) {
            dst[dstOffset + i] = src[srcOffset + i];
            ++i;
        }
    }

    public static byte[] cat(byte[][] byteArrays) {
        int capacity = 0;
        int i = 0;
        while (i < byteArrays.length) {
            capacity += byteArrays[i].length;
            ++i;
        }
        byte[] result = new byte[capacity];
        int r = 0;
        int i2 = 0;
        while (i2 < byteArrays.length) {
            int j = 0;
            while (j < byteArrays[i2].length) {
                result[r++] = byteArrays[i2][j];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public static byte[] copy(byte[] src, int offset, int length) {
        byte[] result = new byte[length];
        Util.copy(src, offset, length, result, 0);
        return result;
    }

    public static Date filetimeToDate(int high, int low) {
        long filetime = (long)high << 32 | (long)low & 0xFFFFFFFFL;
        return Util.filetimeToDate(filetime);
    }

    public static Date filetimeToDate(long filetime) {
        long ms_since_16010101 = filetime / 10000L;
        long ms_since_19700101 = ms_since_16010101 - 11644473600000L;
        return new Date(ms_since_19700101);
    }

    public static long dateToFileTime(Date date) {
        long ms_since_19700101 = date.getTime();
        long ms_since_16010101 = ms_since_19700101 + 11644473600000L;
        return ms_since_16010101 * 10000L;
    }

    public static boolean equals(Collection c1, Collection c2) {
        Object[] o1 = c1.toArray();
        Object[] o2 = c2.toArray();
        return Util.internalEquals(o1, o2);
    }

    public static boolean equals(Object[] c1, Object[] c2) {
        Object[] o1 = (Object[])c1.clone();
        Object[] o2 = (Object[])c2.clone();
        return Util.internalEquals(o1, o2);
    }

    private static final boolean internalEquals(Object[] o1, Object[] o2) {
        int i1 = 0;
        while (i1 < o1.length) {
            Object obj1 = o1[i1];
            boolean matchFound = false;
            int i2 = 0;
            while (!matchFound && i2 < o1.length) {
                Object obj2 = o2[i2];
                if (obj1.equals(obj2)) {
                    matchFound = true;
                    o2[i2] = null;
                }
                ++i2;
            }
            if (!matchFound) {
                return false;
            }
            ++i1;
        }
        return true;
    }

    public static byte[] pad4(byte[] ba) {
        byte[] result;
        int PAD = 4;
        int l = ba.length % 4;
        if (l == 0) {
            result = ba;
        } else {
            l = 4 - l;
            result = new byte[ba.length + l];
            System.arraycopy(ba, 0, result, 0, ba.length);
        }
        return result;
    }

    public static char[] pad4(char[] ca) {
        char[] result;
        int PAD = 4;
        int l = ca.length % 4;
        if (l == 0) {
            result = ca;
        } else {
            l = 4 - l;
            result = new char[ca.length + l];
            System.arraycopy(ca, 0, result, 0, ca.length);
        }
        return result;
    }

    public static char[] pad4(String s) {
        return Util.pad4(s.toCharArray());
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        try {
            sw.close();
            return sw.toString();
        }
        catch (IOException e) {
            StringBuffer b = new StringBuffer(t.getMessage());
            b.append("\n");
            b.append("Could not create a stacktrace. Reason: ");
            b.append(e.getMessage());
            return b.toString();
        }
    }
}

