# -*- coding: utf-8 -*-
# vim:set noet ts=4:
#
# scim-python
#
# Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA
#
# $Id: $
#
import os.path as path
import traceback
import sys
from glob import glob

helpers = None

def _init_helpers ():
	global helpers
	if helpers == None:
		helpers = []
		wildcast = path.join (path.dirname (__file__), "*")
		for name in [name for name in glob (wildcast) if path.isdir (name)]:
			name = path.basename (name)
			try:
				mod = __import__ (name, globals (), locals (), [])
				helpers.append ((mod, mod.get_info ()))
			except:
				traceback.print_exc ()

def number_of_helpers ():
	return len (helpers)

def get_helper_info (index):
	info = None
	try:
		info =  helpers[index][1]
	except:
		traceback.print_exc ()
	return info

def run_helper (uuid, config, display):
	try:
		for helper in helpers:
			if helper[1][0] == uuid:
				try:
					helper[0].run_helper (uuid, config, display)
				except:
					traceback.print_exc ()
				return
		print >> sys.stderr, "Can not find a helper with uuid=%s" % uuid
	except:
		traceback.print_exc ()

_init_helpers ()
