/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import javax.swing.JTextPane;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.util.LineGetter;

public class CodeEditorTextPane
extends JTextPane
implements LineGetter,
ActionListener {
    private static final String SETTINGS_FILE_NAME = System.getProperty("user.home") + System.getProperty("file.separator") + ".pmd_designer";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public CodeEditorTextPane() {
        this.setText(this.loadCode());
    }

    public String getLine(int number) {
        int count = 1;
        StringTokenizer st = new StringTokenizer(this.getText(), "\n");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (count == number) {
                return tok;
            }
            ++count;
        }
        throw new RuntimeException("Line number " + number + " not found");
    }

    private int getPosition(String[] lines, int line, int column) {
        int pos = 0;
        int count = 0;
        while (count < lines.length) {
            String tok = lines[count++];
            if (count == line) {
                int linePos = 0;
                int i = 0;
                while (linePos < column) {
                    ++linePos;
                    if (tok.charAt(i) == '\t') {
                        --linePos;
                        linePos += 8 - (linePos & 7);
                    }
                    ++i;
                }
                return pos + i - 1;
            }
            pos += tok.length() + 1;
        }
        throw new RuntimeException("Line " + line + " not found");
    }

    public void select(SimpleNode node) {
        String[] lines = this.getText().split(LINE_SEPARATOR);
        this.setSelectionStart(this.getPosition(lines, node.getBeginLine(), node.getBeginColumn()));
        this.setSelectionEnd(this.getPosition(lines, node.getEndLine(), node.getEndColumn()) + 1);
        this.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent ae) {
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(SETTINGS_FILE_NAME));
            fw.write(this.getText());
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadCode() {
        BufferedReader br = null;
        try {
            String hold;
            br = new BufferedReader(new FileReader(new File(SETTINGS_FILE_NAME)));
            StringBuffer text = new StringBuffer();
            while ((hold = br.readLine()) != null) {
                text.append(hold).append(LINE_SEPARATOR);
            }
            String string = text.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

