'''OpenGL extension EXT.light_texture

Overview (from the spec)
	
	    This extension defines a general mechanism for substituting the
	    fragment color computed during texture environment processing in
	    place of other fragment attributes such as the fragment normal, or
	    as sources for some of the computations in the fragment processing
	    pipeline, for example as material or light parameters in the
	    fragment lighting computations.
	
	
	    Cf ----------------------+
				     |                 +-> to lighting parameters
	                             v                 |
	    +------------+        +--------+     +-------------+
	    |            |        |        |     |             |
	    | texel      |------->| texenv |-----| texture     |---> Cf' (to Light Environment
	    | generation |        |        |     | application |          or Fog)
	    |            |        |        |     |             |
	    +------------+        +--------+     +-------------+
	

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/light_texture.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_FRAGMENT_MATERIAL_EXT = constant.Constant( 'GL_FRAGMENT_MATERIAL_EXT', 0x8349 )
GL_FRAGMENT_NORMAL_EXT = constant.Constant( 'GL_FRAGMENT_NORMAL_EXT', 0x834A )
GL_FRAGMENT_COLOR_EXT = constant.Constant( 'GL_FRAGMENT_COLOR_EXT', 0x834C )
GL_ATTENUATION_EXT = constant.Constant( 'GL_ATTENUATION_EXT', 0x834D )
GL_SHADOW_ATTENUATION_EXT = constant.Constant( 'GL_SHADOW_ATTENUATION_EXT', 0x834E )
GL_TEXTURE_APPLICATION_MODE_EXT = constant.Constant( 'GL_TEXTURE_APPLICATION_MODE_EXT', 0x834F )
GL_TEXTURE_LIGHT_EXT = constant.Constant( 'GL_TEXTURE_LIGHT_EXT', 0x8350 )
GL_TEXTURE_MATERIAL_FACE_EXT = constant.Constant( 'GL_TEXTURE_MATERIAL_FACE_EXT', 0x8351 )
GL_TEXTURE_MATERIAL_PARAMETER_EXT = constant.Constant( 'GL_TEXTURE_MATERIAL_PARAMETER_EXT', 0x8352 )
glApplyTextureEXT = platform.createExtensionFunction( 
	'glApplyTextureEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum,),
	doc = 'glApplyTextureEXT( GLenum(mode) ) -> None',
	argNames = ('mode',),
)

glTextureLightEXT = platform.createExtensionFunction( 
	'glTextureLightEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum,),
	doc = 'glTextureLightEXT( GLenum(pname) ) -> None',
	argNames = ('pname',),
)

glTextureMaterialEXT = platform.createExtensionFunction( 
	'glTextureMaterialEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum,),
	doc = 'glTextureMaterialEXT( GLenum(face), GLenum(mode) ) -> None',
	argNames = ('face', 'mode',),
)


def glInitLightTextureEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_EXT_light_texture' )
