// created on 04.08.2003 at 18:08
using System;
using MonoDevelop.Projects.Parser;

namespace VBBinding.Parser.SharpDevelopTree
{
	public class ReturnType : DefaultReturnType
	{
		public ReturnType(string fullyQualifiedName): base (fullyQualifiedName)
		{
		}
		
		public ReturnType(string fullyQualifiedName, int[] arrayDimensions, int pointerNestingLevel)
		{
			this.FullyQualifiedName  = fullyQualifiedName;
			this.arrayDimensions     = arrayDimensions;
			this.pointerNestingLevel = pointerNestingLevel;
		}
		
		public ReturnType(ICSharpCode.NRefactory.Parser.AST.TypeReference type)
		{
			base.FullyQualifiedName  = type.SystemType == null ? type.Type : type.SystemType;
			base.arrayDimensions     = type.RankSpecifier == null ? new int[] { } : type.RankSpecifier;
			base.pointerNestingLevel = 0;
		}
		
		public ReturnType Clone()
		{
			return new ReturnType(FullyQualifiedName, arrayDimensions, pointerNestingLevel);
		}
	}
}
