=begin
  parser/erb.rb - parser for ERB

  Copyright (C) 2005  Masao Mutoh
 
  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: erb.rb,v 1.2 2005/08/20 17:05:34 mutoh Exp $
=end

require 'erb'
require 'gettext/parser/ruby.rb'

module GetText
  module ErbParser
    module_function
    def parse(file, targets = [])
      erb = ERB.new(IO.readlines(file).join).src.split(/$/)
      RubyParser.parse_lines(file, erb, targets)
    end

    def target?(file)
      File.extname(file) == '.rhtml'
    end
  end
end

if __FILE__ == $0
  # ex) ruby glade.rhtml foo.rhtml  bar.rhtml
  ARGV.each do |file|
    p GetText::ErbParser.parse(file)
  end
end
