=begin
  rmsgfmt.rb - Generate a .mo

  Copyright (C) 2003-2005 Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.
=end

#
# DO NOT MODIFY!!!!
# This file is automatically generated by racc 1.4.4
# from racc grammer file "src/rmsgfmt.ry".
#

require 'racc/parser'


module GetText

  class PoParser < Racc::Parser

module_eval <<'..end src/rmsgfmt.ry modeval..id0ade4036b6', 'src/rmsgfmt.ry', 90
  def unescape(orig)
    ret = orig.gsub(/\\n/, "\n")
    ret.gsub!(/\\t/, "\t")
    ret.gsub!(/\\r/, "\r")
    ret.gsub!(/\\"/, "\"")
    ret
  end
  
  def parse(str, data)
    @data = data
    @fuzzy = false
    str.strip!
    @q = []
    until str.empty? do
      case str
      when /\A\s+/
	str = $'
      when /\Amsgid_plural/
	@q.push [:MSGID_PLURAL, $&]
	str = $'
      when /\Amsgid/
	@q.push [:MSGID, $&]
	str = $'
      when /\Amsgstr/
	@q.push [:MSGSTR, $&]
	str = $'
      when /\A\[(\d+)\]/
	@q.push [:PLURAL_NUM, $1]
	str = $'
      when /\A\#~(.*)/
	$stderr.print _("Warning: obsolete msgid is existed.\n")
	$stderr.print "         #{$&}\n"
	str = $'
      when /\A\#/
	@q.push [:COMMENT, $&]
	str = $'
      when /\A\"(.*)\"/
	@q.push [:STRING, $1]
	str = $'
      else
	c = str[0,1]
	@q.push [:STRING, c]
	str = str[1..-1]
      end
    end 
    @q.push [false, '$end']
    if $DEBUG
      @q.each do |a,b|
      puts "[#{a}, #{b}]"
      end
    end
    @yydebug = true if $DEBUG
    do_parse
  end
  
  def next_token
    @q.shift
  end
  
..end src/rmsgfmt.ry modeval..id0ade4036b6

##### racc 1.4.4 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 0, 9, :_reduce_none,
 2, 9, :_reduce_none,
 2, 9, :_reduce_none,
 4, 11, :_reduce_4,
 5, 11, :_reduce_5,
 2, 13, :_reduce_6,
 1, 13, :_reduce_none,
 3, 14, :_reduce_8,
 2, 10, :_reduce_9,
 1, 10, :_reduce_none,
 2, 12, :_reduce_11,
 1, 12, :_reduce_12 ]

racc_reduce_n = 13

racc_shift_n = 22

racc_action_table = [
     3,     9,     4,     5,    12,    13,    11,    18,    11,    11,
     9,     9,     9,     7,    11,    18,    20,     9,    11 ]

racc_action_check = [
     1,    13,     1,     1,    10,    10,    10,    14,    14,     8,
     4,    12,     5,     3,    15,    16,    18,    20,    21 ]

racc_action_pointer = [
   nil,     0,   nil,    13,     4,     6,   nil,   nil,     3,   nil,
     0,   nil,     5,    -5,     2,     8,    10,   nil,     9,   nil,
    11,    12 ]

racc_action_default = [
    -1,   -13,    -3,   -13,   -10,   -13,    -2,    22,    -9,   -12,
   -13,   -11,   -13,   -13,   -13,    -4,    -5,    -7,   -13,    -6,
   -13,    -8 ]

racc_goto_table = [
     8,    10,    17,     2,    19,     6,    16,     1,    14,    15,
   nil,   nil,   nil,   nil,   nil,   nil,    21 ]

racc_goto_check = [
     4,     4,     6,     3,     6,     2,     5,     1,     4,     4,
   nil,   nil,   nil,   nil,   nil,   nil,     4 ]

racc_goto_pointer = [
   nil,     7,     4,     2,    -4,    -8,   -12 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,   nil,   nil,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :COMMENT => 2,
 :MSGID => 3,
 :MSGID_PLURAL => 4,
 :MSGSTR => 5,
 :STRING => 6,
 :PLURAL_NUM => 7 }

racc_use_result_var = true

racc_nt_base = 8

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'COMMENT',
'MSGID',
'MSGID_PLURAL',
'MSGSTR',
'STRING',
'PLURAL_NUM',
'$start',
'msgfmt',
'comment',
'message',
'string_list',
'msgstr_plural',
'msgstr_plural_line']

Racc_debug_parser = true

##### racc system variables end #####

 # reduce 0 omitted

 # reduce 1 omitted

 # reduce 2 omitted

 # reduce 3 omitted

module_eval <<'.,.,', 'src/rmsgfmt.ry', 36
  def _reduce_4( val, _values, result )
    if @fuzzy
      if val[1] != ""
        $stderr.print _("Warning: fuzzy message was ignored.\n")
        $stderr.print "         msgid '#{val[1]}'\n"
      else
	@data[""] = unescape(val[3])
      end
      @fuzzy = false
    else
      @data[unescape(val[1])] = unescape(val[3]) 
    end
    result = ""
   result
  end
.,.,

module_eval <<'.,.,', 'src/rmsgfmt.ry', 51
  def _reduce_5( val, _values, result )
    if @fuzzy
      if val[1] != ""
        $stderr.print _("Warning: fuzzy message was ignored.\n")
        $stderr.print "msgid = '#{val[1]}\n"
      else
	@data[""] = unescape(val[3])
      end
      @fuzzy = false
    else
      @data[unescape(val[1]) + "\000" + unescape(val[3])] = unescape(val[4])
    end
    result = ""
   result
  end
.,.,

module_eval <<'.,.,', 'src/rmsgfmt.ry', 58
  def _reduce_6( val, _values, result )
    result = val[0] + "\000" + val[1]
   result
  end
.,.,

 # reduce 7 omitted

module_eval <<'.,.,', 'src/rmsgfmt.ry', 66
  def _reduce_8( val, _values, result )
    result = val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'src/rmsgfmt.ry', 73
  def _reduce_9( val, _values, result )
    @fuzzy = true if /fuzzy/ =~ val[1]
   result
  end
.,.,

 # reduce 10 omitted

module_eval <<'.,.,', 'src/rmsgfmt.ry', 81
  def _reduce_11( val, _values, result )
    result = val.delete_if{|item| item == ""}.join
   result
  end
.,.,

module_eval <<'.,.,', 'src/rmsgfmt.ry', 85
  def _reduce_12( val, _values, result )
    result = val[0]
   result
  end
.,.,

 def _reduce_none( val, _values, result )
  result
 end

  end   # class PoParser

end   # module GetText

require 'optparse'
require 'gettext'
require 'fileutils'

include GetText
GetText.bindtextdomain("rmsgfmt")

module GetText
  module RMsgfmt
    VERSION = GetText::VERSION
    DATE = %w($Date: 2005/09/03 09:54:02 $)[1]
    
    module_function
    def run(targetfile = nil, output_path = nil)
      unless targetfile
	targetfile, output_path = check_options
      end
      unless targetfile
	raise ArgumentError, _("no input files")
      end
      unless output_path
	output_path = "messages.mo"
      end

      parser = PoParser.new
      data = MOFile.new
      parser.parse(File.open(targetfile).read, data)
      data.save_to_file(output_path)
    end

    def check_options
      output = nil

      opts = OptionParser.new
      opts.banner = _("Usage: %s input.po [-o output.mo]" % $0)
      opts.separator("")
      opts.separator(_("Generate binary message catalog from textual translation description."))
      opts.separator("")
      opts.separator(_("Specific options:"))

      opts.on("-o", "--output=FILE", _("write output to specified file")) do |out|
	output = out
      end

      opts.on_tail("--version", _("display version information and exit")) do
	puts "#{$0} #{VERSION} (#{DATE})"
	exit
      end
      opts.parse!(ARGV)

      if ARGV.size == 0
	puts opts.help
	exit 1
      end

      [ARGV[0], output]
    end
  end

  module_function
  def rmsgfmt(targetfile = nil, output_path = nil)
    RMsgfmt.run(targetfile, output_path)
  end

  def create_mofiles(verbose = false, 
		     podir = "./po", targetdir = "./data/locale", 
		     targetpath_rule = "%s/LC_MESSAGES")

    modir = File.join(targetdir, targetpath_rule)
    Dir.glob(File.join(podir, "*/*.po")) do |file|
      lang, basename = /\/([^\/]+?)\/(.*)\.po/.match(file[podir.size..-1]).to_a[1,2]
      outdir = modir % lang
      FileUtils.mkdir_p(outdir) unless File.directory?(outdir)
      rmsgfmt(file, File.join(outdir, "#{basename}.mo"))
      if verbose
	$stderr.puts %Q[#{file} -> #{File.join(outdir, "#{basename}.mo")}]
      end
    end
  end
end

if $0 == __FILE__ then
  GetText.rmsgfmt
end
