=begin
  locale_win32.rb - Locale module for win32.

  Copyright (C) 2002,2003  Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: locale_win32.rb,v 1.2 2005/08/20 17:05:34 mutoh Exp $
=end

require 'gettext/locale_table_win32'

module Locale
  def __get
    pri_id, sub_id = __locale_id
    lang = LocaleTable.assoc(pri_id)
    if lang.size == 3
      lang = lang[2].assoc(sub_id)
    end
    lang ? lang[1] : nil
  end

  unless defined? CTYPE
    CTYPE = 0
    NUMERIC = 1
    TIME = 2
    COLLATE = 3
    MONETARY = 4
    MESSAGES = 5
    ALL = 6
  end
  module_function :__get
end

