/*
              Copyright (C) 1993 - 2001   Masahito Yamaga

Permission to use, copy, and distribute this package and its documentation
for any purpose is granted, provided that this permission notice is included
in supporting documentation.

Permission to modify this package is also granted, but please send an e-mail
to Yamaga (ma@yama-ga.com) in case of distributing the modified code.

This package provides NO WARRANTY. You can use this at your own risks.

Copyrights on this package belong to Masahito Yamaga, but GNUPLOT's to Mr.
Thomas Williams and Mr. Colin Kelley (See "Copyright" in the original GNUPLOT
source package).

Distribution of GNUPLOT that has been applied this patch to (especially
binaries) has to be very carefully done. See "Copyright" in the original
GNUPLOT source package.

                                   2001/01/11 Masahito Yamaga(ma@yama-ga.com)
*/

#include <stdio.h>
#include <string.h>
#include "gp+lib.h"

int nword;
struct style Style[MAXWORD];

#ifdef __STDC__
extern unsigned char *command_check(unsigned char *,const char *,int,int *);
extern unsigned char *command_check2(unsigned char *,const char *);
extern unsigned char *get_size(unsigned char *,const char *, int *);
#else
extern unsigned char *command_check();
extern unsigned char *command_check2();
extern unsigned char *get_size();
#endif

#ifdef __STDC__
int endofword(int i,int cfont,int cbfont,int ciso,int cfopt,int cpos,int csize,
       int ccolor,int copt,int cfrac,int coverline,int cunderline,int csqrtline)
#else
int endofword(i,cfont,cbfont,ciso,cfopt,cpos,csize,ccolor,copt,cfrac,
                                                 coverline,cunderline,csqrtline)
int i,
    cfont,cbfont,ciso,cfopt,cpos,csize,ccolor,copt,cfrac,
    coverline,cunderline,csqrtline;
#endif
{
	if(i) {
		Style[nword].Font=cfont;
		Style[nword].Bfont=cbfont;
		Style[nword].Iso=ciso;
		Style[nword].Fopt=cfopt;
		Style[nword].Pos=cpos;

		if (!csize) {
			switch(cpos){
			case SUPERSC:
			case SUBSC:
				csize=SCRIPTSIZE;
				break;
			case SUPERSUPERSC:
			case SUBSUBSC:
			case SUPERSUBSC:
			case SUBSUPERSC:
				csize=TINY;
				break;
			default:
				csize=NORMALSIZE;
				break;
			}
		}
		Style[nword].Size=csize;

		Style[nword].Color=ccolor;
		Style[nword].Opt=copt;
		Style[nword].Frac=cfrac;
		Style[nword].Overline=coverline;
		Style[nword].Underline=cunderline;
		Style[nword].Sqrtline=csqrtline;
		Style[nword++].Body[i]='\0';
	}
	return i;
}

#ifdef __STDC__
unsigned char *divide_word(unsigned char *str,int math,int kanji,int cfont,
	int cbfont,int ciso,int cfopt,int cpos,int csize,int ccolor,int copt,
	int cfrac,int coverline,int cunderline,int csqrtline)
#else
unsigned char *divide_word(str,math,kanji,cfont,cbfont,ciso,cfopt,cpos,csize,
	ccolor,copt,cfrac,coverline,cunderline,csqrtline)
unsigned char *str;
int math,kanji,cfont,cbfont,ciso,cfopt,cpos,csize,ccolor,copt,cfrac,
	            coverline,cunderline,csqrtline;
#endif
{
	static int iw;
	int tmppos,tmpsize;
	unsigned char *tmp;

#define ENDOFWORD endofword(iw,cfont,cbfont,ciso,cfopt,cpos,csize,ccolor,\
			copt,cfrac,coverline,cunderline,csqrtline)
#define ENDOFWORD2(x) endofword(iw,x,cbfont,ciso,cfopt,tmppos,tmpsize,\
			ccolor, copt,cfrac,coverline,cunderline,csqrtline)
#define ENDOFWORD3(x) endofword(iw,x,cbfont,ciso,cfopt,cpos,csize,ccolor,\
			copt,cfrac,coverline,cunderline,csqrtline)

#define COMCHECK(x,y,z) str=command_check(str,x,y,z)
#define COMCHECK2(x,y) if (str!=(tmp=command_check2(str,x))){\
		str=tmp;\
		ENDOFWORD;\
		str=divide_word(str,math,kanji,cfont,cbfont,ciso,cfopt,cpos,\
		csize,ccolor,y,cfrac,coverline,cunderline,csqrtline);}
#define COMCHECK3(x,y,z,w,u) if (str!=(tmp=command_check2(str,x))){\
		str=tmp;\
		ENDOFWORD;\
		str=divide_word(str,math,kanji,cfont,cbfont,ciso,cfopt,cpos,\
						csize,ccolor,copt,y,z,w,u);}
#define COMCHECK4(x,y) if (str!=(tmp=command_check2(str,x))){\
		str=tmp;\
		str=divide_word(str,math,kanji,cfont,cbfont,ciso,cfopt,tmppos,\
		tmpsize,ccolor,y,cfrac,coverline,cunderline,csqrtline);}
#define COMCHECK5(x,y,z,w,u) if (str!=(tmp=command_check2(str,x))){\
		str=tmp;\
		str=divide_word(str,math,kanji,cfont,cbfont,ciso,cfopt,tmppos,\
		tmpsize,ccolor,copt,y,z,w,u);}

	iw=0;
	while(*str!='\0'){
		switch(*str){
		case '{':
			ENDOFWORD;
			str++;
			str=divide_word(str,math,kanji,cfont,cbfont,ciso,cfopt,
				cpos,csize,ccolor,copt,cfrac,coverline,
							cunderline,csqrtline);
			break;	
		case '}':
			ENDOFWORD;
			iw=0;
			str++;
			return str;
			break;
		case '$':
			ENDOFWORD;
			str++;
			if(math){
				iw=0;
				return str;
			} else{
				str=divide_word(str,TRUE,kanji,ITALIC,cbfont,
					ciso,cfopt,cpos,csize,ccolor,copt,
					cfrac,coverline,cunderline,csqrtline);
			}
			break;
		case '^':
		case '_':
			ENDOFWORD;
			iw=0;
			switch(cpos){
			case NORMAL:
				if(*str=='^') tmppos=SUPERSC;
				else          tmppos=SUBSC;
				tmpsize=SCRIPTSIZE;
				break;
			case SUPERSC:
				if (*str=='^') tmppos=SUPERSUPERSC;
				else           tmppos=SUPERSUBSC;
				tmpsize=SCRIPTSCRIPTSIZE;
				break;
			case SUBSC:
				if (*str=='^') tmppos=SUBSUPERSC;
				else           tmppos=SUBSUBSC;
				tmpsize=SCRIPTSCRIPTSIZE;
				break;
			default:
				tmppos=cpos;
				tmpsize=SCRIPTSCRIPTSIZE;
				break;
			}
			switch(*(str+1)){
			case '{':
				str+=2;
				str=divide_word(str,math,kanji,cfont,cbfont,
					ciso,cfopt,tmppos,tmpsize,ccolor,copt,
					cfrac,coverline,cunderline,csqrtline);
				break;
			case '\\':
				if (*(str+2)=='\0') {str+=2;break;}
				if (*(str+2)<'0' || *(str+2)>'9'){
				str+=2;
				COMCHECK4("hat{",HAT);
				COMCHECK4("check{",CHECK);
				COMCHECK4("tilde{",TILDE);
				COMCHECK4("acute{",ACUTE);
				COMCHECK4("dot{",DOT);
				COMCHECK4("ddot{",DDOT);
				COMCHECK4("grave{",GRAVE);
				COMCHECK4("breve{",BREVE);
				COMCHECK4("bar{",BAR);
				COMCHECK4("vec{",VEC);
				COMCHECK5("overline{",cfrac,TRUE,cunderline,csqrtline);
				COMCHECK5("underline{",cfrac,coverline,TRUE,csqrtline);
				COMCHECK5("sqrt{",cfrac,coverline,cunderline,TRUE);
				} else {
					Style[nword].Body[iw++]=*(++str);
					Style[nword].Body[iw++]=*(++str);
					Style[nword].Body[iw++]=*(++str);
					Style[nword].Body[iw++]=*(++str);
					ENDOFWORD2(cfont);
					iw=0;
					str++;
				}
				break;
			default:
				if (*(str+1) & 0x80) 
					Style[nword].Body[iw++]=*(++str);
				else
				if (*(str+1)=='('|| *(str+1)==')')
					Style[nword].Body[iw++]='\\';
				Style[nword].Body[iw++]=*(++str);
				if (math && ((*str>='0' && *str<='9')
					|| *str=='('|| *str==')'|| *str=='-'))
					ENDOFWORD2(SYMBOL);
				else
					ENDOFWORD2(cfont);
				iw=0;
				str++;
				break;
			}
			break;
		case '\\':
			++str;
			if (*str<'0' || *str>'9') {
				COMCHECK("rm",ROMAN,&cfont);
				COMCHECK("it",ITALIC,&cfont);
				COMCHECK("tt",COURIER,&cfont);
				COMCHECK("sf",HELVETICA,&cfont);
				COMCHECK("sm",SYMBOL,&cfont);
				COMCHECK("nsm",NSYMBOL,&cfont);

				COMCHECK("bf",TRUE,&cbfont);
				COMCHECK("O",OBLIQUE,&cfopt);
				COMCHECK("V",VERTICAL,&cfopt);
				COMCHECK("iso",TRUE,&ciso);

				COMCHECK("tiny",TINY,&csize);
				COMCHECK("scriptsize",SCRIPTSIZE,&csize);
				COMCHECK("footnotesize",FOOTNOTESIZE,&csize);
				COMCHECK("small",SMALL,&csize);
				COMCHECK("normalsize",NORMALSIZE,&csize);
				COMCHECK("large",LARGE,&csize);
				COMCHECK("Large",LARGE2,&csize);
				COMCHECK("LARGE",LARGE3,&csize);
				COMCHECK("huge",HUGE,&csize);
				COMCHECK("Huge",HUGE2,&csize);
				COMCHECK("textstyle",NORMALSIZE,&csize);
				COMCHECK("scriptstyle",SCRIPTSIZE,&csize);
				COMCHECK("scriptscriptstyle",SCRIPTSCRIPTSIZE,&csize);

				str=get_size(str,"size=",&csize);

				COMCHECK("Black",BLACK,&ccolor);
				COMCHECK("Green",GREEN,&ccolor);
				COMCHECK("Blue",BLUE,&ccolor);
				COMCHECK("Red",RED,&ccolor);
				COMCHECK("Purple",PURPLE,&ccolor);
				COMCHECK("Skyblue",SKYBLUE,&ccolor);
				COMCHECK("Yellow",YELLOW,&ccolor);
				COMCHECK("Orange",ORANGE,&ccolor);
				COMCHECK("Gray",GRAY,&ccolor);
				COMCHECK("Grey",GRAY,&ccolor);

				if (str!=(tmp=command_check2(str,"mbox{"))){
					str=tmp;
					ENDOFWORD;
					str=divide_word(str,FALSE,kanji,DEFAULT,
						cbfont,ciso,cfopt,cpos,csize,
						ccolor,copt,cfrac,
						coverline,cunderline,csqrtline);
				}

				COMCHECK2("hat{",HAT);
				COMCHECK2("check{",CHECK);
				COMCHECK2("tilde{",TILDE);
				COMCHECK2("acute{",ACUTE);
				COMCHECK2("dot{",DOT);
				COMCHECK2("ddot{",DDOT);
				COMCHECK2("grave{",GRAVE);
				COMCHECK2("breve{",BREVE);
				COMCHECK2("bar{",BAR);
				COMCHECK2("vec{",VEC);

				COMCHECK3("frac{",BUNSI,coverline,cunderline,csqrtline);
				COMCHECK3("denom{",BUNBO,coverline,cunderline,csqrtline);
				COMCHECK3("overline{",cfrac,TRUE,cunderline,csqrtline);
				COMCHECK3("underline{",cfrac,coverline,TRUE,csqrtline);
				COMCHECK3("sqrt{",cfrac,coverline,cunderline,TRUE);

			} else {
				Style[nword].Body[iw++]='\\';
				Style[nword].Body[iw++]=*(str++);
				Style[nword].Body[iw++]=*(str++);
				Style[nword].Body[iw++]=*(str++);
			}
			break;
		case '(':
		case ')':
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			if (math) {ENDOFWORD;iw=0;}
			if (*str=='(' || *str==')')Style[nword].Body[iw++]='\\';
			Style[nword].Body[iw++]=*str;
			if (math) {ENDOFWORD3(SYMBOL);iw=0;}
			str++;
			break;
		case ' ':
			if(math || *(str+1)==' ') {str++;break;}
		default:
			if (*str & 0x80) {
				if (!kanji){
					ENDOFWORD;
					str=divide_word(str,math,TRUE,cfont,
						cbfont,ciso,cfopt,cpos,csize,
						ccolor,copt,cfrac,
						coverline,cunderline,csqrtline);
					break;
				} else if(*(str+1)!='\0' && !(*(str+1) & 0x80)){
					Style[nword].Body[iw++]=*str;
					ENDOFWORD;
					iw=0;
					return ++str;
				}
			}
			Style[nword].Body[iw++]=*str;
			str++;
			break;
		}
	}

	ENDOFWORD;
	nword--;

	return str;
}

#ifdef __STDC__
extern unsigned char *command_replace(unsigned char *);
extern unsigned char *brace_check(unsigned char *);
#else
extern unsigned char *command_replace();
extern unsigned char *brace_check();
#endif

#ifdef __STDC__
int psplus_split(unsigned char *str,struct style *Word)
#else
int psplus_split(str,Word)
unsigned char *str;
struct style *Word;
#endif
{
	int i;

	str=command_replace(str);
	str=brace_check(str);
	nword=0;
	divide_word(str,FALSE,FALSE,DEFAULT,FALSE,FALSE,FALSE,NORMAL,FALSE,
			BLACK,FALSE,FALSE,FALSE,FALSE,FALSE);

	for(i=0;i<=nword;i++){
		Word[i]=Style[i];
	}

	return nword;
}
