#!/usr/bin/env python
#
# Original author:      Maciej Stachowiak <mjs@eazel.com>
#
# Convert to python by: Johan Dahlin <jdahlin@telia.com>
#

# nautilus-sample-content-view.py - sample content view
# component. This component displays a simple label of the URI
# and demonstrates merging menu items & toolbar buttons. 
# It should be a good basis for writing out-of-proc content views.

import gtk
import bonobo
from gnome import nautilus

EXECUTABLE_NAME = 'nautilus-pysample-content-view'
VERSION = '0.1.0'

FACTORY_IID = 'OAFIID:nautilus_pysample_content_view_factory:3df6b028-be44-4a18-95c3-7720f50ca0c5'
VIEW_IID    = 'OAFIID:nautilus_pysample_content_view:45c746bc-7d64-4346-90d5-6410463b43ae'

DATA_DIR = '/opt/gnome/share'

class NautilusSampleContentView (nautilus.View):
    def __init__ (self, widget):
	nautilus.View.__init__ (self, widget)
	self.label = widget
	
	self.connect ('load_location', self.load_location_cb)
	
	# Get notified when our bonobo control is activated so we can
	# merge menu & toolbar items into the shell's UI.

	control = self.get_bonobo_control ()
	control.connect ('activate', self.sample_merge_bonobo_items_cb)

    def load_location_cb (self, view, location):

	# It's mandatory to send an underway message once the
	# component starts loading, otherwise nautilus will assume it
	# failed. In a real component, this will probably happen in
	# some sort of callback from whatever loading mechanism it is
	# using to load the data; this component loads no data, so it
	# gives the progress update here.
								      
	self.report_load_underway ()
	
	# Do the actual load
	self.load_location (location)
	
	# It's mandatory to call report_load_complete once the
	# component is done loading successfully, or
	# report_load_failed if it completes unsuccessfully. In a
	# real component, this will probably happen in some sort of
	# callback from whatever loading mechanism it is using to
	# load the data; this component loads no data, so it gives
	# the progress update here.

	self.report_load_complete ()
	
    def load_location (self, location):
	self.location = location
	label_text = '%s\n\nThis is a sample Nautilus content view component' % location
	self.label.set_text (label_text)
	
    def sample_merge_bonobo_items_cb (self, control, state):
	verbs = [
	    ('Sample Menu Item', self.bonobo_sample_callback),
            ('Sample Dock Item', self.bonobo_sample_callback)]

	if state:
	    uic = self.set_up_ui (DATA_DIR,
	                          'nautilus-sample-content-view-ui.xml',
				  'nautilus-sample-content-view')
	    uic.add_verb_list (verbs)
	    
    def bonobo_sample_callback (self, uic, verb):
	if verb == 'Sample Menu Item':
	    label_text = '%s\n\nYou selected the Sample menu item.'
	else:
	    label_text = '%s\n\nYou selected the Sample toolbar button.'
	
	self.label.set_text (label_text % self.location)
    
def create_function (iid):
    label = gtk.Label ('(none)')
    label.show ()

    return NautilusSampleContentView (label)

bonobo.activate ()

nautilus.view_standard_main (EXECUTABLE_NAME,
                             VERSION,
			     FACTORY_IID,
			     VIEW_IID,
			     create_function)
