import { getRect } from 'css-box-model';
// Simplified version of RBD's droppable: minimum required fields just to get it working with cursor-based scolling.
export var getScrollable = function getScrollable(_ref) {
  var closestScrollable = _ref.closestScrollable;
  var rect = closestScrollable.getBoundingClientRect();
  var scrollPosition = {
    x: closestScrollable.scrollLeft,
    y: closestScrollable.scrollTop
  };
  return {
    container: getRect(rect),
    scroll: {
      current: scrollPosition,
      max: {
        x: closestScrollable.scrollWidth - closestScrollable.clientWidth,
        y: closestScrollable.scrollHeight - closestScrollable.clientHeight
      }
    }
  };
};