import { migrateEvaluationDetails } from '../utils';
// Reference: https://github.com/statsig-io/js-lite/blob/main/src/DynamicConfig.ts
export class DynamicConfig {
  static fromExperiment(experiment) {
    var _experiment$__evaluat, _experiment$groupName;
    const config = new DynamicConfig(experiment.name, experiment.value, experiment.ruleID, migrateEvaluationDetails(experiment.details), (_experiment$__evaluat = experiment.__evaluation) === null || _experiment$__evaluat === void 0 ? void 0 : _experiment$__evaluat.secondary_exposures, (_experiment$groupName = experiment.groupName) !== null && _experiment$groupName !== void 0 ? _experiment$groupName : undefined);
    config.experiment = experiment;
    return config;
  }
  constructor(configName, configValue, ruleID, evaluationDetails, secondaryExposures = [], allocatedExperimentName = '', onDefaultValueFallback = null) {
    this.value = configValue;
    this._name = configName;
    this._ruleID = ruleID;
    this._secondaryExposures = secondaryExposures;
    this._allocatedExperimentName = allocatedExperimentName;
    this._evaluationDetails = evaluationDetails;
    this._onDefaultValueFallback = onDefaultValueFallback;
  }
  get(key, defaultValue, typeGuard) {
    var _this$_onDefaultValue2;
    const val = this.getValue(key, defaultValue);
    if (val == null) {
      return defaultValue;
    }
    const expectedType = Array.isArray(defaultValue) ? 'array' : typeof defaultValue;
    const actualType = Array.isArray(val) ? 'array' : typeof val;
    if (typeGuard) {
      var _this$_onDefaultValue;
      if (typeGuard(val)) {
        this.fireExposure(key);
        return val;
      }
      (_this$_onDefaultValue = this._onDefaultValueFallback) === null || _this$_onDefaultValue === void 0 ? void 0 : _this$_onDefaultValue.call(this, this, key, expectedType, actualType);
      return defaultValue;
    }
    if (defaultValue == null || expectedType === actualType) {
      this.fireExposure(key);
      return val;
    }
    (_this$_onDefaultValue2 = this._onDefaultValueFallback) === null || _this$_onDefaultValue2 === void 0 ? void 0 : _this$_onDefaultValue2.call(this, this, key, expectedType, actualType);
    return defaultValue;
  }
  getValue(key, defaultValue) {
    if (key == null) {
      return this.value;
    }
    if (defaultValue == null) {
      defaultValue = null;
    }
    if (this.value[key] == null) {
      return defaultValue;
    }
    this.fireExposure(key);
    return this.value[key];
  }
  fireExposure(key) {
    // Call the wrapped experiment's get method to fire exposure
    if (this.experiment) {
      this.experiment.get(key);
    }
  }
}