/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.OkCancelDialog;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.std.JSAddDbInstrumentsProgressDlg;
import org.jsampler.view.std.JSDbDirectoryChooser;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.Parser;

public class JSAddDbInstrumentsFromFileDlg
extends OkCancelDialog {
    private final JRadioButton rbAllInstruments = new JRadioButton(StdI18n.i18n.getLabel("JSAddDbInstrumentsFromFileDlg.rbAllInstruments"));
    private final JRadioButton rbIndex = new JRadioButton(StdI18n.i18n.getLabel("JSAddDbInstrumentsFromFileDlg.rbIndex"));
    private final JComboBox cbSource = StdUtils.createPathComboBox();
    private final JSpinner spinnerIndex = new JSpinner(new SpinnerNumberModel(0, 0, 500, 1));
    private JButton btnBrowse;
    private final JComboBox cbDest = StdUtils.createPathComboBox();
    private JButton btnBrowseDb;
    private final Handler eventHandler = new Handler();

    public JSAddDbInstrumentsFromFileDlg(Frame frame, String string, Icon icon) {
        super(frame, StdI18n.i18n.getLabel("JSAddDbInstrumentsFromFileDlg.title"));
        this.initAddDbInstrumentsFromFileDlg(string, icon);
    }

    public JSAddDbInstrumentsFromFileDlg(Dialog dialog, String string, Icon icon) {
        super(dialog, StdI18n.i18n.getLabel("JSAddDbInstrumentsFromFileDlg.title"));
        this.initAddDbInstrumentsFromFileDlg(string, icon);
    }

    private void initAddDbInstrumentsFromFileDlg(String string, Icon icon) {
        String[] stringArray;
        this.btnBrowse = new JButton(icon);
        this.btnBrowseDb = new JButton(icon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.cbSource);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        String string2 = StdI18n.i18n.getButtonLabel("browse");
        this.btnBrowse.setMargin(new Insets(0, 0, 0, 0));
        this.btnBrowse.setToolTipText(string2);
        jPanel2.add(this.btnBrowse);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel2.getPreferredSize().height));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.rbAllInstruments);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.rbIndex);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel2.add(this.spinnerIndex);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel2.getPreferredSize().height));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        string2 = StdI18n.i18n.getLabel("JSAddDbInstrumentsFromFileDlg.source");
        jPanel.setBorder(BorderFactory.createTitledBorder(string2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 6)));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.cbDest);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        string2 = StdI18n.i18n.getButtonLabel("browse");
        this.btnBrowseDb.setMargin(new Insets(0, 0, 0, 0));
        this.btnBrowseDb.setToolTipText(string2);
        jPanel2.add(this.btnBrowseDb);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel2.getPreferredSize().height));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        string2 = StdI18n.i18n.getLabel("JSAddDbInstrumentsFromFileDlg.dest");
        jPanel.setBorder(BorderFactory.createTitledBorder(string2));
        jPanel3.add(jPanel);
        Dimension dimension = jPanel3.getPreferredSize();
        jPanel3.setPreferredSize(new Dimension(dimension.width > 300 ? dimension.width : 300, dimension.height));
        this.setMainPane(jPanel3);
        this.setMinimumSize(this.getPreferredSize());
        this.setResizable(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbAllInstruments);
        buttonGroup.add(this.rbIndex);
        this.rbAllInstruments.doClick(0);
        this.btnOk.setEnabled(false);
        this.spinnerIndex.setEnabled(false);
        for (String string3 : stringArray = this.preferences().getStringListProperty("recentInstrumentFiles")) {
            this.cbSource.addItem(string3);
        }
        this.cbSource.setSelectedItem(null);
        this.cbSource.setPreferredSize(new Dimension(200, this.cbSource.getPreferredSize().height));
        this.cbSource.addActionListener(this.getHandler());
        for (String string3 : stringArray = this.preferences().getStringListProperty("recentDbDirectories")) {
            this.cbDest.addItem(string3);
        }
        this.cbDest.setSelectedItem(string);
        this.cbDest.setPreferredSize(new Dimension(200, this.cbDest.getPreferredSize().height));
        this.cbDest.addActionListener(this.getHandler());
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSAddDbInstrumentsFromFileDlg.this.onBrowse();
            }
        });
        this.rbAllInstruments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSAddDbInstrumentsFromFileDlg.this.spinnerIndex.setEnabled(JSAddDbInstrumentsFromFileDlg.this.rbIndex.isSelected());
            }
        });
        this.rbIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSAddDbInstrumentsFromFileDlg.this.spinnerIndex.setEnabled(JSAddDbInstrumentsFromFileDlg.this.rbIndex.isSelected());
            }
        });
        this.btnBrowseDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSAddDbInstrumentsFromFileDlg.this.onBrowseDb();
            }
        });
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private void onBrowse() {
        File file = StdUtils.showOpenInstrumentFileChooser(this);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.replace('\\', '/');
        }
        string = Parser.toEscapedString(string);
        this.cbSource.setSelectedItem(string);
    }

    private void onBrowseDb() {
        JSDbDirectoryChooser jSDbDirectoryChooser = new JSDbDirectoryChooser(this);
        Object object = this.cbDest.getSelectedItem();
        if (object != null && object.toString().length() > 0) {
            jSDbDirectoryChooser.setSelectedDirectory(object.toString());
        }
        jSDbDirectoryChooser.setVisible(true);
        if (jSDbDirectoryChooser.isCancelled()) {
            return;
        }
        this.cbDest.setSelectedItem(jSDbDirectoryChooser.getSelectedDirectory());
    }

    private void updateState() {
        Object object = this.cbSource.getSelectedItem();
        Object object2 = this.cbDest.getSelectedItem();
        boolean bl = object != null && object.toString().length() > 0;
        bl = bl && object2 != null && object2.toString().length() > 0;
        this.btnOk.setEnabled(bl);
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.btnOk.setEnabled(false);
        String string = this.cbDest.getSelectedItem().toString();
        String string2 = this.cbSource.getSelectedItem().toString();
        int n = -1;
        if (this.rbIndex.isSelected()) {
            n = Integer.parseInt(this.spinnerIndex.getValue().toString());
        }
        final InstrumentsDb.AddInstrumentsFromFile addInstrumentsFromFile = new InstrumentsDb.AddInstrumentsFromFile(string, string2, n);
        addInstrumentsFromFile.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                JSAddDbInstrumentsFromFileDlg.this.updateState();
                if (addInstrumentsFromFile.doneWithErrors()) {
                    return;
                }
                JSAddDbInstrumentsFromFileDlg.this.showProgress((Integer)addInstrumentsFromFile.getResult());
            }
        });
        CC.getTaskQueue().add(addInstrumentsFromFile);
        StdUtils.updateRecentElements("recentInstrumentFiles", string2);
        StdUtils.updateRecentElements("recentDbDirectories", string);
    }

    private void showProgress(int n) {
        final JSAddDbInstrumentsProgressDlg jSAddDbInstrumentsProgressDlg = new JSAddDbInstrumentsProgressDlg((Dialog)this, n);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jSAddDbInstrumentsProgressDlg.setVisible(true);
                jSAddDbInstrumentsProgressDlg.updateStatus();
            }
        });
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener,
    ActionListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSAddDbInstrumentsFromFileDlg.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSAddDbInstrumentsFromFileDlg.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSAddDbInstrumentsFromFileDlg.this.updateState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSAddDbInstrumentsFromFileDlg.this.updateState();
        }
    }
}

