/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Reduce the size of an image by an integer factor in each dimension.


ShrinkImageFilter reduces the size of an image by an integer factor in each dimension.
The algorithm implemented is a simple subsample. The output image size
in each dimension is given by:

outputSize[j] = max( std::floor(inputSize[j]/shrinkFactor[j]), 1 );

NOTE: The physical centers of the input and output will be the same.
Because of this, the Origin of the output may not be the same as the
Origin of the input. Since this filter produces an image which is a
different resolution, origin and with different pixel spacing than its
input image, it needs to override several of the methods defined in ProcessObject in order to properly manage the pipeline execution model. In
particular, this filter overrides ProcessObject::GenerateInputRequestedRegion() and ProcessObject::GenerateOutputInformation() .

This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
See:
 itk::simple::Shrink for the procedural interface

 itk::ShrinkImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkShrinkImageFilter.h
*/
public class ShrinkImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ShrinkImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ShrinkImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ShrinkImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ShrinkImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ShrinkImageFilter::~ShrinkImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ShrinkImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ShrinkImageFilter::ShrinkImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ShrinkImageFilter() {
    this(SimpleITKJNI.new_ShrinkImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ShrinkImageFilter::SetShrinkFactor(unsigned int s)

Custom public declarations

*/
public  void setShrinkFactor(long s) {
    SimpleITKJNI.ShrinkImageFilter_setShrinkFactor(swigCPtr, this, s);
  }

  /**
Self&amp; itk::simple::ShrinkImageFilter::SetShrinkFactors(std::vector&lt; unsigned int &gt; ShrinkFactors)

Set the shrink factors. Values are clamped to a minimum value of 1.
Default is 1 for all dimensions.

*/
public  void setShrinkFactors(VectorUInt32 ShrinkFactors) {
    SimpleITKJNI.ShrinkImageFilter_setShrinkFactors(swigCPtr, this, VectorUInt32.getCPtr(ShrinkFactors), ShrinkFactors);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ShrinkImageFilter::GetShrinkFactors() const

Get the shrink factors.

*/
public  VectorUInt32 getShrinkFactors() {
    return new VectorUInt32(SimpleITKJNI.ShrinkImageFilter_getShrinkFactors(swigCPtr, this), true);
  }

  /**
std::string itk::simple::ShrinkImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ShrinkImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ShrinkImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ShrinkImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ShrinkImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ShrinkImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
