/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Threshold an image using the Otsu Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the OtsuThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare

Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/efycla


See:
 HistogramThresholdImageFilter

 itk::simple::OtsuThreshold for the procedural interface

 itk::OtsuThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkOtsuThresholdImageFilter.h
*/
public class OtsuThresholdImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected OtsuThresholdImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.OtsuThresholdImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(OtsuThresholdImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(OtsuThresholdImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::OtsuThresholdImageFilter::~OtsuThresholdImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_OtsuThresholdImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::OtsuThresholdImageFilter::OtsuThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  OtsuThresholdImageFilter() {
    this(SimpleITKJNI.new_OtsuThresholdImageFilter(), true);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the "inside" pixel value. The default value NumericTraits&lt;OutputPixelType&gt;::max()

*/
public  void setInsideValue(short InsideValue) {
    SimpleITKJNI.OtsuThresholdImageFilter_setInsideValue(swigCPtr, this, InsideValue);
  }

  /**
uint8_t itk::simple::OtsuThresholdImageFilter::GetInsideValue() const

Get the "inside" pixel value.

*/
public  short getInsideValue() {
    return SimpleITKJNI.OtsuThresholdImageFilter_getInsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the "outside" pixel value. The default value NumericTraits&lt;OutputPixelType&gt;::Zero.

*/
public  void setOutsideValue(short OutsideValue) {
    SimpleITKJNI.OtsuThresholdImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
uint8_t itk::simple::OtsuThresholdImageFilter::GetOutsideValue() const

Get the "outside" pixel value.

*/
public  short getOutsideValue() {
    return SimpleITKJNI.OtsuThresholdImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins. Defaults is 128.

*/
public  void setNumberOfHistogramBins(long NumberOfHistogramBins) {
    SimpleITKJNI.OtsuThresholdImageFilter_setNumberOfHistogramBins(swigCPtr, this, NumberOfHistogramBins);
  }

  /**
uint32_t itk::simple::OtsuThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public  long getNumberOfHistogramBins() {
    return SimpleITKJNI.OtsuThresholdImageFilter_getNumberOfHistogramBins(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public  void setMaskOutput(boolean MaskOutput) {
    SimpleITKJNI.OtsuThresholdImageFilter_setMaskOutput(swigCPtr, this, MaskOutput);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public  void maskOutputOn() {
    SimpleITKJNI.OtsuThresholdImageFilter_maskOutputOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::MaskOutputOff()
*/
public  void maskOutputOff() {
    SimpleITKJNI.OtsuThresholdImageFilter_maskOutputOff(swigCPtr, this);
  }

  /**
bool itk::simple::OtsuThresholdImageFilter::GetMaskOutput() const
*/
public  boolean getMaskOutput() {
    return SimpleITKJNI.OtsuThresholdImageFilter_getMaskOutput(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public  void setMaskValue(short MaskValue) {
    SimpleITKJNI.OtsuThresholdImageFilter_setMaskValue(swigCPtr, this, MaskValue);
  }

  /**
uint8_t itk::simple::OtsuThresholdImageFilter::GetMaskValue() const
*/
public  short getMaskValue() {
    return SimpleITKJNI.OtsuThresholdImageFilter_getMaskValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::SetReturnBinMidpoint(bool ReturnBinMidpoint)

Should the threshold value be mid-point of the bin or the maximum?
Default is to return bin maximum.

*/
public  void setReturnBinMidpoint(boolean ReturnBinMidpoint) {
    SimpleITKJNI.OtsuThresholdImageFilter_setReturnBinMidpoint(swigCPtr, this, ReturnBinMidpoint);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::ReturnBinMidpointOn()

Set the value of ReturnBinMidpoint to true or false respectfully.

*/
public  void returnBinMidpointOn() {
    SimpleITKJNI.OtsuThresholdImageFilter_returnBinMidpointOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OtsuThresholdImageFilter::ReturnBinMidpointOff()
*/
public  void returnBinMidpointOff() {
    SimpleITKJNI.OtsuThresholdImageFilter_returnBinMidpointOff(swigCPtr, this);
  }

  /**
bool itk::simple::OtsuThresholdImageFilter::GetReturnBinMidpoint() const

Should the threshold value be mid-point of the bin or the maximum?
Default is to return bin maximum.

*/
public  boolean getReturnBinMidpoint() {
    return SimpleITKJNI.OtsuThresholdImageFilter_getReturnBinMidpoint(swigCPtr, this);
  }

  /**
double itk::simple::OtsuThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getThreshold() {
    return SimpleITKJNI.OtsuThresholdImageFilter_getThreshold(swigCPtr, this);
  }

  /**
std::string itk::simple::OtsuThresholdImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.OtsuThresholdImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::OtsuThresholdImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.OtsuThresholdImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::OtsuThresholdImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.OtsuThresholdImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  /**
Image itk::simple::OtsuThresholdImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image) {
    return new Image(SimpleITKJNI.OtsuThresholdImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image), image), true);
  }

}
