/* subject.c generated by valac 0.56.17, the Vala compiler
 * generated from subject.vala, do not modify */

/* subject.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_SUBJECT_0_PROPERTY,
	ZEITGEIST_SUBJECT_URI_PROPERTY,
	ZEITGEIST_SUBJECT_ORIGIN_PROPERTY,
	ZEITGEIST_SUBJECT_TEXT_PROPERTY,
	ZEITGEIST_SUBJECT_STORAGE_PROPERTY,
	ZEITGEIST_SUBJECT_CURRENT_URI_PROPERTY,
	ZEITGEIST_SUBJECT_CURRENT_ORIGIN_PROPERTY,
	ZEITGEIST_SUBJECT_MIMETYPE_PROPERTY,
	ZEITGEIST_SUBJECT_INTERPRETATION_PROPERTY,
	ZEITGEIST_SUBJECT_MANIFESTATION_PROPERTY,
	ZEITGEIST_SUBJECT_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_subject_properties[ZEITGEIST_SUBJECT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_chunk_free0(var) ((var == NULL) ? NULL : (var = (g_string_chunk_free (var), NULL)))

struct _ZeitgeistSubjectPrivate {
	gchar* _uri;
	gchar* _origin;
	gchar* _text;
	gchar* _storage;
	gchar* _current_uri;
	gchar* _current_origin;
	const gchar* _mimetype;
	const gchar* _interpretation;
	const gchar* _manifestation;
};

static gint ZeitgeistSubject_private_offset;
static gpointer zeitgeist_subject_parent_class = NULL;
static GStringChunk* zeitgeist_subject_url_store;
static GStringChunk* zeitgeist_subject_url_store = NULL;

VALA_EXTERN void zeitgeist_utils_assert_sig (gboolean condition,
                                 const gchar* error_message,
                                 GError** error);
VALA_EXTERN gchar* zeitgeist_next_string_or_null (GVariantIter* iter);
VALA_EXTERN gboolean zeitgeist_check_field_match (const gchar* property,
                                      const gchar* template_property,
                                      gboolean is_symbol,
                                      gboolean can_wildcard);
static void zeitgeist_subject_finalize (GObject * obj);
static GType zeitgeist_subject_get_type_once (void);
static void _vala_zeitgeist_subject_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_zeitgeist_subject_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
zeitgeist_subject_get_instance_private (ZeitgeistSubject* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistSubject_private_offset);
}

/** 
     * Create a new Subject structure with predefined data
     * @param uri The URI or URL of the subject
     * @param interpretation The interpretation type of the subject.
     * @param manifestation The manifestation type of the subject.
     * @param mimetype The mimetype of the subject. Eg. <emphasis>text/plain</emphasis>
     * @param origin The origin of the subject.
     * @param text A small textual representation of the subject suitable for display
     * @param storage String identifier for the storage medium the subject is on.
     *
     * @return A newly create {@link Subject} instance. The returned subject will
     *          have a floating reference which will be consumed if you pass the
     *          event to any of the methods provided by this library (like
     *          adding it to an event).
     */
ZeitgeistSubject*
zeitgeist_subject_construct_full (GType object_type,
                                  const gchar* uri,
                                  const gchar* interpretation,
                                  const gchar* manifestation,
                                  const gchar* mimetype,
                                  const gchar* origin,
                                  const gchar* text,
                                  const gchar* storage)
{
	ZeitgeistSubject * self = NULL;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	zeitgeist_subject_set_uri (self, uri);
	zeitgeist_subject_set_interpretation (self, interpretation);
	zeitgeist_subject_set_manifestation (self, manifestation);
	zeitgeist_subject_set_mimetype (self, mimetype);
	zeitgeist_subject_set_origin (self, origin);
	zeitgeist_subject_set_text (self, text);
	zeitgeist_subject_set_storage (self, storage);
	return self;
}

ZeitgeistSubject*
zeitgeist_subject_new_full (const gchar* uri,
                            const gchar* interpretation,
                            const gchar* manifestation,
                            const gchar* mimetype,
                            const gchar* origin,
                            const gchar* text,
                            const gchar* storage)
{
	return zeitgeist_subject_construct_full (ZEITGEIST_TYPE_SUBJECT, uri, interpretation, manifestation, mimetype, origin, text, storage);
}

/** 
     * Create a new Subject structure to describe a move event
     *
     * @param source_uri The URI or URL of the subject
     * @param source_origin The URI or URL of the subject
     * @param destination_uri The URI or URL of the subject
     * @param destination_origin The URI or URL of the subject
     * @param interpretation The interpretation type of the subject.
     * @param manifestation The manifestation type of the subject.
     * @param mimetype The mimetype of the subject. Eg. <emphasis>text/plain</emphasis>
     * @param text A small textual representation of the subject suitable for display
     * @param storage String identifier for the storage medium the subject is on.
     *
     * @return A newly create {@link Subject} instance. The returned subject will
     *          have a floating reference which will be consumed if you pass the
     *          event to any of the methods provided by this library (like
     *          adding it to an event).
     */
ZeitgeistSubject*
zeitgeist_subject_construct_move_event (GType object_type,
                                        const gchar* source_uri,
                                        const gchar* source_origin,
                                        const gchar* destination_uri,
                                        const gchar* destination_origin,
                                        const gchar* interpretation,
                                        const gchar* manifestation,
                                        const gchar* mimetype,
                                        const gchar* text,
                                        const gchar* storage)
{
	ZeitgeistSubject * self = NULL;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	zeitgeist_subject_set_uri (self, source_uri);
	zeitgeist_subject_set_origin (self, source_origin);
	zeitgeist_subject_set_current_uri (self, destination_uri);
	zeitgeist_subject_set_current_origin (self, destination_origin);
	zeitgeist_subject_set_interpretation (self, interpretation);
	zeitgeist_subject_set_manifestation (self, manifestation);
	zeitgeist_subject_set_mimetype (self, mimetype);
	zeitgeist_subject_set_text (self, text);
	zeitgeist_subject_set_storage (self, storage);
	return self;
}

ZeitgeistSubject*
zeitgeist_subject_new_move_event (const gchar* source_uri,
                                  const gchar* source_origin,
                                  const gchar* destination_uri,
                                  const gchar* destination_origin,
                                  const gchar* interpretation,
                                  const gchar* manifestation,
                                  const gchar* mimetype,
                                  const gchar* text,
                                  const gchar* storage)
{
	return zeitgeist_subject_construct_move_event (ZEITGEIST_TYPE_SUBJECT, source_uri, source_origin, destination_uri, destination_origin, interpretation, manifestation, mimetype, text, storage);
}

/** 
     * Create a new Subject structure from predefined {@link GLib.Variant} data
     *
     * @param subject_variant A {@link GLib.Variant} decscribing the subject data.
     *
     * @return A newly create {@link Subject} instance. The returned subject will
     *          have a floating reference which will be consumed if you pass the
     *          event to any of the methods provided by this library (like
     *          adding it to an event).
     */
ZeitgeistSubject*
zeitgeist_subject_construct_from_variant (GType object_type,
                                          GVariant* subject_variant,
                                          GError** error)
{
	ZeitgeistSubject * self = NULL;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp0_;
	gsize subject_props = 0UL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (subject_variant != NULL, NULL);
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	_tmp0_ = g_variant_iter_new (subject_variant);
	iter = _tmp0_;
	subject_props = g_variant_iter_n_children (iter);
	zeitgeist_utils_assert_sig (subject_props >= ((gsize) 7), "Missing subject information", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = zeitgeist_next_string_or_null (iter);
	_tmp2_ = _tmp1_;
	zeitgeist_subject_set_uri (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = zeitgeist_next_string_or_null (iter);
	_tmp4_ = _tmp3_;
	zeitgeist_subject_set_interpretation (self, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = zeitgeist_next_string_or_null (iter);
	_tmp6_ = _tmp5_;
	zeitgeist_subject_set_manifestation (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = zeitgeist_next_string_or_null (iter);
	_tmp8_ = _tmp7_;
	zeitgeist_subject_set_origin (self, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = zeitgeist_next_string_or_null (iter);
	_tmp10_ = _tmp9_;
	zeitgeist_subject_set_mimetype (self, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = zeitgeist_next_string_or_null (iter);
	_tmp12_ = _tmp11_;
	zeitgeist_subject_set_text (self, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = zeitgeist_next_string_or_null (iter);
	_tmp14_ = _tmp13_;
	zeitgeist_subject_set_storage (self, _tmp14_);
	_g_free0 (_tmp14_);
	if (subject_props >= ((gsize) 8)) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = zeitgeist_next_string_or_null (iter);
		_tmp16_ = _tmp15_;
		zeitgeist_subject_set_current_uri (self, _tmp16_);
		_g_free0 (_tmp16_);
	}
	if (subject_props >= ((gsize) 9)) {
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = zeitgeist_next_string_or_null (iter);
		_tmp18_ = _tmp17_;
		zeitgeist_subject_set_current_origin (self, _tmp18_);
		_g_free0 (_tmp18_);
	}
	_g_variant_iter_free0 (iter);
	return self;
}

ZeitgeistSubject*
zeitgeist_subject_new_from_variant (GVariant* subject_variant,
                                    GError** error)
{
	return zeitgeist_subject_construct_from_variant (ZEITGEIST_TYPE_SUBJECT, subject_variant, error);
}

GVariant*
zeitgeist_subject_to_variant (ZeitgeistSubject* self)
{
	gchar* ptr_arr[9] = {0};
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_;
	GVariant* _tmp33_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_uri;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_uri;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	ptr_arr[0] = _tmp0_;
	_tmp4_ = zeitgeist_subject_get_interpretation (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = zeitgeist_subject_get_interpretation (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = "";
	}
	ptr_arr[1] = _tmp3_;
	_tmp9_ = zeitgeist_subject_get_manifestation (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = zeitgeist_subject_get_manifestation (self);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = "";
	}
	ptr_arr[2] = _tmp8_;
	_tmp14_ = self->priv->_origin;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		_tmp15_ = self->priv->_origin;
		_tmp13_ = _tmp15_;
	} else {
		_tmp13_ = "";
	}
	ptr_arr[3] = _tmp13_;
	_tmp17_ = zeitgeist_subject_get_mimetype (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = zeitgeist_subject_get_mimetype (self);
		_tmp20_ = _tmp19_;
		_tmp16_ = _tmp20_;
	} else {
		_tmp16_ = "";
	}
	ptr_arr[4] = _tmp16_;
	_tmp22_ = self->priv->_text;
	if (_tmp22_ != NULL) {
		const gchar* _tmp23_;
		_tmp23_ = self->priv->_text;
		_tmp21_ = _tmp23_;
	} else {
		_tmp21_ = "";
	}
	ptr_arr[5] = _tmp21_;
	_tmp25_ = self->priv->_storage;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		_tmp26_ = self->priv->_storage;
		_tmp24_ = _tmp26_;
	} else {
		_tmp24_ = "";
	}
	ptr_arr[6] = _tmp24_;
	_tmp28_ = self->priv->_current_uri;
	if (_tmp28_ != NULL) {
		const gchar* _tmp29_;
		_tmp29_ = self->priv->_current_uri;
		_tmp27_ = _tmp29_;
	} else {
		_tmp27_ = "";
	}
	ptr_arr[7] = _tmp27_;
	_tmp31_ = self->priv->_current_origin;
	if (_tmp31_ != NULL) {
		const gchar* _tmp32_;
		_tmp32_ = self->priv->_current_origin;
		_tmp30_ = _tmp32_;
	} else {
		_tmp30_ = "";
	}
	ptr_arr[8] = _tmp30_;
	_tmp33_ = g_variant_new_strv ((gchar**) ptr_arr, (9 * sizeof (gchar*)) / sizeof (gchar*));
	g_variant_ref_sink (_tmp33_);
	result = _tmp33_;
	return result;
}

/**
     * @return true if this Subject matches *subject_template*. Empty
     * fields in the template are treated as wildcards.
     * Interpretations and manifestations are also matched if they are
     * children of the types specified in `subject_template`.
     * @param template_subject a {@link Subject}
    */
gboolean
zeitgeist_subject_matches_template (ZeitgeistSubject* self,
                                    ZeitgeistSubject* template_subject)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (template_subject != NULL, FALSE);
	_tmp0_ = self->priv->_uri;
	_tmp1_ = template_subject->priv->_uri;
	if (!zeitgeist_check_field_match (_tmp0_, _tmp1_, FALSE, TRUE)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_current_uri;
	_tmp3_ = template_subject->priv->_current_uri;
	if (!zeitgeist_check_field_match (_tmp2_, _tmp3_, FALSE, TRUE)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = zeitgeist_subject_get_interpretation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = zeitgeist_subject_get_interpretation (template_subject);
	_tmp7_ = _tmp6_;
	if (!zeitgeist_check_field_match (_tmp5_, _tmp7_, TRUE, FALSE)) {
		result = FALSE;
		return result;
	}
	_tmp8_ = zeitgeist_subject_get_manifestation (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = zeitgeist_subject_get_manifestation (template_subject);
	_tmp11_ = _tmp10_;
	if (!zeitgeist_check_field_match (_tmp9_, _tmp11_, TRUE, FALSE)) {
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->_origin;
	_tmp13_ = template_subject->priv->_origin;
	if (!zeitgeist_check_field_match (_tmp12_, _tmp13_, FALSE, TRUE)) {
		result = FALSE;
		return result;
	}
	_tmp14_ = self->priv->_current_origin;
	_tmp15_ = template_subject->priv->_current_origin;
	if (!zeitgeist_check_field_match (_tmp14_, _tmp15_, FALSE, TRUE)) {
		result = FALSE;
		return result;
	}
	_tmp16_ = zeitgeist_subject_get_mimetype (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = zeitgeist_subject_get_mimetype (template_subject);
	_tmp19_ = _tmp18_;
	if (!zeitgeist_check_field_match (_tmp17_, _tmp19_, FALSE, TRUE)) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

ZeitgeistSubject*
zeitgeist_subject_construct (GType object_type)
{
	ZeitgeistSubject * self = NULL;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	return self;
}

ZeitgeistSubject*
zeitgeist_subject_new (void)
{
	return zeitgeist_subject_construct (ZEITGEIST_TYPE_SUBJECT);
}

const gchar*
zeitgeist_subject_get_uri (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_uri (ZeitgeistSubject* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_subject_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_URI_PROPERTY]);
	}
}

const gchar*
zeitgeist_subject_get_origin (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_origin;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_origin (ZeitgeistSubject* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_subject_get_origin (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_origin);
		self->priv->_origin = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_ORIGIN_PROPERTY]);
	}
}

const gchar*
zeitgeist_subject_get_text (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_text (ZeitgeistSubject* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_subject_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_TEXT_PROPERTY]);
	}
}

const gchar*
zeitgeist_subject_get_storage (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_storage;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_storage (ZeitgeistSubject* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_subject_get_storage (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_storage);
		self->priv->_storage = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_STORAGE_PROPERTY]);
	}
}

const gchar*
zeitgeist_subject_get_current_uri (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_uri;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_current_uri (ZeitgeistSubject* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_subject_get_current_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_current_uri);
		self->priv->_current_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_CURRENT_URI_PROPERTY]);
	}
}

const gchar*
zeitgeist_subject_get_current_origin (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_origin;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_current_origin (ZeitgeistSubject* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_subject_get_current_origin (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_current_origin);
		self->priv->_current_origin = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_CURRENT_ORIGIN_PROPERTY]);
	}
}

const gchar*
zeitgeist_subject_get_mimetype (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mimetype;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_mimetype (ZeitgeistSubject* self,
                                const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		GStringChunk* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = zeitgeist_subject_url_store;
		_tmp2_ = g_string_chunk_insert_const (_tmp1_, value);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_mimetype = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_MIMETYPE_PROPERTY]);
}

const gchar*
zeitgeist_subject_get_interpretation (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interpretation;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_interpretation (ZeitgeistSubject* self,
                                      const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		GStringChunk* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = zeitgeist_subject_url_store;
		_tmp2_ = g_string_chunk_insert_const (_tmp1_, value);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_interpretation = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_INTERPRETATION_PROPERTY]);
}

const gchar*
zeitgeist_subject_get_manifestation (ZeitgeistSubject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manifestation;
	result = _tmp0_;
	return result;
}

void
zeitgeist_subject_set_manifestation (ZeitgeistSubject* self,
                                     const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		GStringChunk* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = zeitgeist_subject_url_store;
		_tmp2_ = g_string_chunk_insert_const (_tmp1_, value);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_manifestation = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_MANIFESTATION_PROPERTY]);
}

static void
zeitgeist_subject_class_init (ZeitgeistSubjectClass * klass,
                              gpointer klass_data)
{
	GStringChunk* _tmp0_;
	zeitgeist_subject_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistSubject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_subject_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_subject_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_subject_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_URI_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_ORIGIN_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_ORIGIN_PROPERTY] = g_param_spec_string ("origin", "origin", "origin", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_TEXT_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_STORAGE_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_STORAGE_PROPERTY] = g_param_spec_string ("storage", "storage", "storage", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_CURRENT_URI_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_CURRENT_URI_PROPERTY] = g_param_spec_string ("current-uri", "current-uri", "current-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_CURRENT_ORIGIN_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_CURRENT_ORIGIN_PROPERTY] = g_param_spec_string ("current-origin", "current-origin", "current-origin", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_MIMETYPE_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_MIMETYPE_PROPERTY] = g_param_spec_string ("mimetype", "mimetype", "mimetype", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_INTERPRETATION_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_INTERPRETATION_PROPERTY] = g_param_spec_string ("interpretation", "interpretation", "interpretation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_MANIFESTATION_PROPERTY, zeitgeist_subject_properties[ZEITGEIST_SUBJECT_MANIFESTATION_PROPERTY] = g_param_spec_string ("manifestation", "manifestation", "manifestation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_string_chunk_new ((gsize) 4096);
	_g_string_chunk_free0 (zeitgeist_subject_url_store);
	zeitgeist_subject_url_store = _tmp0_;
}

static void
zeitgeist_subject_instance_init (ZeitgeistSubject * self,
                                 gpointer klass)
{
	self->priv = zeitgeist_subject_get_instance_private (self);
}

static void
zeitgeist_subject_finalize (GObject * obj)
{
	ZeitgeistSubject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_origin);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_storage);
	_g_free0 (self->priv->_current_uri);
	_g_free0 (self->priv->_current_origin);
	G_OBJECT_CLASS (zeitgeist_subject_parent_class)->finalize (obj);
}

/**
 * Subject objects abstract Zeitgeist subjects
 *
 * In Zeitgeist terminology, a //subject// is something (a file, web page,
 * person, conversation, etc.) that was somehow involved or affected by
 * a {@link Event}.
 */
static GType
zeitgeist_subject_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSubjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_subject_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSubject), 0, (GInstanceInitFunc) zeitgeist_subject_instance_init, NULL };
	GType zeitgeist_subject_type_id;
	zeitgeist_subject_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSubject", &g_define_type_info, 0);
	ZeitgeistSubject_private_offset = g_type_add_instance_private (zeitgeist_subject_type_id, sizeof (ZeitgeistSubjectPrivate));
	return zeitgeist_subject_type_id;
}

GType
zeitgeist_subject_get_type (void)
{
	static volatile gsize zeitgeist_subject_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_subject_type_id__once)) {
		GType zeitgeist_subject_type_id;
		zeitgeist_subject_type_id = zeitgeist_subject_get_type_once ();
		g_once_init_leave (&zeitgeist_subject_type_id__once, zeitgeist_subject_type_id);
	}
	return zeitgeist_subject_type_id__once;
}

static void
_vala_zeitgeist_subject_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ZeitgeistSubject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject);
	switch (property_id) {
		case ZEITGEIST_SUBJECT_URI_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_uri (self));
		break;
		case ZEITGEIST_SUBJECT_ORIGIN_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_origin (self));
		break;
		case ZEITGEIST_SUBJECT_TEXT_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_text (self));
		break;
		case ZEITGEIST_SUBJECT_STORAGE_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_storage (self));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_URI_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_current_uri (self));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_ORIGIN_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_current_origin (self));
		break;
		case ZEITGEIST_SUBJECT_MIMETYPE_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_mimetype (self));
		break;
		case ZEITGEIST_SUBJECT_INTERPRETATION_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_interpretation (self));
		break;
		case ZEITGEIST_SUBJECT_MANIFESTATION_PROPERTY:
		g_value_set_string (value, zeitgeist_subject_get_manifestation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_subject_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ZeitgeistSubject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject);
	switch (property_id) {
		case ZEITGEIST_SUBJECT_URI_PROPERTY:
		zeitgeist_subject_set_uri (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_ORIGIN_PROPERTY:
		zeitgeist_subject_set_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_TEXT_PROPERTY:
		zeitgeist_subject_set_text (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_STORAGE_PROPERTY:
		zeitgeist_subject_set_storage (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_URI_PROPERTY:
		zeitgeist_subject_set_current_uri (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_ORIGIN_PROPERTY:
		zeitgeist_subject_set_current_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_MIMETYPE_PROPERTY:
		zeitgeist_subject_set_mimetype (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_INTERPRETATION_PROPERTY:
		zeitgeist_subject_set_interpretation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_MANIFESTATION_PROPERTY:
		zeitgeist_subject_set_manifestation (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

