/* sql-schema.c generated by valac 0.56.17, the Vala compiler
 * generated from sql-schema.vala, do not modify */

/* sql-schema.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011-2012 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 * Copyright © 2013 Seif Lotfy <seif@lotfy.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-internal.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include "zeitgeist-datamodel.h"
#include <glib/gstdio.h>
#include <glib-object.h>

#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_DATABASE_CREATION "database_creation"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_0_PROPERTY,
	ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_sq_lite_database_schema_properties[ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _Block3Data {
	int _ref_count_;
	gint64 schema_version;
};

static gpointer zeitgeist_sq_lite_database_schema_parent_class = NULL;

static void zeitgeist_sq_lite_database_schema_backup_database (GError** error);
static gint64 zeitgeist_sq_lite_database_schema_get_schema_metadata (sqlite3* database,
                                                              const gchar* key);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gint __lambda4_ (Block3Data* _data3_,
                 gint n_cols,
                 gchar** values,
                 gchar** column_names);
static gint ___lambda4__sqlite3_callback (gpointer self,
                                   gint n_columns,
                                   gchar** values,
                                   gchar** column_names);
static void zeitgeist_sq_lite_database_schema_set_schema_version (sqlite3* database,
                                                           gint schema_version,
                                                           GError** error);
static GType zeitgeist_sq_lite_database_schema_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database,
                                                 GError** error)
{
	gint _tmp0_ = 0;
	gint schema_version = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	if (zeitgeist_utils_using_in_memory_database ()) {
		_tmp0_ = -1;
	} else {
		_tmp0_ = zeitgeist_sq_lite_database_schema_get_schema_version (database, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	schema_version = _tmp0_;
	if (schema_version == -1) {
		gchar* schema_sql = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		zeitgeist_sq_lite_database_schema_setup_database (database, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		zeitgeist_sq_lite_database_schema_create_schema (database, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		zeitgeist_sq_lite_database_schema_create_event_indices (database, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp1_ = g_strdup_printf ("INSERT INTO schema_version VALUES ('%s', %" G_GINT64_FORMAT ")", ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_DATABASE_CREATION, zeitgeist_timestamp_from_now ());
		schema_sql = _tmp1_;
		_tmp2_ = schema_sql;
		zeitgeist_sq_lite_database_schema_exec_query (database, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (schema_sql);
				return;
			} else {
				_g_free0 (schema_sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (schema_sql);
	} else {
		gboolean _tmp3_ = FALSE;
		if (schema_version >= 3) {
			_tmp3_ = schema_version <= 10;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gchar** tables = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar** _tmp8_;
			gint tables_length1;
			gint _tables_size_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			gchar** _tmp14_;
			gint _tmp14__length1;
			gchar* _tmp22_;
			gchar* _tmp23_;
			zeitgeist_sq_lite_database_schema_backup_database (&_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_setup_database (database, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "BEGIN", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			if (schema_version == 3) {
				zeitgeist_sq_lite_database_schema_exec_query (database, "ALTER TABLE storage ADD COLUMN icon VARCHAR", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				zeitgeist_sq_lite_database_schema_exec_query (database, "ALTER TABLE storage ADD COLUMN display_name VARCHAR", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                        INSERT OR IGNORE INTO storage (value, state)\n" \
"                            VALUES ('unknown', 1)\n" \
"                        ", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                        UPDATE event SET subj_storage =\n" \
"                            (SELECT id FROM storage WHERE value='unkno" \
"wn')\n" \
"                        WHERE subj_storage IS NULL\n" \
"                        ", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "ALTER TABLE event RENAME TO event_old", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp4_ = g_strdup ("interpretation");
			_tmp5_ = g_strdup ("manifestation");
			_tmp6_ = g_strdup ("mimetype");
			_tmp7_ = g_strdup ("actor");
			_tmp8_ = g_new0 (gchar*, 4 + 1);
			_tmp8_[0] = _tmp4_;
			_tmp8_[1] = _tmp5_;
			_tmp8_[2] = _tmp6_;
			_tmp8_[3] = _tmp7_;
			tables = _tmp8_;
			tables_length1 = 4;
			_tables_size_ = tables_length1;
			_tmp9_ = tables;
			_tmp9__length1 = tables_length1;
			{
				gchar** table_collection = NULL;
				gint table_collection_length1 = 0;
				gint _table_collection_size_ = 0;
				gint table_it = 0;
				table_collection = _tmp9_;
				table_collection_length1 = _tmp9__length1;
				for (table_it = 0; table_it < table_collection_length1; table_it = table_it + 1) {
					const gchar* table = NULL;
					table = table_collection[table_it];
					{
						const gchar* _tmp10_;
						const gchar* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp10_ = table;
						_tmp11_ = table;
						_tmp12_ = g_strdup_printf ("ALTER TABLE %s RENAME TO %s_old", _tmp10_, _tmp11_);
						_tmp13_ = _tmp12_;
						zeitgeist_sq_lite_database_schema_exec_query (database, _tmp13_, &_inner_error0_);
						_g_free0 (_tmp13_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
				}
			}
			zeitgeist_sq_lite_database_schema_create_schema (database, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_drop_event_indices (database, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_drop_basic_indices (database, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp14_ = tables;
			_tmp14__length1 = tables_length1;
			{
				gchar** table_collection = NULL;
				gint table_collection_length1 = 0;
				gint _table_collection_size_ = 0;
				gint table_it = 0;
				table_collection = _tmp14_;
				table_collection_length1 = _tmp14__length1;
				for (table_it = 0; table_it < table_collection_length1; table_it = table_it + 1) {
					const gchar* table = NULL;
					table = table_collection[table_it];
					{
						const gchar* _tmp15_;
						const gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp15_ = table;
						_tmp16_ = table;
						_tmp17_ = g_strdup_printf ("INSERT INTO %s SELECT id, value FROM %s_old", _tmp15_, _tmp16_);
						_tmp18_ = _tmp17_;
						zeitgeist_sq_lite_database_schema_exec_query (database, _tmp18_, &_inner_error0_);
						_g_free0 (_tmp18_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
						_tmp19_ = table;
						_tmp20_ = g_strdup_printf ("DROP TABLE %s_old", _tmp19_);
						_tmp21_ = _tmp20_;
						zeitgeist_sq_lite_database_schema_exec_query (database, _tmp21_, &_inner_error0_);
						_g_free0 (_tmp21_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                    DELETE FROM text WHERE id NOT IN (SELECT subj_text" \
" FROM event_old)\n" \
"                ", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                    DELETE FROM storage WHERE id NOT IN (SELECT subj_s" \
"torage FROM event_old)\n" \
"                ", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                    DELETE FROM uri WHERE id NOT IN (\n" \
"                        SELECT origin FROM event_old\n" \
"                        UNION\n" \
"                        SELECT subj_id FROM event_old\n" \
"                        UNION\n" \
"                        SELECT subj_id_current FROM event_old\n" \
"                        UNION\n" \
"                        SELECT subj_origin FROM event_old\n" \
"                        UNION\n" \
"                        SELECT subj_origin_current FROM event_old\n" \
"                    )\n" \
"                ", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                    DELETE FROM payload WHERE id NOT IN (SELECT payloa" \
"d FROM event_old)\n" \
"                ", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                    INSERT INTO event\n" \
"                    SELECT\n" \
"                        id, timestamp, interpretation, manifestation,\n" \
"                        actor, payload, subj_id, subj_interpretation,\n" \
"                        subj_manifestation, subj_origin, subj_mimetype" \
",\n" \
"                        subj_text, subj_storage, NULL as origin,\n" \
"                        subj_id AS subj_id_current,\n" \
"                        subj_origin AS subj_origin_current\n" \
"                     FROM event_old WHERE id IS NOT NULL\n" \
"                        AND timestamp IS NOT NULL\n" \
"                        AND interpretation IS NOT NULL\n" \
"                        AND manifestation IS NOT NULL\n" \
"                        AND actor IS NOT NULL\n" \
"                        and subj_id IS NOT NULL\n" \
"                     ", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "DROP TABLE event_old", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp22_ = g_strdup_printf ("INSERT OR IGNORE INTO manifestation (value) VALUES ('%s')", ZEITGEIST_NFO_WEB_DATA_OBJECT);
			_tmp23_ = _tmp22_;
			zeitgeist_sq_lite_database_schema_exec_query (database, _tmp23_, &_inner_error0_);
			_g_free0 (_tmp23_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                    UPDATE event\n" \
"                    SET subj_manifestation=(\n" \
"                        SELECT id FROM manifestation WHERE value='" ZEITGEIST_NFO_WEB_DATA_OBJECT "')\n" \
"                    WHERE\n" \
"                        subj_manifestation=(\n" \
"                            SELECT id FROM manifestation WHERE value='" ZEITGEIST_NFO_REMOTE_DATA_OBJECT "')\n" \
"                        AND subj_id IN (\n" \
"                            SELECT id FROM uri\n" \
"                            WHERE\n" \
"                                value LIKE \"http://%\"\n" \
"                                OR value LIKE \"https://%\"\n" \
"                        )\n" \
"                    ", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "COMMIT", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_create_event_indices (database, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_schema_exec_query (database, "ANALYZE", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			g_message ("sql-schema.vala:199: Upgraded database to schema version %d.", ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION);
			tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
		} else {
			if (schema_version < ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION) {
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_;
				GError* _tmp27_;
				_tmp24_ = g_strdup_printf ("Unable to upgrade from schema version %d", schema_version);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp25_);
				_tmp27_ = _tmp26_;
				_g_free0 (_tmp25_);
				_inner_error0_ = _tmp27_;
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

static void
zeitgeist_sq_lite_database_schema_backup_database (GError** error)
{
	GError* _inner_error0_ = NULL;
	{
		zeitgeist_utils_backup_database (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* backup_error = NULL;
		gchar* msg = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		backup_error = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = backup_error;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = g_strconcat ("Database backup failed: ", _tmp1_, NULL);
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED, _tmp3_);
		_inner_error0_ = _tmp4_;
		_g_free0 (msg);
		_g_error_free0 (backup_error);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gint
zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database,
                                                      GError** error)
{
	gint schema_version = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (database != NULL, 0);
	schema_version = (gint) zeitgeist_sq_lite_database_schema_get_schema_metadata (database, ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA);
	g_debug ("sql-schema.vala:227: schema_version is %d", schema_version);
	if (schema_version < -1) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT, "Database corruption flag is set.");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			gint _tmp1_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gint _tmp2_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = schema_version;
	return result;
}

gint64
zeitgeist_sq_lite_database_schema_get_creation_date (sqlite3* database)
{
	gint64 result;
	g_return_val_if_fail (database != NULL, 0LL);
	result = zeitgeist_sq_lite_database_schema_get_schema_metadata (database, ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_DATABASE_CREATION);
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		g_slice_free (Block3Data, _data3_);
	}
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gint
__lambda4_ (Block3Data* _data3_,
            gint n_cols,
            gchar** values,
            gchar** column_names)
{
	const gchar* _tmp0_;
	gint result;
	_tmp0_ = values[0];
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = values[0];
		_data3_->schema_version = int64_parse (_tmp1_, (guint) 0);
	}
	result = 0;
	return result;
}

static gint
___lambda4__sqlite3_callback (gpointer self,
                              gint n_columns,
                              gchar** values,
                              gchar** column_names)
{
	gint result;
	result = __lambda4_ (self, n_columns, values, column_names);
	return result;
}

static gint64
zeitgeist_sq_lite_database_schema_get_schema_metadata (sqlite3* database,
                                                       const gchar* key)
{
	Block3Data* _data3_;
	gchar* sql = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint64 result;
	g_return_val_if_fail (database != NULL, 0LL);
	g_return_val_if_fail (key != NULL, 0LL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = g_strdup_printf ("WHERE schema='%s'", key);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("SELECT version FROM schema_version ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	sql = _tmp3_;
	_data3_->schema_version = (gint64) -1;
	_sqlite3_exec (database, sql, ___lambda4__sqlite3_callback, _data3_, NULL);
	result = _data3_->schema_version;
	_g_free0 (sql);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

void
zeitgeist_sq_lite_database_schema_set_corruption_flag (sqlite3* database,
                                                       GError** error)
{
	gint version = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	version = zeitgeist_sq_lite_database_schema_get_schema_version (database, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (version > 0) {
		version = -version;
	}
	zeitgeist_sq_lite_database_schema_set_schema_version (database, version, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
zeitgeist_sq_lite_database_schema_set_schema_version (sqlite3* database,
                                                      gint schema_version,
                                                      GError** error)
{
	gchar* schema_sql = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp0_ = g_strdup_printf ("INSERT INTO schema_version VALUES ('%s', %d)", ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA, schema_version);
	schema_sql = _tmp0_;
	zeitgeist_sq_lite_database_schema_exec_query (database, schema_sql, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (schema_sql);
			return;
		} else {
			_g_free0 (schema_sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (schema_sql);
}

void
zeitgeist_sq_lite_database_schema_setup_database (sqlite3* database,
                                                  GError** error)
{
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	if (!zeitgeist_utils_using_in_memory_database ()) {
		const gchar* _tmp0_;
		_tmp0_ = zeitgeist_utils_get_database_file_path ();
		g_chmod (_tmp0_, 0600);
	}
	_tmp1_ = zeitgeist_utils_get_data_path ();
	_tmp2_ = zeitgeist_utils_get_default_data_path ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		_tmp5_ = zeitgeist_utils_get_data_path ();
		g_chmod (_tmp5_, 0700);
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "PRAGMA journal_mode = WAL", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "PRAGMA synchronous = NORMAL", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "PRAGMA locking_mode = NORMAL", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "PRAGMA default_cache_size = 50", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "PRAGMA wal_autocheckpoint = 10", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
zeitgeist_sq_lite_database_schema_create_schema (sqlite3* database,
                                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS uri (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS interpretation (\n" \
"                    id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS manifestation (\n" \
"                    id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS mimetype (\n" \
"                    id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS actor (\n" \
"                    id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS text (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS payload\n" \
"                    (id INTEGER PRIMARY KEY, value BLOB)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS storage (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE,\n" \
"                    state INTEGER,\n" \
"                    icon VARCHAR,\n" \
"                    display_name VARCHAR\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS event (\n" \
"                    id INTEGER NOT NULL,\n" \
"                    timestamp INTEGER NOT NULL,\n" \
"                    interpretation INTEGER NOT NULL,\n" \
"                    manifestation INTEGER NOT NULL,\n" \
"                    actor INTEGER NOT NULL,\n" \
"                    payload INTEGER,\n" \
"                    subj_id INTEGER NOT NULL,\n" \
"                    subj_interpretation INTEGER,\n" \
"                    subj_manifestation INTEGER,\n" \
"                    subj_origin INTEGER,\n" \
"                    subj_mimetype INTEGER,\n" \
"                    subj_text INTEGER,\n" \
"                    subj_storage INTEGER,\n" \
"                    origin INTEGER,\n" \
"                    subj_id_current INTEGER,\n" \
"                    subj_origin_current INTEGER,\n" \
"                    CONSTRAINT interpretation_fk\n" \
"                        FOREIGN KEY(interpretation)\n" \
"                        REFERENCES interpretation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT manifestation_fk\n" \
"                        FOREIGN KEY(manifestation)\n" \
"                        REFERENCES manifestation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT actor_fk\n" \
"                        FOREIGN KEY(actor)\n" \
"                        REFERENCES actor(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT origin_fk\n" \
"                        FOREIGN KEY(origin)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT payload_fk\n" \
"                        FOREIGN KEY(payload)\n" \
"                        REFERENCES payload(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_id_fk\n" \
"                        FOREIGN KEY(subj_id)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_id_current_fk\n" \
"                        FOREIGN KEY(subj_id_current)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_interpretation_fk\n" \
"                        FOREIGN KEY(subj_interpretation)\n" \
"                        REFERENCES interpretation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_manifestation_fk\n" \
"                        FOREIGN KEY(subj_manifestation)\n" \
"                        REFERENCES manifestation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_origin_fk\n" \
"                        FOREIGN KEY(subj_origin)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_origin_current_fk\n" \
"                        FOREIGN KEY(subj_origin_current)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_mimetype_fk\n" \
"                        FOREIGN KEY(subj_mimetype)\n" \
"                        REFERENCES mimetype(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_text_fk\n" \
"                        FOREIGN KEY(subj_text)\n" \
"                        REFERENCES text(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_storage_fk\n" \
"                        FOREIGN KEY(subj_storage)\n" \
"                        REFERENCES storage(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    PRIMARY KEY (timestamp, interpretation,\n" \
"                        manifestation, actor, subj_id)\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TRIGGER fkdc_event_subj_text\n" \
"                    AFTER DELETE ON event\n" \
"                    WHEN ((SELECT COUNT(*) FROM event WHERE subj_text=" \
"OLD.subj_text) == 0)\n" \
"                BEGIN\n" \
"                    DELETE FROM text WHERE id=OLD.subj_text;\n" \
"                END;\n" \
"            ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TRIGGER fkdc_event_subj_storage\n" \
"                    AFTER DELETE ON event\n" \
"                    WHEN ((SELECT COUNT(*) FROM event WHERE subj_stora" \
"ge=OLD.subj_storage) == 0)\n" \
"                BEGIN\n" \
"                    DELETE FROM storage WHERE id=OLD.subj_storage;\n" \
"                END;\n" \
"            ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TRIGGER fkdc_event_payload\n" \
"                    AFTER DELETE ON event\n" \
"                    WHEN (OLD.payload IS NOT NULL)\n" \
"                BEGIN\n" \
"                    DELETE FROM payload WHERE id=OLD.payload;\n" \
"                END;\n" \
"            ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TRIGGER fkdc_event_origin\n" \
"                    AFTER DELETE ON event\n" \
"                    WHEN ((\n" \
"                        SELECT COUNT(*)\n" \
"                        FROM event\n" \
"                        WHERE\n" \
"                            origin=OLD.origin\n" \
"                            OR subj_id=OLD.origin\n" \
"                            OR subj_id_current=OLD.origin\n" \
"                            OR subj_origin=OLD.origin\n" \
"                            OR subj_origin_current=OLD.origin\n" \
"                        ) == 0)\n" \
"                BEGIN\n" \
"                    DELETE FROM uri WHERE id=OLD.origin;\n" \
"                END;\n" \
"            ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TRIGGER fkdc_event_subj_id\n" \
"                    AFTER DELETE ON event\n" \
"                    WHEN ((\n" \
"                        SELECT COUNT(*)\n" \
"                        FROM event\n" \
"                        WHERE\n" \
"                            origin=OLD.subj_id\n" \
"                            OR subj_id=OLD.subj_id\n" \
"                            OR subj_id_current=OLD.subj_id\n" \
"                            OR subj_origin=OLD.subj_id\n" \
"                            OR subj_origin_current=OLD.subj_id\n" \
"                        ) == 0)\n" \
"                BEGIN\n" \
"                    DELETE FROM uri WHERE id=OLD.subj_id;\n" \
"                END;\n" \
"            ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TRIGGER fkdc_event_subj_id_current\n" \
"                    AFTER DELETE ON event\n" \
"                    WHEN ((\n" \
"                        SELECT COUNT(*)\n" \
"                        FROM event\n" \
"                        WHERE\n" \
"                            origin=OLD.subj_id_current\n" \
"                            OR subj_id=OLD.subj_id_current\n" \
"                            OR subj_id_current=OLD.subj_id_current\n" \
"                            OR subj_origin=OLD.subj_id_current\n" \
"                            OR subj_origin_current=OLD.subj_id_current" \
"\n" \
"                        ) == 0)\n" \
"                BEGIN\n" \
"                    DELETE FROM uri WHERE id=OLD.subj_id_current;\n" \
"                END;\n" \
"            ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TRIGGER fkdc_event_subj_origin\n" \
"                    AFTER DELETE ON event\n" \
"                    WHEN ((\n" \
"                        SELECT COUNT(*)\n" \
"                        FROM event\n" \
"                        WHERE\n" \
"                            origin=OLD.subj_origin\n" \
"                            OR subj_id=OLD.subj_origin\n" \
"                            OR subj_id_current=OLD.subj_origin\n" \
"                            OR subj_origin=OLD.subj_origin\n" \
"                            OR subj_origin_current=OLD.subj_origin\n" \
"                        ) == 0)\n" \
"                BEGIN\n" \
"                    DELETE FROM uri WHERE id=OLD.subj_origin;\n" \
"                END;\n" \
"            ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TRIGGER fkdc_event_subj_origin_current\n" \
"                    AFTER DELETE ON event\n" \
"                    WHEN ((\n" \
"                        SELECT COUNT(*)\n" \
"                        FROM event\n" \
"                        WHERE\n" \
"                            origin=OLD.subj_origin_current\n" \
"                            OR subj_id=OLD.subj_origin_current\n" \
"                            OR subj_id_current=OLD.subj_origin_current" \
"\n" \
"                            OR subj_origin=OLD.subj_origin_current\n" \
"                            OR subj_origin_current=OLD.subj_origin\n" \
"                        ) == 0)\n" \
"                BEGIN\n" \
"                    DELETE FROM uri WHERE id=OLD.subj_origin_current;\n" \
"                END;\n" \
"            ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS extensions_conf (\n" \
"                    extension VARCHAR,\n" \
"                    key VARCHAR,\n" \
"                    value BLOB,\n" \
"                    CONSTRAINT unique_extension UNIQUE (extension, key" \
")\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP VIEW IF EXISTS event_view", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE VIEW IF NOT EXISTS event_view AS\n" \
"                    SELECT event.id,\n" \
"                        event.timestamp,\n" \
"                        event.interpretation,\n" \
"                        event.manifestation,\n" \
"                        event.actor,\n" \
"                        (SELECT value FROM payload\n" \
"                            WHERE payload.id=event.payload)\n" \
"                            AS payload,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_id)\n" \
"                            AS subj_uri,\n" \
"                        event.subj_id, --//this points to an id in the" \
" uri table\n" \
"                        event.subj_interpretation,\n" \
"                        event.subj_manifestation,\n" \
"                        event.subj_origin,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_origin)\n" \
"                            AS subj_origin_uri,\n" \
"                        event.subj_mimetype,\n" \
"                        (SELECT value FROM text\n" \
"                            WHERE text.id = event.subj_text)\n" \
"                            AS subj_text,\n" \
"                        (SELECT value FROM storage\n" \
"                            WHERE storage.id=event.subj_storage)\n" \
"                            AS subj_storage,\n" \
"                        (SELECT state FROM storage\n" \
"                            WHERE storage.id=event.subj_storage)\n" \
"                            AS subj_storage_state,\n" \
"                        event.origin,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.origin)\n" \
"                            AS event_origin_uri,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_id_current)\n" \
"                            AS subj_current_uri,\n" \
"                        event.subj_id_current,\n" \
"                        event.subj_text AS subj_text_id,\n" \
"                        event.subj_storage AS subj_storage_id,\n" \
"                        (SELECT value FROM actor\n" \
"                            WHERE actor.id=event.actor)\n" \
"                            AS actor_uri,\n" \
"                        event.subj_origin_current,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_origin_current)\n" \
"                            AS subj_origin_current_uri\n" \
"                    FROM event\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE TABLE IF NOT EXISTS schema_version (\n" \
"                    schema VARCHAR PRIMARY KEY ON CONFLICT REPLACE,\n" \
"                    version INT\n" \
"                )\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_set_schema_version (database, ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
zeitgeist_sq_lite_database_schema_create_basic_indices (sqlite3* database,
                                                        GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS uri_value ON uri(val" \
"ue)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS interpretation_value" \
"\n" \
"                    ON interpretation(value)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS manifestation_value\n" \
"                    ON manifestation(value)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS mimetype_value\n" \
"                    ON mimetype(value)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS actor_value\n" \
"                    ON actor(value)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS text_value\n" \
"                    ON text(value)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS storage_value\n" \
"                    ON storage(value)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS extensions_conf_key\n" \
"                    ON extensions_conf (extension, key)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
zeitgeist_sq_lite_database_schema_create_event_indices (sqlite3* database,
                                                        GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_id\n" \
"                    ON event(id, timestamp)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_timestamp\n" \
"                    ON event(timestamp, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_interpretation\n" \
"                    ON event(interpretation, timestamp, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_manifestation\n" \
"                    ON event(manifestation, timestamp, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_actor\n" \
"                    ON event(actor, timestamp, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_origin\n" \
"                    ON event(origin, timestamp, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_id\n" \
"                    ON event(subj_id, timestamp, subj_interpretation, " \
"id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_id_current\n" \
"                    ON event(subj_id_current, timestamp, subj_interpre" \
"tation, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_interpretation\n" \
"                    ON event(subj_interpretation, timestamp, subj_id, " \
"id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_manifestation\n" \
"                    ON event(subj_manifestation, timestamp, subj_id, i" \
"d)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_origin\n" \
"                    ON event(subj_origin, timestamp, subj_interpretati" \
"on, subj_id, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_origin_current\n" \
"                    ON event(subj_origin_current, timestamp, subj_inte" \
"rpretation, subj_id, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_mimetype\n" \
"                    ON event(subj_mimetype, timestamp, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_text\n" \
"                    ON event(subj_text, timestamp, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_storage\n" \
"                    ON event(subj_storage, timestamp, id)\n" \
"                ", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
zeitgeist_sq_lite_database_schema_drop_basic_indices (sqlite3* database,
                                                      GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS uri_value", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS interpretation_value", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS manifestation_value", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS mimetype_value", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS actor_value", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS text_value", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS storage_value", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS extensions_conf_key", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
zeitgeist_sq_lite_database_schema_drop_event_indices (sqlite3* database,
                                                      GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_id", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_timestamp", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_interpretation", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_manifestation", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_actor", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_origin", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_id", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_id_current", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_interpretation", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_manifestation", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_origin", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_current", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_mimetype", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_text", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	zeitgeist_sq_lite_database_schema_exec_query (database, "DROP INDEX IF EXISTS event_subj_storage", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
         * Execute the given SQL. If the query doesn't succeed, throw
         * an error.
         *
         * @param database the database on which to run the query
         * @param sql the SQL query to run
         */
void
zeitgeist_sq_lite_database_schema_exec_query (sqlite3* database,
                                              const gchar* sql,
                                              GError** error)
{
	gint rc = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (database != NULL);
	g_return_if_fail (sql != NULL);
	rc = _sqlite3_exec (database, sql, NULL, NULL, NULL);
	if (rc != SQLITE_OK) {
		if (rc == SQLITE_CORRUPT) {
			const gchar* _tmp0_;
			GError* _tmp1_;
			_tmp0_ = sqlite3_errmsg (database);
			_tmp1_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT, _tmp0_);
			_inner_error0_ = _tmp1_;
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		} else {
			static const char fmt_str[] = "Can't create database: %d, %s\n\n" "Unable to execute SQL:\n%s";
			gchar* err_msg = NULL;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			GError* _tmp5_;
			_tmp2_ = sqlite3_errmsg (database);
			_tmp3_ = g_strdup_printf (fmt_str, rc, _tmp2_, sql);
			err_msg = _tmp3_;
			_tmp4_ = err_msg;
			_tmp5_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp4_);
			_inner_error0_ = _tmp5_;
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (err_msg);
				return;
			} else {
				_g_free0 (err_msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (err_msg);
		}
	}
}

ZeitgeistSQLiteDatabaseSchema*
zeitgeist_sq_lite_database_schema_construct (GType object_type)
{
	ZeitgeistSQLiteDatabaseSchema * self = NULL;
	self = (ZeitgeistSQLiteDatabaseSchema*) g_object_new (object_type, NULL);
	return self;
}

ZeitgeistSQLiteDatabaseSchema*
zeitgeist_sq_lite_database_schema_new (void)
{
	return zeitgeist_sq_lite_database_schema_construct (ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA);
}

static void
zeitgeist_sq_lite_database_schema_class_init (ZeitgeistSQLiteDatabaseSchemaClass * klass,
                                              gpointer klass_data)
{
	zeitgeist_sq_lite_database_schema_parent_class = g_type_class_peek_parent (klass);
}

static void
zeitgeist_sq_lite_database_schema_instance_init (ZeitgeistSQLiteDatabaseSchema * self,
                                                 gpointer klass)
{
}

static GType
zeitgeist_sq_lite_database_schema_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSQLiteDatabaseSchemaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_sq_lite_database_schema_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSQLiteDatabaseSchema), 0, (GInstanceInitFunc) zeitgeist_sq_lite_database_schema_instance_init, NULL };
	GType zeitgeist_sq_lite_database_schema_type_id;
	zeitgeist_sq_lite_database_schema_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSQLiteDatabaseSchema", &g_define_type_info, 0);
	return zeitgeist_sq_lite_database_schema_type_id;
}

GType
zeitgeist_sq_lite_database_schema_get_type (void)
{
	static volatile gsize zeitgeist_sq_lite_database_schema_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_database_schema_type_id__once)) {
		GType zeitgeist_sq_lite_database_schema_type_id;
		zeitgeist_sq_lite_database_schema_type_id = zeitgeist_sq_lite_database_schema_get_type_once ();
		g_once_init_leave (&zeitgeist_sq_lite_database_schema_type_id__once, zeitgeist_sq_lite_database_schema_type_id);
	}
	return zeitgeist_sq_lite_database_schema_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

