#include "livekit/webrtc.h"
#include <array>
#include <cstddef>
#include <cstdint>
#include <memory>
#include <new>
#include <string>
#include <type_traits>
#include <utility>

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#ifdef __clang__
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#pragma clang diagnostic ignored "-Wreturn-type-c-linkage"
#endif // __clang__
#endif // __GNUC__

namespace rust {
inline namespace cxxbridge1 {
// #include "rust/cxx.h"

struct unsafe_bitcopy_t;

#ifndef CXXBRIDGE1_RUST_STRING
#define CXXBRIDGE1_RUST_STRING
class String final {
public:
  String() noexcept;
  String(const String &) noexcept;
  String(String &&) noexcept;
  ~String() noexcept;

  String(const std::string &);
  String(const char *);
  String(const char *, std::size_t);
  String(const char16_t *);
  String(const char16_t *, std::size_t);
#ifdef __cpp_char8_t
  String(const char8_t *s);
  String(const char8_t *s, std::size_t len);
#endif

  static String lossy(const std::string &) noexcept;
  static String lossy(const char *) noexcept;
  static String lossy(const char *, std::size_t) noexcept;
  static String lossy(const char16_t *) noexcept;
  static String lossy(const char16_t *, std::size_t) noexcept;

  String &operator=(const String &) & noexcept;
  String &operator=(String &&) & noexcept;

  explicit operator std::string() const;

  const char *data() const noexcept;
  std::size_t size() const noexcept;
  std::size_t length() const noexcept;
  bool empty() const noexcept;

  const char *c_str() noexcept;

  std::size_t capacity() const noexcept;
  void reserve(size_t new_cap) noexcept;

  using iterator = char *;
  iterator begin() noexcept;
  iterator end() noexcept;

  using const_iterator = const char *;
  const_iterator begin() const noexcept;
  const_iterator end() const noexcept;
  const_iterator cbegin() const noexcept;
  const_iterator cend() const noexcept;

  bool operator==(const String &) const noexcept;
  bool operator!=(const String &) const noexcept;
  bool operator<(const String &) const noexcept;
  bool operator<=(const String &) const noexcept;
  bool operator>(const String &) const noexcept;
  bool operator>=(const String &) const noexcept;

  void swap(String &) noexcept;

  String(unsafe_bitcopy_t, const String &) noexcept;

private:
  struct lossy_t;
  String(lossy_t, const char *, std::size_t) noexcept;
  String(lossy_t, const char16_t *, std::size_t) noexcept;
  friend void swap(String &lhs, String &rhs) noexcept { lhs.swap(rhs); }

  std::array<std::uintptr_t, 3> repr;
};
#endif // CXXBRIDGE1_RUST_STRING

#ifndef CXXBRIDGE1_RUST_FN
#define CXXBRIDGE1_RUST_FN
template <typename Signature>
class Fn;

template <typename Ret, typename... Args>
class Fn<Ret(Args...)> final {
public:
  Ret operator()(Args... args) const noexcept;
  Fn operator*() const noexcept;

private:
  Ret (*trampoline)(Args..., void *fn) noexcept;
  void *fn;
};

template <typename Ret, typename... Args>
Ret Fn<Ret(Args...)>::operator()(Args... args) const noexcept {
  return (*this->trampoline)(std::forward<Args>(args)..., this->fn);
}

template <typename Ret, typename... Args>
Fn<Ret(Args...)> Fn<Ret(Args...)>::operator*() const noexcept {
  return *this;
}
#endif // CXXBRIDGE1_RUST_FN

#ifndef CXXBRIDGE1_IS_COMPLETE
#define CXXBRIDGE1_IS_COMPLETE
namespace detail {
namespace {
template <typename T, typename = std::size_t>
struct is_complete : std::false_type {};
template <typename T>
struct is_complete<T, decltype(sizeof(T))> : std::true_type {};
} // namespace
} // namespace detail
#endif // CXXBRIDGE1_IS_COMPLETE

namespace {
template <bool> struct deleter_if {
  template <typename T> void operator()(T *) {}
};
template <> struct deleter_if<true> {
  template <typename T> void operator()(T *ptr) { ptr->~T(); }
};
} // namespace
} // namespace cxxbridge1
} // namespace rust

namespace livekit {
  enum class MediaType : ::std::int32_t;
  enum class Priority : ::std::int32_t;
  enum class RtpTransceiverDirection : ::std::int32_t;
  enum class LoggingSeverity : ::std::int32_t;
  using LogSink = ::livekit::LogSink;
}

namespace livekit {
#ifndef CXXBRIDGE1_ENUM_livekit$MediaType
#define CXXBRIDGE1_ENUM_livekit$MediaType
enum class MediaType : ::std::int32_t {
  Audio = 0,
  Video = 1,
  Data = 2,
  Unsupported = 3,
};
#endif // CXXBRIDGE1_ENUM_livekit$MediaType

#ifndef CXXBRIDGE1_ENUM_livekit$Priority
#define CXXBRIDGE1_ENUM_livekit$Priority
enum class Priority : ::std::int32_t {
  VeryLow = 0,
  Low = 1,
  Medium = 2,
  High = 3,
};
#endif // CXXBRIDGE1_ENUM_livekit$Priority

#ifndef CXXBRIDGE1_ENUM_livekit$RtpTransceiverDirection
#define CXXBRIDGE1_ENUM_livekit$RtpTransceiverDirection
enum class RtpTransceiverDirection : ::std::int32_t {
  SendRecv = 0,
  SendOnly = 1,
  RecvOnly = 2,
  Inactive = 3,
  Stopped = 4,
};
#endif // CXXBRIDGE1_ENUM_livekit$RtpTransceiverDirection

#ifndef CXXBRIDGE1_ENUM_livekit$LoggingSeverity
#define CXXBRIDGE1_ENUM_livekit$LoggingSeverity
enum class LoggingSeverity : ::std::int32_t {
  Verbose = 0,
  Info = 1,
  Warning = 2,
  Error = 3,
  None = 4,
};
#endif // CXXBRIDGE1_ENUM_livekit$LoggingSeverity

extern "C" {
void livekit$cxxbridge1$create_random_uuid(::rust::String *return$) noexcept {
  ::rust::String (*create_random_uuid$)() = ::livekit::create_random_uuid;
  new (return$) ::rust::String(create_random_uuid$());
}

::livekit::LogSink *livekit$cxxbridge1$new_log_sink(::rust::Fn<void(::rust::String, ::livekit::LoggingSeverity)> fnc) noexcept {
  ::std::unique_ptr<::livekit::LogSink> (*new_log_sink$)(::rust::Fn<void(::rust::String, ::livekit::LoggingSeverity)>) = ::livekit::new_log_sink;
  return new_log_sink$(fnc).release();
}

void livekit$cxxbridge1$new_log_sink$fnc$1(::rust::String *arg0, ::livekit::LoggingSeverity arg1, void *) noexcept;

void livekit$cxxbridge1$new_log_sink$fnc$0(::rust::String arg0, ::livekit::LoggingSeverity arg1, void *extern$) noexcept {
  livekit$cxxbridge1$new_log_sink$fnc$1(&arg0, arg1, extern$);
}
} // extern "C"
} // namespace livekit

extern "C" {
static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::LogSink>::type>::value, "definition of `::livekit::LogSink` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::LogSink>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::LogSink>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$LogSink$null(::std::unique_ptr<::livekit::LogSink> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::LogSink>();
}
void cxxbridge1$unique_ptr$livekit$LogSink$raw(::std::unique_ptr<::livekit::LogSink> *ptr, ::std::unique_ptr<::livekit::LogSink>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::LogSink>(raw);
}
::std::unique_ptr<::livekit::LogSink>::element_type const *cxxbridge1$unique_ptr$livekit$LogSink$get(::std::unique_ptr<::livekit::LogSink> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::LogSink>::pointer cxxbridge1$unique_ptr$livekit$LogSink$release(::std::unique_ptr<::livekit::LogSink> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$LogSink$drop(::std::unique_ptr<::livekit::LogSink> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::LogSink>::value>{}(ptr);
}
} // extern "C"
