/* DeviceManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DeviceManager.vala, do not modify */

/*
 * Copyright (c) 2011-2021 elementary LLC. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "power.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define POWER_SERVICES_DEVICE_MANAGER_UPOWER_INTERFACE "org.freedesktop.UPower"
#define POWER_SERVICES_DEVICE_MANAGER_UPOWER_PATH "/org/freedesktop/UPower"
#define POWER_SERVICES_DEVICE_MANAGER_POWER_SETTINGS_INTERFACE "org.gnome.SettingsDaemon.Power"
#define POWER_SERVICES_DEVICE_MANAGER_POWER_SETTINGS_PATH "/org/gnome/SettingsDaemon/Power"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define POWER_SERVICES_DBUS_INTERFACES_TYPE_POWER_SETTINGS (power_services_dbus_interfaces_power_settings_get_type ())
#define POWER_SERVICES_DBUS_INTERFACES_POWER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_SERVICES_DBUS_INTERFACES_TYPE_POWER_SETTINGS, PowerServicesDBusInterfacesPowerSettings))
#define POWER_SERVICES_DBUS_INTERFACES_IS_POWER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_SERVICES_DBUS_INTERFACES_TYPE_POWER_SETTINGS))
#define POWER_SERVICES_DBUS_INTERFACES_POWER_SETTINGS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), POWER_SERVICES_DBUS_INTERFACES_TYPE_POWER_SETTINGS, PowerServicesDBusInterfacesPowerSettingsIface))

typedef struct _PowerServicesDBusInterfacesPowerSettings PowerServicesDBusInterfacesPowerSettings;
typedef struct _PowerServicesDBusInterfacesPowerSettingsIface PowerServicesDBusInterfacesPowerSettingsIface;

#define POWER_SERVICES_DBUS_INTERFACES_TYPE_POWER_SETTINGS_PROXY (power_services_dbus_interfaces_power_settings_proxy_get_type ())
enum  {
	POWER_SERVICES_DEVICE_MANAGER_0_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_BACKLIGHT_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_DEVICES_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_BATTERIES_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_DISPLAY_DEVICE_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_HAS_BATTERY_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_ON_BATTERY_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_ON_LOW_BATTERY_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_PROPERTY,
	POWER_SERVICES_DEVICE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PowerServicesDeviceManagerConnectToBusData PowerServicesDeviceManagerConnectToBusData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	POWER_SERVICES_DEVICE_MANAGER_BATTERY_REGISTERED_SIGNAL,
	POWER_SERVICES_DEVICE_MANAGER_BATTERY_DEREGISTERED_SIGNAL,
	POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_CHANGED_SIGNAL,
	POWER_SERVICES_DEVICE_MANAGER_NUM_SIGNALS
};
static guint power_services_device_manager_signals[POWER_SERVICES_DEVICE_MANAGER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PowerServicesDBusInterfacesPowerSettingsIface {
	GTypeInterface parent_iface;
	gint (*get_brightness) (PowerServicesDBusInterfacesPowerSettings* self);
	void (*set_brightness) (PowerServicesDBusInterfacesPowerSettings* self, gint value);
};

struct _PowerServicesDeviceManagerPrivate {
	PowerServicesDBusInterfacesUPower* upower;
	PowerServicesDBusInterfacesPowerSettings* iscreen;
	PowerServicesBacklight* _backlight;
	GeeHashMap* _devices;
	GeeIterator* _batteries;
	PowerServicesDevice* _display_device;
	gboolean _has_battery;
	gboolean _on_battery;
	gboolean _on_low_battery;
};

struct _PowerServicesDeviceManagerConnectToBusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PowerServicesDeviceManager* self;
	gboolean result;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	PowerServicesDBusInterfacesUPower* _tmp2_;
	PowerServicesDBusInterfacesUPower* _tmp3_;
	PowerServicesDBusInterfacesUPower* _tmp4_;
	PowerServicesDBusInterfacesPowerSettings* _tmp5_;
	PowerServicesDBusInterfacesPowerSettings* _tmp6_;
	PowerServicesDBusInterfacesPowerSettings* _tmp7_;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

static gint PowerServicesDeviceManager_private_offset;
static gpointer power_services_device_manager_parent_class = NULL;
static PowerServicesDeviceManager* power_services_device_manager_instance;
static PowerServicesDeviceManager* power_services_device_manager_instance = NULL;

VALA_EXTERN GType power_services_dbus_interfaces_power_settings_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType power_services_dbus_interfaces_power_settings_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint power_services_dbus_interfaces_power_settings_register_object (void* object,
                                                                     GDBusConnection* connection,
                                                                     const gchar* path,
                                                                     GError** error);
static void power_services_device_manager_connect_to_bus_data_free (gpointer _data);
static void power_services_device_manager_connect_to_bus (PowerServicesDeviceManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean power_services_device_manager_connect_to_bus_finish (PowerServicesDeviceManager* self,
                                                              GAsyncResult* _res_);
static gboolean power_services_device_manager_connect_to_bus_co (PowerServicesDeviceManagerConnectToBusData* _data_);
static void power_services_device_manager_set_devices (PowerServicesDeviceManager* self,
                                                GeeHashMap* value);
static void power_services_device_manager_connect_to_bus_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static gboolean power_services_device_manager_determine_attached_device (PowerServicesDeviceManager* self,
                                                                  const char* device_path);
static void power_services_device_manager_set_display_device (PowerServicesDeviceManager* self,
                                                       PowerServicesDevice* value);
static void power_services_device_manager_register_device (PowerServicesDeviceManager* self,
                                                    const char* device_path);
static void power_services_device_manager_connect_signals (PowerServicesDeviceManager* self);
static void __lambda6_ (PowerServicesDeviceManager* self);
static void power_services_device_manager_update_properties (PowerServicesDeviceManager* self);
static void power_services_device_manager_update_batteries (PowerServicesDeviceManager* self);
static void ___lambda6__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                    GVariant* changed_properties,
                                                    gchar** invalidated_properties,
                                                    gpointer self);
static void _power_services_device_manager_register_device_power_services_dbus_interfaces_upower_device_added (PowerServicesDBusInterfacesUPower* _sender,
                                                                                                        const char* device_path,
                                                                                                        gpointer self);
static void power_services_device_manager_deregister_device (PowerServicesDeviceManager* self,
                                                      const char* device_path);
static void _power_services_device_manager_deregister_device_power_services_dbus_interfaces_upower_device_removed (PowerServicesDBusInterfacesUPower* _sender,
                                                                                                            const char* device_path,
                                                                                                            gpointer self);
static void __lambda7_ (PowerServicesDeviceManager* self,
                 GVariant* changed_properties,
                 gchar** invalidated_properties);
static void ___lambda7__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                    GVariant* changed_properties,
                                                    gchar** invalidated_properties,
                                                    gpointer self);
static void power_services_device_manager_set_on_battery (PowerServicesDeviceManager* self,
                                                   gboolean value);
static gboolean __lambda5_ (PowerServicesDeviceManager* self,
                     GeeMapEntry* entry);
static gboolean ___lambda5__gee_predicate (gconstpointer g,
                                    gpointer self);
static void power_services_device_manager_set_batteries (PowerServicesDeviceManager* self,
                                                  GeeIterator* value);
static void power_services_device_manager_set_has_battery (PowerServicesDeviceManager* self,
                                                    gboolean value);
VALA_EXTERN gint power_services_dbus_interfaces_power_settings_get_brightness (PowerServicesDBusInterfacesPowerSettings* self);
static void power_services_device_manager_set_on_low_battery (PowerServicesDeviceManager* self,
                                                       gboolean value);
VALA_EXTERN void power_services_dbus_interfaces_power_settings_set_brightness (PowerServicesDBusInterfacesPowerSettings* self,
                                                                   gint value);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * power_services_device_manager_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _power_services_device_manager___lambda8_ (PowerServicesDeviceManager* self,
                                                GObject* obj,
                                                GAsyncResult* res);
static void __power_services_device_manager___lambda8__gasync_ready_callback (GObject* source_object,
                                                                       GAsyncResult* res,
                                                                       gpointer self);
static void power_services_device_manager_finalize (GObject * obj);
static GType power_services_device_manager_get_type_once (void);
static void _vala_power_services_device_manager_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_power_services_device_manager_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
power_services_device_manager_get_instance_private (PowerServicesDeviceManager* self)
{
	return G_STRUCT_MEMBER_P (self, PowerServicesDeviceManager_private_offset);
}

PowerServicesDeviceManager*
power_services_device_manager_get_default (void)
{
	PowerServicesDeviceManager* _tmp0_;
	PowerServicesDeviceManager* _tmp2_;
	PowerServicesDeviceManager* result;
	_tmp0_ = power_services_device_manager_instance;
	if (_tmp0_ == NULL) {
		PowerServicesDeviceManager* _tmp1_;
		_tmp1_ = power_services_device_manager_new ();
		_g_object_unref0 (power_services_device_manager_instance);
		power_services_device_manager_instance = _tmp1_;
	}
	_tmp2_ = power_services_device_manager_instance;
	result = _tmp2_;
	return result;
}

static void
power_services_device_manager_connect_to_bus_data_free (gpointer _data)
{
	PowerServicesDeviceManagerConnectToBusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PowerServicesDeviceManagerConnectToBusData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
power_services_device_manager_connect_to_bus (PowerServicesDeviceManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	PowerServicesDeviceManagerConnectToBusData* _data_;
	PowerServicesDeviceManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PowerServicesDeviceManagerConnectToBusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, power_services_device_manager_connect_to_bus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	power_services_device_manager_connect_to_bus_co (_data_);
}

static gboolean
power_services_device_manager_connect_to_bus_finish (PowerServicesDeviceManager* self,
                                                     GAsyncResult* _res_)
{
	gboolean result;
	PowerServicesDeviceManagerConnectToBusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
power_services_device_manager_connect_to_bus_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	PowerServicesDeviceManagerConnectToBusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	power_services_device_manager_connect_to_bus_co (_data_);
}

static gboolean
power_services_device_manager_connect_to_bus_co (PowerServicesDeviceManagerConnectToBusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, POWER_SERVICES_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->_tmp1_ = _data_->_tmp0_;
	power_services_device_manager_set_devices (_data_->self, _data_->_tmp1_);
	_g_object_unref0 (_data_->_tmp1_);
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (POWER_SERVICES_DBUS_INTERFACES_TYPE_UPOWER_PROXY, 0, NULL, power_services_device_manager_connect_to_bus_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", POWER_SERVICES_DEVICE_MANAGER_UPOWER_INTERFACE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", POWER_SERVICES_DEVICE_MANAGER_UPOWER_PATH, "g-interface-name", "org.freedesktop.UPower", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = (PowerServicesDBusInterfacesUPower*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp2_ = (PowerServicesDBusInterfacesUPower*) _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_g_object_unref0 (_data_->self->priv->upower);
		_data_->self->priv->upower = _data_->_tmp4_;
		g_debug ("DeviceManager.vala:91: Connection to UPower bus established");
		_data_->_state_ = 2;
		g_async_initable_new_async (POWER_SERVICES_DBUS_INTERFACES_TYPE_POWER_SETTINGS_PROXY, 0, NULL, power_services_device_manager_connect_to_bus_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", POWER_SERVICES_DEVICE_MANAGER_POWER_SETTINGS_INTERFACE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", POWER_SERVICES_DEVICE_MANAGER_POWER_SETTINGS_PATH, "g-interface-name", "org.gnome.SettingsDaemon.Power.Screen", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = (PowerServicesDBusInterfacesPowerSettings*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = (PowerServicesDBusInterfacesPowerSettings*) _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp2_);
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_g_object_unref0 (_data_->self->priv->iscreen);
		_data_->self->priv->iscreen = _data_->_tmp7_;
		g_debug ("DeviceManager.vala:99: Connection to Power Settings bus established");
		_data_->result = TRUE;
		_g_object_unref0 (_data_->_tmp5_);
		_g_object_unref0 (_data_->_tmp2_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_critical ("DeviceManager.vala:103: Connecting to UPower or PowerSettings bus fail" \
"ed: %s", _data_->_tmp9_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
power_services_device_manager_determine_attached_device (PowerServicesDeviceManager* self,
                                                         const char* device_path)
{
	PowerServicesDevice* device = NULL;
	PowerServicesDevice* _tmp0_;
	gboolean _tmp1_ = FALSE;
	PowerServicesDevice* _tmp2_;
	PowerServicesDeviceTechnology _tmp3_;
	PowerServicesDeviceTechnology _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device_path != NULL, FALSE);
	_tmp0_ = power_services_device_new ((const gchar*) device_path);
	device = _tmp0_;
	_tmp2_ = device;
	_tmp3_ = power_services_device_get_technology (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == POWER_SERVICES_DEVICE_TECHNOLOGY_UNKNOWN) {
		PowerServicesDevice* _tmp5_;
		PowerServicesDeviceState _tmp6_;
		PowerServicesDeviceState _tmp7_;
		_tmp5_ = device;
		_tmp6_ = power_services_device_get_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == POWER_SERVICES_DEVICE_STATE_UNKNOWN;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (device);
	return result;
}

void
power_services_device_manager_read_devices (PowerServicesDeviceManager* self)
{
	PowerServicesDBusInterfacesUPower* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->upower;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		char* display_device_path = NULL;
		PowerServicesDBusInterfacesUPower* _tmp1_;
		char* _tmp2_;
		const char* _tmp3_;
		PowerServicesDevice* _tmp4_;
		PowerServicesDevice* _tmp5_;
		char** devices = NULL;
		PowerServicesDBusInterfacesUPower* _tmp6_;
		gint _tmp7_ = 0;
		char** _tmp8_;
		gint devices_length1;
		gint _devices_size_;
		char** _tmp9_;
		gint _tmp9__length1;
		_tmp1_ = self->priv->upower;
		_tmp2_ = power_services_dbus_interfaces_upower_get_display_device (_tmp1_, &_inner_error0_);
		display_device_path = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = display_device_path;
		_tmp4_ = power_services_device_new ((const gchar*) _tmp3_);
		_tmp5_ = _tmp4_;
		power_services_device_manager_set_display_device (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = self->priv->upower;
		_tmp8_ = power_services_dbus_interfaces_upower_enumerate_devices (_tmp6_, &_tmp7_, &_inner_error0_);
		devices = _tmp8_;
		devices_length1 = _tmp7_;
		_devices_size_ = devices_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (display_device_path);
			goto __catch0_g_error;
		}
		_tmp9_ = devices;
		_tmp9__length1 = devices_length1;
		{
			char** device_path_collection = NULL;
			gint device_path_collection_length1 = 0;
			gint _device_path_collection_size_ = 0;
			gint device_path_it = 0;
			device_path_collection = _tmp9_;
			device_path_collection_length1 = _tmp9__length1;
			for (device_path_it = 0; device_path_it < device_path_collection_length1; device_path_it = device_path_it + 1) {
				char* _tmp10_;
				char* device_path = NULL;
				_tmp10_ = g_strdup (device_path_collection[device_path_it]);
				device_path = _tmp10_;
				{
					const char* _tmp11_;
					_tmp11_ = device_path;
					if (power_services_device_manager_determine_attached_device (self, _tmp11_) == TRUE) {
						const char* _tmp12_;
						_tmp12_ = device_path;
						power_services_device_manager_register_device (self, _tmp12_);
					}
					_g_free0 (device_path);
				}
			}
		}
		devices = (_vala_array_free (devices, devices_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (display_device_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_critical ("DeviceManager.vala:138: Reading UPower devices failed: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__lambda6_ (PowerServicesDeviceManager* self)
{
	power_services_device_manager_update_properties (self);
	power_services_device_manager_update_batteries (self);
}

static void
___lambda6__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                               GVariant* changed_properties,
                                               gchar** invalidated_properties,
                                               gpointer self)
{
	__lambda6_ ((PowerServicesDeviceManager*) self);
}

static void
_power_services_device_manager_register_device_power_services_dbus_interfaces_upower_device_added (PowerServicesDBusInterfacesUPower* _sender,
                                                                                                   const char* device_path,
                                                                                                   gpointer self)
{
	power_services_device_manager_register_device ((PowerServicesDeviceManager*) self, device_path);
}

static void
_power_services_device_manager_deregister_device_power_services_dbus_interfaces_upower_device_removed (PowerServicesDBusInterfacesUPower* _sender,
                                                                                                       const char* device_path,
                                                                                                       gpointer self)
{
	power_services_device_manager_deregister_device ((PowerServicesDeviceManager*) self, device_path);
}

static void
__lambda7_ (PowerServicesDeviceManager* self,
            GVariant* changed_properties,
            gchar** invalidated_properties)
{
	GVariant* changed_brightness = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed_properties != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed_properties, "Brightness", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	changed_brightness = _tmp3_;
	_tmp4_ = changed_brightness;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_;
		_tmp5_ = changed_brightness;
		g_signal_emit (self, power_services_device_manager_signals[POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_CHANGED_SIGNAL], 0, (gint) g_variant_get_int32 (_tmp5_));
	}
	_g_variant_unref0 (changed_brightness);
}

static void
___lambda7__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                               GVariant* changed_properties,
                                               gchar** invalidated_properties,
                                               gpointer self)
{
	__lambda7_ ((PowerServicesDeviceManager*) self, changed_properties, invalidated_properties);
}

static void
power_services_device_manager_connect_signals (PowerServicesDeviceManager* self)
{
	PowerServicesDBusInterfacesUPower* _tmp0_;
	PowerServicesDBusInterfacesPowerSettings* _tmp1_;
	PowerServicesDBusInterfacesUPower* _tmp2_;
	PowerServicesDBusInterfacesUPower* _tmp3_;
	PowerServicesDBusInterfacesUPower* _tmp4_;
	PowerServicesDBusInterfacesPowerSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->upower;
	_tmp1_ = self->priv->iscreen;
	_vala_return_if_fail ((_tmp0_ != NULL) && (_tmp1_ != NULL), "upower != null && iscreen != null");
	_tmp2_ = self->priv->upower;
	g_signal_connect_object ((GDBusProxy*) _tmp2_, "g-properties-changed", (GCallback) ___lambda6__g_dbus_proxy_g_properties_changed, self, 0);
	_tmp3_ = self->priv->upower;
	g_signal_connect_object (_tmp3_, "device-added", (GCallback) _power_services_device_manager_register_device_power_services_dbus_interfaces_upower_device_added, self, 0);
	_tmp4_ = self->priv->upower;
	g_signal_connect_object (_tmp4_, "device-removed", (GCallback) _power_services_device_manager_deregister_device_power_services_dbus_interfaces_upower_device_removed, self, 0);
	_tmp5_ = self->priv->iscreen;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ___lambda7__g_dbus_proxy_g_properties_changed, self, 0);
}

static void
power_services_device_manager_update_properties (PowerServicesDeviceManager* self)
{
	PowerServicesDBusInterfacesUPower* _tmp0_;
	PowerServicesDBusInterfacesUPower* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->upower;
	_vala_return_if_fail (_tmp0_ != NULL, "upower != null");
	_tmp1_ = self->priv->upower;
	_tmp2_ = power_services_dbus_interfaces_upower_get_on_battery (_tmp1_);
	_tmp3_ = _tmp2_;
	power_services_device_manager_set_on_battery (self, _tmp3_);
}

static gboolean
__lambda5_ (PowerServicesDeviceManager* self,
            GeeMapEntry* entry)
{
	PowerServicesDevice* device = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	PowerServicesDevice* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_value (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 ((PowerServicesDevice*) _tmp1_);
	device = _tmp2_;
	_tmp3_ = power_services_device_get_is_a_battery (device);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	_g_object_unref0 (device);
	return result;
}

static gboolean
___lambda5__gee_predicate (gconstpointer g,
                           gpointer self)
{
	gboolean result;
	result = __lambda5_ ((PowerServicesDeviceManager*) self, (GeeMapEntry*) g);
	return result;
}

static void
power_services_device_manager_update_batteries (PowerServicesDeviceManager* self)
{
	GeeHashMap* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_devices;
	_tmp1_ = gee_traversable_filter ((GeeTraversable*) _tmp0_, ___lambda5__gee_predicate, g_object_ref (self), g_object_unref);
	_tmp2_ = _tmp1_;
	power_services_device_manager_set_batteries (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_batteries;
	power_services_device_manager_set_has_battery (self, gee_iterator_has_next (_tmp3_));
}

static void
power_services_device_manager_register_device (PowerServicesDeviceManager* self,
                                               const char* device_path)
{
	PowerServicesDevice* device = NULL;
	PowerServicesDevice* _tmp0_;
	GeeHashMap* _tmp1_;
	PowerServicesDevice* _tmp2_;
	PowerServicesDevice* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_path != NULL);
	_tmp0_ = power_services_device_new ((const gchar*) device_path);
	device = _tmp0_;
	_tmp1_ = self->priv->_devices;
	_tmp2_ = device;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, (const gchar*) device_path, _tmp2_);
	g_debug ("DeviceManager.vala:176: Device \"%s\" registered", (const gchar*) device_path);
	power_services_device_manager_update_batteries (self);
	_tmp3_ = device;
	_tmp4_ = power_services_device_get_is_a_battery (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		PowerServicesDevice* _tmp6_;
		_tmp6_ = device;
		g_signal_emit (self, power_services_device_manager_signals[POWER_SERVICES_DEVICE_MANAGER_BATTERY_REGISTERED_SIGNAL], 0, (const gchar*) device_path, _tmp6_);
	}
	_g_object_unref0 (device);
}

static void
power_services_device_manager_deregister_device (PowerServicesDeviceManager* self,
                                                 const char* device_path)
{
	GeeHashMap* _tmp0_;
	PowerServicesDevice* device = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GeeHashMap* _tmp3_;
	PowerServicesDevice* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_path != NULL);
	_tmp0_ = self->priv->_devices;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (const gchar*) device_path)) {
		return;
	}
	_tmp1_ = self->priv->_devices;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (const gchar*) device_path);
	device = (PowerServicesDevice*) _tmp2_;
	_tmp3_ = self->priv->_devices;
	if (!gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, (const gchar*) device_path, NULL)) {
		_g_object_unref0 (device);
		return;
	}
	g_debug ("DeviceManager.vala:195: Device \"%s\" deregistered", (const gchar*) device_path);
	power_services_device_manager_update_batteries (self);
	_tmp4_ = device;
	_tmp5_ = power_services_device_get_is_a_battery (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		g_signal_emit (self, power_services_device_manager_signals[POWER_SERVICES_DEVICE_MANAGER_BATTERY_DEREGISTERED_SIGNAL], 0, (const gchar*) device_path);
	}
	_g_object_unref0 (device);
}

void
power_services_device_manager_change_brightness (PowerServicesDeviceManager* self,
                                                 gint change)
{
	PowerServicesDBusInterfacesPowerSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->iscreen;
	if (_tmp0_ != NULL) {
		PowerServicesDBusInterfacesPowerSettings* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->iscreen;
		_tmp2_ = power_services_dbus_interfaces_power_settings_get_brightness (_tmp1_);
		_tmp3_ = _tmp2_;
		power_services_device_manager_set_brightness (self, _tmp3_ + change);
	}
}

PowerServicesDeviceManager*
power_services_device_manager_construct (GType object_type)
{
	PowerServicesDeviceManager * self = NULL;
	self = (PowerServicesDeviceManager*) g_object_new (object_type, NULL);
	return self;
}

PowerServicesDeviceManager*
power_services_device_manager_new (void)
{
	return power_services_device_manager_construct (POWER_SERVICES_TYPE_DEVICE_MANAGER);
}

PowerServicesBacklight*
power_services_device_manager_get_backlight (PowerServicesDeviceManager* self)
{
	PowerServicesBacklight* result;
	PowerServicesBacklight* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backlight;
	result = _tmp0_;
	return result;
}

static void
power_services_device_manager_set_backlight (PowerServicesDeviceManager* self,
                                             PowerServicesBacklight* value)
{
	PowerServicesBacklight* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_manager_get_backlight (self);
	if (old_value != value) {
		PowerServicesBacklight* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_backlight);
		self->priv->_backlight = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_BACKLIGHT_PROPERTY]);
	}
}

GeeHashMap*
power_services_device_manager_get_devices (PowerServicesDeviceManager* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_devices;
	result = _tmp0_;
	return result;
}

static void
power_services_device_manager_set_devices (PowerServicesDeviceManager* self,
                                           GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_manager_get_devices (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_devices);
		self->priv->_devices = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_DEVICES_PROPERTY]);
	}
}

GeeIterator*
power_services_device_manager_get_batteries (PowerServicesDeviceManager* self)
{
	GeeIterator* result;
	GeeIterator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_batteries;
	result = _tmp0_;
	return result;
}

static void
power_services_device_manager_set_batteries (PowerServicesDeviceManager* self,
                                             GeeIterator* value)
{
	GeeIterator* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_manager_get_batteries (self);
	if (old_value != value) {
		GeeIterator* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_batteries);
		self->priv->_batteries = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_BATTERIES_PROPERTY]);
	}
}

PowerServicesDevice*
power_services_device_manager_get_display_device (PowerServicesDeviceManager* self)
{
	PowerServicesDevice* result;
	PowerServicesDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_device;
	result = _tmp0_;
	return result;
}

static void
power_services_device_manager_set_display_device (PowerServicesDeviceManager* self,
                                                  PowerServicesDevice* value)
{
	PowerServicesDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_manager_get_display_device (self);
	if (old_value != value) {
		PowerServicesDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display_device);
		self->priv->_display_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_DISPLAY_DEVICE_PROPERTY]);
	}
}

gboolean
power_services_device_manager_get_has_battery (PowerServicesDeviceManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_battery;
	return result;
}

static void
power_services_device_manager_set_has_battery (PowerServicesDeviceManager* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_manager_get_has_battery (self);
	if (old_value != value) {
		self->priv->_has_battery = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_HAS_BATTERY_PROPERTY]);
	}
}

gboolean
power_services_device_manager_get_on_battery (PowerServicesDeviceManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_on_battery;
	return result;
}

static void
power_services_device_manager_set_on_battery (PowerServicesDeviceManager* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_manager_get_on_battery (self);
	if (old_value != value) {
		self->priv->_on_battery = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_ON_BATTERY_PROPERTY]);
	}
}

gboolean
power_services_device_manager_get_on_low_battery (PowerServicesDeviceManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_on_low_battery;
	return result;
}

static void
power_services_device_manager_set_on_low_battery (PowerServicesDeviceManager* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_manager_get_on_low_battery (self);
	if (old_value != value) {
		self->priv->_on_low_battery = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_ON_LOW_BATTERY_PROPERTY]);
	}
}

gint
power_services_device_manager_get_brightness (PowerServicesDeviceManager* self)
{
	gint result;
	gboolean _tmp0_ = FALSE;
	PowerServicesBacklight* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_backlight;
	_tmp2_ = power_services_backlight_get_present (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		PowerServicesDBusInterfacesPowerSettings* _tmp4_;
		_tmp4_ = self->priv->iscreen;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PowerServicesDBusInterfacesPowerSettings* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->iscreen;
		_tmp6_ = power_services_dbus_interfaces_power_settings_get_brightness (_tmp5_);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
power_services_device_manager_set_brightness (PowerServicesDeviceManager* self,
                                              gint value)
{
	gboolean _tmp0_ = FALSE;
	PowerServicesBacklight* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_backlight;
	_tmp2_ = power_services_backlight_get_present (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		PowerServicesDBusInterfacesPowerSettings* _tmp4_;
		_tmp4_ = self->priv->iscreen;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PowerServicesDBusInterfacesPowerSettings* _tmp5_;
		_tmp5_ = self->priv->iscreen;
		power_services_dbus_interfaces_power_settings_set_brightness (_tmp5_, CLAMP (value, 0, 100));
	}
	g_object_notify_by_pspec ((GObject *) self, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
_power_services_device_manager___lambda8_ (PowerServicesDeviceManager* self,
                                           GObject* obj,
                                           GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	if (power_services_device_manager_connect_to_bus_finish (self, res)) {
		power_services_device_manager_update_properties (self);
		power_services_device_manager_read_devices (self);
		power_services_device_manager_update_batteries (self);
		power_services_device_manager_connect_signals (self);
	}
}

static void
__power_services_device_manager___lambda8__gasync_ready_callback (GObject* source_object,
                                                                  GAsyncResult* res,
                                                                  gpointer self)
{
	_power_services_device_manager___lambda8_ ((PowerServicesDeviceManager*) self, source_object, res);
	g_object_unref (self);
}

static GObject *
power_services_device_manager_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerServicesDeviceManager * self;
	PowerServicesBacklight* _tmp0_;
	PowerServicesBacklight* _tmp1_;
	parent_class = G_OBJECT_CLASS (power_services_device_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_SERVICES_TYPE_DEVICE_MANAGER, PowerServicesDeviceManager);
	_tmp0_ = power_services_backlight_new ();
	_tmp1_ = _tmp0_;
	power_services_device_manager_set_backlight (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	power_services_device_manager_connect_to_bus (self, __power_services_device_manager___lambda8__gasync_ready_callback, g_object_ref (self));
	return obj;
}

static void
power_services_device_manager_class_init (PowerServicesDeviceManagerClass * klass,
                                          gpointer klass_data)
{
	power_services_device_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerServicesDeviceManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_services_device_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_services_device_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = power_services_device_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = power_services_device_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MANAGER_BACKLIGHT_PROPERTY, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_BACKLIGHT_PROPERTY] = g_param_spec_object ("backlight", "backlight", "backlight", POWER_SERVICES_TYPE_BACKLIGHT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MANAGER_DEVICES_PROPERTY, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_DEVICES_PROPERTY] = g_param_spec_object ("devices", "devices", "devices", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MANAGER_BATTERIES_PROPERTY, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_BATTERIES_PROPERTY] = g_param_spec_object ("batteries", "batteries", "batteries", GEE_TYPE_ITERATOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MANAGER_DISPLAY_DEVICE_PROPERTY, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_DISPLAY_DEVICE_PROPERTY] = g_param_spec_object ("display-device", "display-device", "display-device", POWER_SERVICES_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MANAGER_HAS_BATTERY_PROPERTY, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_HAS_BATTERY_PROPERTY] = g_param_spec_boolean ("has-battery", "has-battery", "has-battery", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MANAGER_ON_BATTERY_PROPERTY, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_ON_BATTERY_PROPERTY] = g_param_spec_boolean ("on-battery", "on-battery", "on-battery", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MANAGER_ON_LOW_BATTERY_PROPERTY, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_ON_LOW_BATTERY_PROPERTY] = g_param_spec_boolean ("on-low-battery", "on-low-battery", "on-low-battery", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_PROPERTY, power_services_device_manager_properties[POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_PROPERTY] = g_param_spec_int ("brightness", "brightness", "brightness", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	power_services_device_manager_signals[POWER_SERVICES_DEVICE_MANAGER_BATTERY_REGISTERED_SIGNAL] = g_signal_new ("battery-registered", POWER_SERVICES_TYPE_DEVICE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, POWER_SERVICES_TYPE_DEVICE);
	power_services_device_manager_signals[POWER_SERVICES_DEVICE_MANAGER_BATTERY_DEREGISTERED_SIGNAL] = g_signal_new ("battery-deregistered", POWER_SERVICES_TYPE_DEVICE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	power_services_device_manager_signals[POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_CHANGED_SIGNAL] = g_signal_new ("brightness-changed", POWER_SERVICES_TYPE_DEVICE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
power_services_device_manager_instance_init (PowerServicesDeviceManager * self,
                                             gpointer klass)
{
	self->priv = power_services_device_manager_get_instance_private (self);
	self->priv->upower = NULL;
	self->priv->iscreen = NULL;
}

static void
power_services_device_manager_finalize (GObject * obj)
{
	PowerServicesDeviceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_SERVICES_TYPE_DEVICE_MANAGER, PowerServicesDeviceManager);
	_g_object_unref0 (self->priv->upower);
	_g_object_unref0 (self->priv->iscreen);
	_g_object_unref0 (self->priv->_backlight);
	_g_object_unref0 (self->priv->_devices);
	_g_object_unref0 (self->priv->_batteries);
	_g_object_unref0 (self->priv->_display_device);
	G_OBJECT_CLASS (power_services_device_manager_parent_class)->finalize (obj);
}

static GType
power_services_device_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerServicesDeviceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_services_device_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerServicesDeviceManager), 0, (GInstanceInitFunc) power_services_device_manager_instance_init, NULL };
	GType power_services_device_manager_type_id;
	power_services_device_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PowerServicesDeviceManager", &g_define_type_info, 0);
	PowerServicesDeviceManager_private_offset = g_type_add_instance_private (power_services_device_manager_type_id, sizeof (PowerServicesDeviceManagerPrivate));
	return power_services_device_manager_type_id;
}

GType
power_services_device_manager_get_type (void)
{
	static volatile gsize power_services_device_manager_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_manager_type_id__once)) {
		GType power_services_device_manager_type_id;
		power_services_device_manager_type_id = power_services_device_manager_get_type_once ();
		g_once_init_leave (&power_services_device_manager_type_id__once, power_services_device_manager_type_id);
	}
	return power_services_device_manager_type_id__once;
}

static void
_vala_power_services_device_manager_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	PowerServicesDeviceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_SERVICES_TYPE_DEVICE_MANAGER, PowerServicesDeviceManager);
	switch (property_id) {
		case POWER_SERVICES_DEVICE_MANAGER_BACKLIGHT_PROPERTY:
		g_value_set_object (value, power_services_device_manager_get_backlight (self));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_DEVICES_PROPERTY:
		g_value_set_object (value, power_services_device_manager_get_devices (self));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_BATTERIES_PROPERTY:
		g_value_set_object (value, power_services_device_manager_get_batteries (self));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_DISPLAY_DEVICE_PROPERTY:
		g_value_set_object (value, power_services_device_manager_get_display_device (self));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_HAS_BATTERY_PROPERTY:
		g_value_set_boolean (value, power_services_device_manager_get_has_battery (self));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_ON_BATTERY_PROPERTY:
		g_value_set_boolean (value, power_services_device_manager_get_on_battery (self));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_ON_LOW_BATTERY_PROPERTY:
		g_value_set_boolean (value, power_services_device_manager_get_on_low_battery (self));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_PROPERTY:
		g_value_set_int (value, power_services_device_manager_get_brightness (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_services_device_manager_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	PowerServicesDeviceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_SERVICES_TYPE_DEVICE_MANAGER, PowerServicesDeviceManager);
	switch (property_id) {
		case POWER_SERVICES_DEVICE_MANAGER_BACKLIGHT_PROPERTY:
		power_services_device_manager_set_backlight (self, g_value_get_object (value));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_DEVICES_PROPERTY:
		power_services_device_manager_set_devices (self, g_value_get_object (value));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_BATTERIES_PROPERTY:
		power_services_device_manager_set_batteries (self, g_value_get_object (value));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_DISPLAY_DEVICE_PROPERTY:
		power_services_device_manager_set_display_device (self, g_value_get_object (value));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_HAS_BATTERY_PROPERTY:
		power_services_device_manager_set_has_battery (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_ON_BATTERY_PROPERTY:
		power_services_device_manager_set_on_battery (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_ON_LOW_BATTERY_PROPERTY:
		power_services_device_manager_set_on_low_battery (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_MANAGER_BRIGHTNESS_PROPERTY:
		power_services_device_manager_set_brightness (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

