/* NotificationsMonitor.c generated by valac 0.56.17, the Vala compiler
 * generated from NotificationsMonitor.vala, do not modify */

/*
 * Copyright 2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 * Copyright 2015-2023 elementary, Inc (https://elementary.io)
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */
/*
 * Original code from:
 * http://bazaar.launchpad.net/~jconti/recent-notifications/gnome3/view/head:/src/recent-notifications.vala
 */

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "notifications.h"

#define NOTIFICATIONS_NOTIFICATIONS_MONITOR_CALL_MATCH "interface='org.freedesktop.Notifications',path='/org/freedesktop/Notif" \
"ications'"
#define NOTIFICATIONS_NOTIFICATIONS_MONITOR_RESPONSE_MATCH "type=method_return,sender='org.freedesktop.Notifications'"
#define NOTIFICATIONS_NOTIFICATIONS_MONITOR_ERROR_MATCH "type=error,sender='org.freedesktop.Notifications'"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _NotificationsNotificationsMonitor NotificationsNotificationsMonitor;
typedef struct _NotificationsNotificationsMonitorClass NotificationsNotificationsMonitorClass;
typedef struct _NotificationsNotificationsMonitorPrivate NotificationsNotificationsMonitorPrivate;
enum  {
	NOTIFICATIONS_NOTIFICATIONS_MONITOR_0_PROPERTY,
	NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATIONS_ACTION_GROUP_PROPERTY,
	NOTIFICATIONS_NOTIFICATIONS_MONITOR_NUM_PROPERTIES
};
static GParamSpec* notifications_notifications_monitor_properties[NOTIFICATIONS_NOTIFICATIONS_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _NotificationsNotificationsMonitorInitData NotificationsNotificationsMonitorInitData;
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
enum  {
	NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATION_RECEIVED_SIGNAL,
	NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATION_CLOSED_SIGNAL,
	NOTIFICATIONS_NOTIFICATIONS_MONITOR_NUM_SIGNALS
};
static guint notifications_notifications_monitor_signals[NOTIFICATIONS_NOTIFICATIONS_MONITOR_NUM_SIGNALS] = {0};

struct _NotificationsNotificationsMonitor {
	GObject parent_instance;
	NotificationsNotificationsMonitorPrivate * priv;
};

struct _NotificationsNotificationsMonitorClass {
	GObjectClass parent_class;
};

struct _NotificationsNotificationsMonitorPrivate {
	GeeMap* awaiting;
	GDBusConnection* connection;
	GDBusActionGroup* _notifications_action_group;
};

struct _NotificationsNotificationsMonitorInitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NotificationsNotificationsMonitor* self;
	gchar* address;
	gchar* _tmp0_;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp4_;
	GDBusConnection* _tmp5_;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant** _tmp10_;
	GVariant** _tmp11_;
	gint _tmp11__length1;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant** _tmp14_;
	GVariant** _tmp15_;
	gint _tmp15__length1;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GDBusConnection* _tmp20_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	NotificationsNotificationsMonitor* self;
	guint32 id;
	NotificationsNotificationCloseReason reason;
};

struct _Block5Data {
	int _ref_count_;
	NotificationsNotificationsMonitor* self;
	GDBusMessage* message;
	guint32 id;
};

static gint NotificationsNotificationsMonitor_private_offset;
static gpointer notifications_notifications_monitor_parent_class = NULL;

static void notifications_notifications_monitor_init_data_free (gpointer _data);
static gboolean notifications_notifications_monitor_init_co (NotificationsNotificationsMonitorInitData* _data_);
static void notifications_notifications_monitor_init_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static GVariant* _variant_new4 (const gchar* value);
static GVariant* _variant_new5 (const gchar* value);
static GVariant* _variant_new6 (const gchar* value);
static GVariant* _variant_new7 (guint value);
static GDBusMessage* notifications_notifications_monitor_filter (NotificationsNotificationsMonitor* self,
                                                          GDBusConnection* connection,
                                                          GDBusMessage* message,
                                                          gboolean incoming);
static GDBusMessage* _notifications_notifications_monitor_filter_gd_bus_message_filter_function (GDBusConnection* connection,
                                                                                          GDBusMessage* message,
                                                                                          gboolean incoming,
                                                                                          gpointer self);
static inline void notifications_notifications_monitor_emit_closed (NotificationsNotificationsMonitor* self,
                                                      guint32 id,
                                                      NotificationsNotificationCloseReason reason);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static inline void notifications_notifications_monitor_emit_received (NotificationsNotificationsMonitor* self,
                                                        GDBusMessage* message,
                                                        guint32 id);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda18_ (Block4Data* _data4_);
static gboolean ___lambda18__gsource_func (gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda19_ (Block5Data* _data5_);
static gboolean ___lambda19__gsource_func (gpointer self);
static void notifications_notifications_monitor_set_notifications_action_group (NotificationsNotificationsMonitor* self,
                                                                         GDBusActionGroup* value);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_ENUM (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static GObject * notifications_notifications_monitor_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void notifications_notifications_monitor_finalize (GObject * obj);
static GType notifications_notifications_monitor_get_type_once (void);
static void _vala_notifications_notifications_monitor_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_notifications_notifications_monitor_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
notifications_notifications_monitor_get_instance_private (NotificationsNotificationsMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsNotificationsMonitor_private_offset);
}

static void
notifications_notifications_monitor_init_data_free (gpointer _data)
{
	NotificationsNotificationsMonitorInitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (NotificationsNotificationsMonitorInitData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
notifications_notifications_monitor_init (NotificationsNotificationsMonitor* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	NotificationsNotificationsMonitorInitData* _data_;
	NotificationsNotificationsMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (NotificationsNotificationsMonitorInitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, notifications_notifications_monitor_init_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	notifications_notifications_monitor_init_co (_data_);
}

void
notifications_notifications_monitor_init_finish (NotificationsNotificationsMonitor* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	NotificationsNotificationsMonitorInitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
notifications_notifications_monitor_init_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	NotificationsNotificationsMonitorInitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	notifications_notifications_monitor_init_co (_data_);
}

static GVariant*
_variant_new4 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new5 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new6 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new7 (guint value)
{
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}

static GDBusMessage*
_notifications_notifications_monitor_filter_gd_bus_message_filter_function (GDBusConnection* connection,
                                                                            GDBusMessage* message,
                                                                            gboolean incoming,
                                                                            gpointer self)
{
	GDBusMessage* result;
	result = notifications_notifications_monitor_filter ((NotificationsNotificationsMonitor*) self, connection, message, incoming);
	return result;
}

static gboolean
notifications_notifications_monitor_init_co (NotificationsNotificationsMonitorInitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_dbus_address_get_for_bus_sync (G_BUS_TYPE_SESSION, NULL, &_data_->_inner_error0_);
	_data_->address = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->address;
	_data_->_state_ = 1;
	g_dbus_connection_new_for_address (_data_->_tmp2_, G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT | G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION, NULL, NULL, notifications_notifications_monitor_init_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = g_dbus_connection_new_for_address_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->address);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp1_;
	_data_->_tmp1_ = NULL;
	_g_object_unref0 (_data_->self->priv->connection);
	_data_->self->priv->connection = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->connection;
	_data_->_tmp6_ = G_VARIANT_TYPE_STRING;
	_data_->_tmp7_ = _variant_new4 (NOTIFICATIONS_NOTIFICATIONS_MONITOR_CALL_MATCH);
	_data_->_tmp8_ = _variant_new5 (NOTIFICATIONS_NOTIFICATIONS_MONITOR_RESPONSE_MATCH);
	_data_->_tmp9_ = _variant_new6 (NOTIFICATIONS_NOTIFICATIONS_MONITOR_ERROR_MATCH);
	_data_->_tmp10_ = g_new0 (GVariant*, 3 + 1);
	_data_->_tmp10_[0] = _data_->_tmp7_;
	_data_->_tmp10_[1] = _data_->_tmp8_;
	_data_->_tmp10_[2] = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp11__length1 = 3;
	_data_->_tmp12_ = g_variant_new_array (_data_->_tmp6_, _data_->_tmp11_, 3);
	g_variant_ref_sink (_data_->_tmp12_);
	_data_->_tmp13_ = _variant_new7 (0U);
	_data_->_tmp14_ = g_new0 (GVariant*, 2 + 1);
	_data_->_tmp14_[0] = _data_->_tmp12_;
	_data_->_tmp14_[1] = _data_->_tmp13_;
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp15__length1 = 2;
	_data_->_tmp16_ = g_variant_new_tuple (_data_->_tmp15_, 2);
	g_variant_ref_sink (_data_->_tmp16_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_state_ = 2;
	g_dbus_connection_call (_data_->_tmp5_, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus.Monitoring", "BecomeMonitor", _data_->_tmp17_, NULL, G_DBUS_CALL_FLAGS_NONE, -1, NULL, notifications_notifications_monitor_init_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp18_ = g_dbus_connection_call_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_g_variant_unref0 (_data_->_tmp19_);
	_g_variant_unref0 (_data_->_tmp17_);
	_data_->_tmp15_ = (_vala_array_free (_data_->_tmp15_, _data_->_tmp15__length1, (GDestroyNotify) g_variant_unref), NULL);
	_data_->_tmp11_ = (_vala_array_free (_data_->_tmp11_, _data_->_tmp11__length1, (GDestroyNotify) g_variant_unref), NULL);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp1_);
		_g_free0 (_data_->address);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->self->priv->connection;
	g_dbus_connection_add_filter (_data_->_tmp20_, _notifications_notifications_monitor_filter_gd_bus_message_filter_function, g_object_ref (_data_->self), g_object_unref);
	_g_object_unref0 (_data_->_tmp1_);
	_g_free0 (_data_->address);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static GDBusMessage*
notifications_notifications_monitor_filter (NotificationsNotificationsMonitor* self,
                                            GDBusConnection* connection,
                                            GDBusMessage* message,
                                            gboolean incoming)
{
	GVariant* body = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	GVariant* _tmp7_;
	GEnumValue* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GQuark _tmp34_ = 0U;
	static GQuark _tmp33_label0 = 0;
	static GQuark _tmp33_label1 = 0;
	static GQuark _tmp33_label2 = 0;
	static GQuark _tmp33_label3 = 0;
	static GQuark _tmp33_label4 = 0;
	GError* _inner_error0_ = NULL;
	GDBusMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	if (!incoming) {
		result = NULL;
		_g_object_unref0 (message);
		return result;
	}
	_tmp0_ = g_dbus_message_get_body (message);
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	body = _tmp1_;
	_tmp3_ = g_dbus_message_get_interface (message);
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		_tmp2_ = "null";
	}
	_tmp5_ = g_dbus_message_get_member (message);
	_tmp4_ = _tmp5_;
	if (_tmp4_ == NULL) {
		_tmp4_ = "null";
	}
	_tmp7_ = body;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = body;
		_tmp9_ = g_variant_print (_tmp8_, TRUE);
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("null");
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp10_;
	}
	_tmp11_ = g_enum_get_value (g_type_class_ref (g_dbus_message_type_get_type ()), g_dbus_message_get_message_type (message));
	_tmp12_ = g_strconcat ((_tmp11_ != NULL) ? _tmp11_->value_name : NULL, ", ", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat ("got message (", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = string_to_string (_tmp2_);
	_tmp17_ = g_strconcat (_tmp16_, ", ", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = string_to_string (_tmp4_);
	_tmp22_ = g_strconcat (_tmp21_, ", ", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp20_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_to_string (_tmp6_);
	_tmp27_ = g_strconcat (_tmp26_, ")", NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp25_, _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	g_debug ("NotificationsMonitor.vala:67: %s", _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp31_ = g_dbus_message_get_member (message);
	_tmp32_ = _tmp31_;
	_tmp34_ = (NULL == _tmp32_) ? 0 : g_quark_from_string (_tmp32_);
	if (_tmp34_ == ((0 != _tmp33_label0) ? _tmp33_label0 : (_tmp33_label0 = g_quark_from_static_string ("Notify")))) {
		switch (0) {
			default:
			{
				{
					GDBusMessage* _tmp35_ = NULL;
					GDBusMessage* _tmp36_;
					GeeMap* _tmp37_;
					_tmp36_ = g_dbus_message_copy (message, &_inner_error0_);
					_tmp35_ = _tmp36_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp37_ = self->priv->awaiting;
					gee_map_set (_tmp37_, (gpointer) ((guintptr) g_dbus_message_get_serial (message)), _tmp35_);
					_g_object_unref0 (_tmp35_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
					g_warning ("NotificationsMonitor.vala:80: failed to make a copy of notify message," \
" notification won't be included in the list");
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (_tmp6_);
					_g_variant_unref0 (body);
					_g_object_unref0 (message);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				break;
			}
		}
	} else if (((_tmp34_ == ((0 != _tmp33_label1) ? _tmp33_label1 : (_tmp33_label1 = g_quark_from_static_string ("CloseNotification")))) || (_tmp34_ == ((0 != _tmp33_label2) ? _tmp33_label2 : (_tmp33_label2 = g_quark_from_static_string ("NotificationClosed"))))) || (_tmp34_ == ((0 != _tmp33_label3) ? _tmp33_label3 : (_tmp33_label3 = g_quark_from_static_string ("ActionInvoked"))))) {
		switch (0) {
			default:
			{
				NotificationsNotificationCloseReason reason = 0;
				guint32 id = 0U;
				GVariant* _tmp38_;
				GVariant* _tmp39_;
				GVariant* _tmp40_;
				guint32 _tmp41_;
				const gchar* _tmp42_;
				_tmp38_ = body;
				_tmp39_ = g_variant_get_child_value (_tmp38_, (gsize) 0);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_variant_get_uint32 (_tmp40_);
				_g_variant_unref0 (_tmp40_);
				id = _tmp41_;
				_tmp42_ = g_dbus_message_get_member (message);
				if (g_strcmp0 (_tmp42_, "NotificationClosed") == 0) {
					GVariant* _tmp43_;
					GVariant* _tmp44_;
					GVariant* _tmp45_;
					_tmp43_ = body;
					_tmp44_ = g_variant_get_child_value (_tmp43_, (gsize) 1);
					_tmp45_ = _tmp44_;
					reason = (NotificationsNotificationCloseReason) g_variant_get_uint32 (_tmp45_);
					_g_variant_unref0 (_tmp45_);
				} else {
					const gchar* _tmp46_;
					_tmp46_ = g_dbus_message_get_member (message);
					if (g_strcmp0 (_tmp46_, "ActionInvoked") == 0) {
						reason = NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_UNDEFINED;
					} else {
						reason = NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_CLOSE_NOTIFICATION_CALL;
					}
				}
				notifications_notifications_monitor_emit_closed (self, id, reason);
				break;
			}
		}
	} else if (_tmp34_ == ((0 != _tmp33_label4) ? _tmp33_label4 : (_tmp33_label4 = g_quark_from_static_string (NULL)))) {
		switch (0) {
			default:
			{
				GDBusMessage* awaiting_message = NULL;
				GeeMap* _tmp47_;
				gpointer _tmp48_ = NULL;
				gboolean _tmp49_;
				_tmp47_ = self->priv->awaiting;
				_tmp49_ = gee_map_unset (_tmp47_, (gpointer) ((guintptr) g_dbus_message_get_reply_serial (message)), &_tmp48_);
				_g_object_unref0 (awaiting_message);
				awaiting_message = (GDBusMessage*) _tmp48_;
				if (_tmp49_) {
					GVariantDict* hints = NULL;
					GDBusMessage* _tmp50_;
					GVariant* _tmp51_;
					GVariant* _tmp52_;
					GVariant* _tmp53_;
					GVariantDict* _tmp54_;
					GVariantDict* _tmp55_;
					guint32 id = 0U;
					GVariant* _tmp56_;
					GVariant* _tmp57_;
					GVariant* _tmp58_;
					guint32 _tmp59_;
					gboolean transient = FALSE;
					gboolean _tmp60_ = FALSE;
					gboolean _tmp61_ = FALSE;
					GVariantDict* _tmp62_;
					gboolean _tmp63_ = FALSE;
					gboolean _tmp64_;
					static const gchar* EXCEPTIONS[3] = {"NetworkManager", "gnome-settings-daemon", "gnome-power-panel"};
					gchar* app_name = NULL;
					GDBusMessage* _tmp66_;
					GVariant* _tmp67_;
					GVariant* _tmp68_;
					GVariant* _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					const gchar* _tmp73_;
					GDBusMessage* _tmp74_;
					if (g_dbus_message_get_message_type (message) != G_DBUS_MESSAGE_TYPE_METHOD_RETURN) {
						_g_object_unref0 (awaiting_message);
						break;
					}
					_tmp50_ = awaiting_message;
					_tmp51_ = g_dbus_message_get_body (_tmp50_);
					_tmp52_ = g_variant_get_child_value (_tmp51_, (gsize) 6);
					_tmp53_ = _tmp52_;
					_tmp54_ = g_variant_dict_new (_tmp53_);
					_tmp55_ = _tmp54_;
					_g_variant_unref0 (_tmp53_);
					hints = _tmp55_;
					_tmp56_ = body;
					_tmp57_ = g_variant_get_child_value (_tmp56_, (gsize) 0);
					_tmp58_ = _tmp57_;
					_tmp59_ = g_variant_get_uint32 (_tmp58_);
					_g_variant_unref0 (_tmp58_);
					id = _tmp59_;
					notifications_notifications_monitor_emit_closed (self, id, NOTIFICATIONS_NOTIFICATION_CLOSE_REASON_UNDEFINED);
					_tmp62_ = hints;
					_tmp64_ = g_variant_dict_lookup (_tmp62_, "transient", "b", &_tmp63_, NULL);
					transient = _tmp63_;
					if (_tmp64_) {
						_tmp61_ = transient;
					} else {
						_tmp61_ = FALSE;
					}
					if (_tmp61_) {
						_tmp60_ = TRUE;
					} else {
						GVariantDict* _tmp65_;
						_tmp65_ = hints;
						_tmp60_ = g_variant_dict_contains (_tmp65_, "x-canonical-private-synchronous");
					}
					if (_tmp60_) {
						_g_variant_dict_unref0 (hints);
						_g_object_unref0 (awaiting_message);
						break;
					}
					_tmp66_ = awaiting_message;
					_tmp67_ = g_dbus_message_get_body (_tmp66_);
					_tmp68_ = g_variant_get_child_value (_tmp67_, (gsize) 0);
					_tmp69_ = _tmp68_;
					_tmp70_ = g_variant_get_string (_tmp69_, NULL);
					_tmp71_ = g_strdup (_tmp70_);
					_tmp72_ = _tmp71_;
					_g_variant_unref0 (_tmp69_);
					app_name = _tmp72_;
					_tmp73_ = app_name;
					if (_vala_string_array_contains (EXCEPTIONS, G_N_ELEMENTS (EXCEPTIONS), _tmp73_)) {
						_g_free0 (app_name);
						_g_variant_dict_unref0 (hints);
						_g_object_unref0 (awaiting_message);
						break;
					}
					_tmp74_ = awaiting_message;
					notifications_notifications_monitor_emit_received (self, _tmp74_, id);
					_g_free0 (app_name);
					_g_variant_dict_unref0 (hints);
				}
				_g_object_unref0 (awaiting_message);
				break;
			}
		}
	}
	result = NULL;
	_g_free0 (_tmp6_);
	_g_variant_unref0 (body);
	_g_object_unref0 (message);
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		NotificationsNotificationsMonitor* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda18_ (Block4Data* _data4_)
{
	NotificationsNotificationsMonitor* self;
	gboolean result;
	self = _data4_->self;
	g_signal_emit (self, notifications_notifications_monitor_signals[NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATION_CLOSED_SIGNAL], 0, _data4_->id, _data4_->reason);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda18_ (self);
	return result;
}

static inline void
notifications_notifications_monitor_emit_closed (NotificationsNotificationsMonitor* self,
                                                 guint32 id,
                                                 NotificationsNotificationCloseReason reason)
{
	Block4Data* _data4_;
	GMainContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->id = id;
	_data4_->reason = reason;
	_tmp0_ = g_main_context_default ();
	g_main_context_invoke_full (_tmp0_, G_PRIORITY_HIGH_IDLE, ___lambda18__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NotificationsNotificationsMonitor* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->message);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda19_ (Block5Data* _data5_)
{
	NotificationsNotificationsMonitor* self;
	gboolean result;
	self = _data5_->self;
	g_signal_emit (self, notifications_notifications_monitor_signals[NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATION_RECEIVED_SIGNAL], 0, _data5_->message, _data5_->id);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda19_ (self);
	return result;
}

static inline void
notifications_notifications_monitor_emit_received (NotificationsNotificationsMonitor* self,
                                                   GDBusMessage* message,
                                                   guint32 id)
{
	Block5Data* _data5_;
	GDBusMessage* _tmp0_;
	GMainContext* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (message);
	_g_object_unref0 (_data5_->message);
	_data5_->message = _tmp0_;
	_data5_->id = id;
	_tmp1_ = g_main_context_default ();
	g_main_context_invoke_full (_tmp1_, G_PRIORITY_HIGH_IDLE + 1, ___lambda19__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

NotificationsNotificationsMonitor*
notifications_notifications_monitor_construct (GType object_type)
{
	NotificationsNotificationsMonitor * self = NULL;
	self = (NotificationsNotificationsMonitor*) g_object_new (object_type, NULL);
	return self;
}

NotificationsNotificationsMonitor*
notifications_notifications_monitor_new (void)
{
	return notifications_notifications_monitor_construct (NOTIFICATIONS_TYPE_NOTIFICATIONS_MONITOR);
}

GDBusActionGroup*
notifications_notifications_monitor_get_notifications_action_group (NotificationsNotificationsMonitor* self)
{
	GDBusActionGroup* result;
	GDBusActionGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notifications_action_group;
	result = _tmp0_;
	return result;
}

static void
notifications_notifications_monitor_set_notifications_action_group (NotificationsNotificationsMonitor* self,
                                                                    GDBusActionGroup* value)
{
	GDBusActionGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notifications_monitor_get_notifications_action_group (self);
	if (old_value != value) {
		GDBusActionGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_notifications_action_group);
		self->priv->_notifications_action_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notifications_monitor_properties[NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATIONS_ACTION_GROUP_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint32 arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__UINT_ENUM (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_ENUM) (gpointer data1, guint32 arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_enum (param_values + 2), data2);
}

static GObject *
notifications_notifications_monitor_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	static GWeakRef NotificationsNotificationsMonitor_singleton__ref;
	static GMutex NotificationsNotificationsMonitor_singleton__lock;
	NotificationsNotificationsMonitor * self;
	GApplication* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusActionGroup* _tmp2_;
	GDBusActionGroup* _tmp3_;
	g_mutex_lock (&NotificationsNotificationsMonitor_singleton__lock);
	obj = g_weak_ref_get (&NotificationsNotificationsMonitor_singleton__ref);
	if (obj != NULL) {
		g_mutex_unlock (&NotificationsNotificationsMonitor_singleton__lock);
		return obj;
	}
	parent_class = G_OBJECT_CLASS (notifications_notifications_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_NOTIFICATIONS_MONITOR, NotificationsNotificationsMonitor);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = g_application_get_dbus_connection (_tmp0_);
	_tmp2_ = g_dbus_action_group_get (_tmp1_, "org.freedesktop.Notifications", "/org/freedesktop/Notifications");
	_tmp3_ = _tmp2_;
	notifications_notifications_monitor_set_notifications_action_group (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_weak_ref_set (&NotificationsNotificationsMonitor_singleton__ref, obj);
	g_mutex_unlock (&NotificationsNotificationsMonitor_singleton__lock);
	return obj;
}

static void
notifications_notifications_monitor_class_init (NotificationsNotificationsMonitorClass * klass,
                                                gpointer klass_data)
{
	notifications_notifications_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsNotificationsMonitor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_notifications_notifications_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_notifications_notifications_monitor_set_property;
	G_OBJECT_CLASS (klass)->constructor = notifications_notifications_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = notifications_notifications_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATIONS_ACTION_GROUP_PROPERTY, notifications_notifications_monitor_properties[NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATIONS_ACTION_GROUP_PROPERTY] = g_param_spec_object ("notifications-action-group", "notifications-action-group", "notifications-action-group", g_dbus_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	notifications_notifications_monitor_signals[NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATION_RECEIVED_SIGNAL] = g_signal_new ("notification-received", NOTIFICATIONS_TYPE_NOTIFICATIONS_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, g_dbus_message_get_type (), G_TYPE_UINT);
	notifications_notifications_monitor_signals[NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATION_CLOSED_SIGNAL] = g_signal_new ("notification-closed", NOTIFICATIONS_TYPE_NOTIFICATIONS_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_ENUM, G_TYPE_NONE, 2, G_TYPE_UINT, NOTIFICATIONS_NOTIFICATION_TYPE_CLOSE_REASON);
}

static void
notifications_notifications_monitor_instance_init (NotificationsNotificationsMonitor * self,
                                                   gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = notifications_notifications_monitor_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, g_dbus_message_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->awaiting = (GeeMap*) _tmp0_;
}

static void
notifications_notifications_monitor_finalize (GObject * obj)
{
	NotificationsNotificationsMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_NOTIFICATIONS_MONITOR, NotificationsNotificationsMonitor);
	_g_object_unref0 (self->priv->awaiting);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->_notifications_action_group);
	G_OBJECT_CLASS (notifications_notifications_monitor_parent_class)->finalize (obj);
}

static GType
notifications_notifications_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsNotificationsMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_notifications_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsNotificationsMonitor), 0, (GInstanceInitFunc) notifications_notifications_monitor_instance_init, NULL };
	GType notifications_notifications_monitor_type_id;
	notifications_notifications_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationsNotificationsMonitor", &g_define_type_info, 0);
	NotificationsNotificationsMonitor_private_offset = g_type_add_instance_private (notifications_notifications_monitor_type_id, sizeof (NotificationsNotificationsMonitorPrivate));
	return notifications_notifications_monitor_type_id;
}

GType
notifications_notifications_monitor_get_type (void)
{
	static volatile gsize notifications_notifications_monitor_type_id__once = 0;
	if (g_once_init_enter (&notifications_notifications_monitor_type_id__once)) {
		GType notifications_notifications_monitor_type_id;
		notifications_notifications_monitor_type_id = notifications_notifications_monitor_get_type_once ();
		g_once_init_leave (&notifications_notifications_monitor_type_id__once, notifications_notifications_monitor_type_id);
	}
	return notifications_notifications_monitor_type_id__once;
}

static void
_vala_notifications_notifications_monitor_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	NotificationsNotificationsMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_NOTIFICATIONS_MONITOR, NotificationsNotificationsMonitor);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATIONS_ACTION_GROUP_PROPERTY:
		g_value_set_object (value, notifications_notifications_monitor_get_notifications_action_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_notifications_notifications_monitor_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	NotificationsNotificationsMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_NOTIFICATIONS_MONITOR, NotificationsNotificationsMonitor);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATIONS_MONITOR_NOTIFICATIONS_ACTION_GROUP_PROPERTY:
		notifications_notifications_monitor_set_notifications_action_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

