/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSPositionTryDescriptors.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptorsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginTop);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginTop);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginRight);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginRight);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginBottom);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginBottom);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginLeft);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginLeft);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginBlock);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginBlock);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginBlockStart);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginBlockStart);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginBlockEnd);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginBlockEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginInline);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginInline);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginInlineStart);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginInlineStart);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginInlineEnd);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginInlineEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_top);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_top);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_right);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_right);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_bottom);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_bottom);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_left);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_left);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_block);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_block);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_block_dash_start);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_block_dash_start);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_block_dash_end);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_block_dash_end);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_inline);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_inline);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_inline_dash_start);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_inline_dash_start);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_inline_dash_end);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_inline_dash_end);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetBlock);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetBlock);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetBlockStart);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetBlockStart);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetBlockEnd);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetBlockEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetInline);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetInline);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetInlineStart);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetInlineStart);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetInlineEnd);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetInlineEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_top);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_top);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_left);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_left);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_right);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_right);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_bottom);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_bottom);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_block);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_block);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_block_dash_start);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_block_dash_start);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_block_dash_end);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_block_dash_end);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_inline);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_inline);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_inline_dash_start);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_inline_dash_start);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_inline_dash_end);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_inline_dash_end);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_width);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_minWidth);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_minWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_maxWidth);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_maxWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_height);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_height);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_minHeight);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_minHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_maxHeight);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_maxHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_blockSize);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_blockSize);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_minBlockSize);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_minBlockSize);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_maxBlockSize);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_maxBlockSize);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inlineSize);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inlineSize);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_minInlineSize);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_minInlineSize);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_maxInlineSize);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_maxInlineSize);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_min_dash_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_min_dash_width);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_max_dash_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_max_dash_width);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_min_dash_height);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_min_dash_height);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_max_dash_height);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_max_dash_height);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_block_dash_size);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_block_dash_size);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_min_dash_block_dash_size);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_min_dash_block_dash_size);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_max_dash_block_dash_size);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_max_dash_block_dash_size);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inline_dash_size);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inline_dash_size);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_min_dash_inline_dash_size);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_min_dash_inline_dash_size);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_max_dash_inline_dash_size);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_max_dash_inline_dash_size);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_placeSelf);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_placeSelf);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_alignSelf);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_alignSelf);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_justifySelf);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_justifySelf);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_place_dash_self);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_place_dash_self);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_align_dash_self);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_align_dash_self);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_justify_dash_self);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_justify_dash_self);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_positionAnchor);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_positionAnchor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_position_dash_anchor);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_position_dash_anchor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_positionArea);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_positionArea);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_position_dash_area);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_position_dash_area);

class JSCSSPositionTryDescriptorsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSPositionTryDescriptorsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSPositionTryDescriptorsPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSPositionTryDescriptorsPrototype>(vm)) JSCSSPositionTryDescriptorsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSPositionTryDescriptorsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSPositionTryDescriptorsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSPositionTryDescriptorsPrototype, JSCSSPositionTryDescriptorsPrototype::Base);

using JSCSSPositionTryDescriptorsDOMConstructor = JSDOMConstructorNotConstructable<JSCSSPositionTryDescriptors>;

template<> const ClassInfo JSCSSPositionTryDescriptorsDOMConstructor::s_info = { "CSSPositionTryDescriptors"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPositionTryDescriptorsDOMConstructor) };

template<> JSValue JSCSSPositionTryDescriptorsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSStyleDeclaration::getConstructor(vm, &globalObject);
}

template<> void JSCSSPositionTryDescriptorsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSPositionTryDescriptors"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSPositionTryDescriptors::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 71> JSCSSPositionTryDescriptorsPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptorsConstructor, 0 } },
    HashTableValue { "margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin, setJSCSSPositionTryDescriptors_margin } },
    HashTableValue { "marginTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginTop, setJSCSSPositionTryDescriptors_marginTop } },
    HashTableValue { "marginRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginRight, setJSCSSPositionTryDescriptors_marginRight } },
    HashTableValue { "marginBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginBottom, setJSCSSPositionTryDescriptors_marginBottom } },
    HashTableValue { "marginLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginLeft, setJSCSSPositionTryDescriptors_marginLeft } },
    HashTableValue { "marginBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginBlock, setJSCSSPositionTryDescriptors_marginBlock } },
    HashTableValue { "marginBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginBlockStart, setJSCSSPositionTryDescriptors_marginBlockStart } },
    HashTableValue { "marginBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginBlockEnd, setJSCSSPositionTryDescriptors_marginBlockEnd } },
    HashTableValue { "marginInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginInline, setJSCSSPositionTryDescriptors_marginInline } },
    HashTableValue { "marginInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginInlineStart, setJSCSSPositionTryDescriptors_marginInlineStart } },
    HashTableValue { "marginInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_marginInlineEnd, setJSCSSPositionTryDescriptors_marginInlineEnd } },
    HashTableValue { "margin-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_top, setJSCSSPositionTryDescriptors_margin_dash_top } },
    HashTableValue { "margin-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_right, setJSCSSPositionTryDescriptors_margin_dash_right } },
    HashTableValue { "margin-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_bottom, setJSCSSPositionTryDescriptors_margin_dash_bottom } },
    HashTableValue { "margin-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_left, setJSCSSPositionTryDescriptors_margin_dash_left } },
    HashTableValue { "margin-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_block, setJSCSSPositionTryDescriptors_margin_dash_block } },
    HashTableValue { "margin-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_block_dash_start, setJSCSSPositionTryDescriptors_margin_dash_block_dash_start } },
    HashTableValue { "margin-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_block_dash_end, setJSCSSPositionTryDescriptors_margin_dash_block_dash_end } },
    HashTableValue { "margin-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_inline, setJSCSSPositionTryDescriptors_margin_dash_inline } },
    HashTableValue { "margin-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_inline_dash_start, setJSCSSPositionTryDescriptors_margin_dash_inline_dash_start } },
    HashTableValue { "margin-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_margin_dash_inline_dash_end, setJSCSSPositionTryDescriptors_margin_dash_inline_dash_end } },
    HashTableValue { "inset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inset, setJSCSSPositionTryDescriptors_inset } },
    HashTableValue { "insetBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_insetBlock, setJSCSSPositionTryDescriptors_insetBlock } },
    HashTableValue { "insetBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_insetBlockStart, setJSCSSPositionTryDescriptors_insetBlockStart } },
    HashTableValue { "insetBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_insetBlockEnd, setJSCSSPositionTryDescriptors_insetBlockEnd } },
    HashTableValue { "insetInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_insetInline, setJSCSSPositionTryDescriptors_insetInline } },
    HashTableValue { "insetInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_insetInlineStart, setJSCSSPositionTryDescriptors_insetInlineStart } },
    HashTableValue { "insetInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_insetInlineEnd, setJSCSSPositionTryDescriptors_insetInlineEnd } },
    HashTableValue { "top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_top, setJSCSSPositionTryDescriptors_top } },
    HashTableValue { "left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_left, setJSCSSPositionTryDescriptors_left } },
    HashTableValue { "right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_right, setJSCSSPositionTryDescriptors_right } },
    HashTableValue { "bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_bottom, setJSCSSPositionTryDescriptors_bottom } },
    HashTableValue { "inset-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inset_dash_block, setJSCSSPositionTryDescriptors_inset_dash_block } },
    HashTableValue { "inset-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inset_dash_block_dash_start, setJSCSSPositionTryDescriptors_inset_dash_block_dash_start } },
    HashTableValue { "inset-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inset_dash_block_dash_end, setJSCSSPositionTryDescriptors_inset_dash_block_dash_end } },
    HashTableValue { "inset-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inset_dash_inline, setJSCSSPositionTryDescriptors_inset_dash_inline } },
    HashTableValue { "inset-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inset_dash_inline_dash_start, setJSCSSPositionTryDescriptors_inset_dash_inline_dash_start } },
    HashTableValue { "inset-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inset_dash_inline_dash_end, setJSCSSPositionTryDescriptors_inset_dash_inline_dash_end } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_width, setJSCSSPositionTryDescriptors_width } },
    HashTableValue { "minWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_minWidth, setJSCSSPositionTryDescriptors_minWidth } },
    HashTableValue { "maxWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_maxWidth, setJSCSSPositionTryDescriptors_maxWidth } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_height, setJSCSSPositionTryDescriptors_height } },
    HashTableValue { "minHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_minHeight, setJSCSSPositionTryDescriptors_minHeight } },
    HashTableValue { "maxHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_maxHeight, setJSCSSPositionTryDescriptors_maxHeight } },
    HashTableValue { "blockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_blockSize, setJSCSSPositionTryDescriptors_blockSize } },
    HashTableValue { "minBlockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_minBlockSize, setJSCSSPositionTryDescriptors_minBlockSize } },
    HashTableValue { "maxBlockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_maxBlockSize, setJSCSSPositionTryDescriptors_maxBlockSize } },
    HashTableValue { "inlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inlineSize, setJSCSSPositionTryDescriptors_inlineSize } },
    HashTableValue { "minInlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_minInlineSize, setJSCSSPositionTryDescriptors_minInlineSize } },
    HashTableValue { "maxInlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_maxInlineSize, setJSCSSPositionTryDescriptors_maxInlineSize } },
    HashTableValue { "min-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_min_dash_width, setJSCSSPositionTryDescriptors_min_dash_width } },
    HashTableValue { "max-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_max_dash_width, setJSCSSPositionTryDescriptors_max_dash_width } },
    HashTableValue { "min-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_min_dash_height, setJSCSSPositionTryDescriptors_min_dash_height } },
    HashTableValue { "max-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_max_dash_height, setJSCSSPositionTryDescriptors_max_dash_height } },
    HashTableValue { "block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_block_dash_size, setJSCSSPositionTryDescriptors_block_dash_size } },
    HashTableValue { "min-block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_min_dash_block_dash_size, setJSCSSPositionTryDescriptors_min_dash_block_dash_size } },
    HashTableValue { "max-block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_max_dash_block_dash_size, setJSCSSPositionTryDescriptors_max_dash_block_dash_size } },
    HashTableValue { "inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_inline_dash_size, setJSCSSPositionTryDescriptors_inline_dash_size } },
    HashTableValue { "min-inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_min_dash_inline_dash_size, setJSCSSPositionTryDescriptors_min_dash_inline_dash_size } },
    HashTableValue { "max-inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_max_dash_inline_dash_size, setJSCSSPositionTryDescriptors_max_dash_inline_dash_size } },
    HashTableValue { "placeSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_placeSelf, setJSCSSPositionTryDescriptors_placeSelf } },
    HashTableValue { "alignSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_alignSelf, setJSCSSPositionTryDescriptors_alignSelf } },
    HashTableValue { "justifySelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_justifySelf, setJSCSSPositionTryDescriptors_justifySelf } },
    HashTableValue { "place-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_place_dash_self, setJSCSSPositionTryDescriptors_place_dash_self } },
    HashTableValue { "align-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_align_dash_self, setJSCSSPositionTryDescriptors_align_dash_self } },
    HashTableValue { "justify-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_justify_dash_self, setJSCSSPositionTryDescriptors_justify_dash_self } },
    HashTableValue { "positionAnchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_positionAnchor, setJSCSSPositionTryDescriptors_positionAnchor } },
    HashTableValue { "position-anchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_position_dash_anchor, setJSCSSPositionTryDescriptors_position_dash_anchor } },
    HashTableValue { "positionArea"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_positionArea, setJSCSSPositionTryDescriptors_positionArea } },
    HashTableValue { "position-area"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSPositionTryDescriptors_position_dash_area, setJSCSSPositionTryDescriptors_position_dash_area } },
};

const ClassInfo JSCSSPositionTryDescriptorsPrototype::s_info = { "CSSPositionTryDescriptors"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPositionTryDescriptorsPrototype) };

void JSCSSPositionTryDescriptorsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSPositionTryDescriptors::info(), JSCSSPositionTryDescriptorsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSPositionTryDescriptors::s_info = { "CSSPositionTryDescriptors"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSPositionTryDescriptors) };

JSCSSPositionTryDescriptors::JSCSSPositionTryDescriptors(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSPositionTryDescriptors>&& impl)
    : JSCSSStyleDeclaration(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSPositionTryDescriptors> JSCSSPositionTryDescriptors::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSPositionTryDescriptors>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSPositionTryDescriptors::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSPositionTryDescriptorsPrototype::createStructure(vm, &globalObject, JSCSSStyleDeclaration::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSPositionTryDescriptorsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSPositionTryDescriptors::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSPositionTryDescriptors>(vm, globalObject);
}

JSValue JSCSSPositionTryDescriptors::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSPositionTryDescriptorsDOMConstructor, DOMConstructorID::CSSPositionTryDescriptors>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptorsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSPositionTryDescriptorsPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSPositionTryDescriptors::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSPositionTryDescriptors_marginGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.margin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMargin(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginTopGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginTop())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginTop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginTopSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginTop(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginTop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginTopSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginRightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginRight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginRight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginRightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginRightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginRight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginRight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginRightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginBottomGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginBottom())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginBottom, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginBottomGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginBottomSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginBottom(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginBottom, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginBottomSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginLeftGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginLeft())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginLeft, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginLeftSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginLeft(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginLeft, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginLeftSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginBlockGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginBlock())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginBlock, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginBlockGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginBlockSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginBlock(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginBlock, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginBlockSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginBlockStartGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginBlockStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginBlockStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginBlockStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginBlockStartSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginBlockStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginBlockStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginBlockStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginBlockEndGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginBlockEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginBlockEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginBlockEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginBlockEndSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginBlockEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginBlockEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginBlockEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginInlineGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginInline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginInline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginInlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginInlineSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginInline(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginInline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginInlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginInlineStartGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginInlineStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginInlineStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginInlineStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginInlineStartSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginInlineStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginInlineStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginInlineStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_marginInlineEndGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginInlineEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_marginInlineEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_marginInlineEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_marginInlineEndSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginInlineEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_marginInlineEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_marginInlineEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_topGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginTop())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_top, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_topGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_topSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginTop(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_top, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_topSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_rightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginRight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_right, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_rightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_rightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginRight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_right, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_rightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_bottomGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginBottom())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_bottom, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_bottomGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_bottomSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginBottom(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_bottom, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_bottomSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_leftGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginLeft())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_left, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_leftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_leftSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginLeft(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_left, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_leftSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_blockGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginBlock())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_block, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_blockGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_blockSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginBlock(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_block, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_blockSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_block_dash_startGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginBlockStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_block_dash_start, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_block_dash_startGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_block_dash_startSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginBlockStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_block_dash_start, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_block_dash_startSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_block_dash_endGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginBlockEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_block_dash_end, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_block_dash_endGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_block_dash_endSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginBlockEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_block_dash_end, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_block_dash_endSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_inlineGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginInline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_inline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_inlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_inlineSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginInline(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_inline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_inlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_inline_dash_startGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginInlineStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_inline_dash_start, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_inline_dash_startGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_inline_dash_startSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginInlineStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_inline_dash_start, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_inline_dash_startSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_margin_dash_inline_dash_endGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.marginInlineEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_margin_dash_inline_dash_end, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_margin_dash_inline_dash_endGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_margin_dash_inline_dash_endSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMarginInlineEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_margin_dash_inline_dash_end, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_margin_dash_inline_dash_endSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_insetGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.inset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_insetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_insetSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInset(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_insetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_insetBlockGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetBlock())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetBlock, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_insetBlockGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_insetBlockSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetBlock(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetBlock, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_insetBlockSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_insetBlockStartGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetBlockStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetBlockStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_insetBlockStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_insetBlockStartSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetBlockStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetBlockStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_insetBlockStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_insetBlockEndGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetBlockEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetBlockEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_insetBlockEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_insetBlockEndSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetBlockEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetBlockEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_insetBlockEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_insetInlineGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetInline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetInline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_insetInlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_insetInlineSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetInline(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetInline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_insetInlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_insetInlineStartGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetInlineStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetInlineStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_insetInlineStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_insetInlineStartSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetInlineStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetInlineStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_insetInlineStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_insetInlineEndGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetInlineEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_insetInlineEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_insetInlineEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_insetInlineEndSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetInlineEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_insetInlineEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_insetInlineEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_topGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.top())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_top, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_topGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_topSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTop(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_top, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_topSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_leftGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.left())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_left, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_leftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_leftSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLeft(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_left, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_leftSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_rightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.right())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_right, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_rightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_rightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setRight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_right, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_rightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_bottomGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.bottom())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_bottom, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_bottomGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_bottomSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBottom(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_bottom, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_bottomSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_inset_dash_blockGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetBlock())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_block, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_inset_dash_blockGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_inset_dash_blockSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetBlock(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_block, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_inset_dash_blockSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_inset_dash_block_dash_startGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetBlockStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_block_dash_start, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_inset_dash_block_dash_startGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_inset_dash_block_dash_startSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetBlockStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_block_dash_start, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_inset_dash_block_dash_startSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_inset_dash_block_dash_endGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetBlockEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_block_dash_end, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_inset_dash_block_dash_endGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_inset_dash_block_dash_endSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetBlockEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_block_dash_end, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_inset_dash_block_dash_endSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_inset_dash_inlineGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetInline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_inline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_inset_dash_inlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_inset_dash_inlineSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetInline(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_inline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_inset_dash_inlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_inset_dash_inline_dash_startGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetInlineStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_inline_dash_start, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_inset_dash_inline_dash_startGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_inset_dash_inline_dash_startSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetInlineStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_inline_dash_start, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_inset_dash_inline_dash_startSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_inset_dash_inline_dash_endGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.insetInlineEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inset_dash_inline_dash_end, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_inset_dash_inline_dash_endGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_inset_dash_inline_dash_endSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInsetInlineEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inset_dash_inline_dash_end, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_inset_dash_inline_dash_endSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_widthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_widthSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_minWidthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.minWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_minWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_minWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_minWidthSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_minWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_minWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_maxWidthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.maxWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_maxWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_maxWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_maxWidthSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_maxWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_maxWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_heightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_heightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setHeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_heightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_minHeightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.minHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_minHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_minHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_minHeightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinHeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_minHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_minHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_maxHeightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.maxHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_maxHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_maxHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_maxHeightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxHeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_maxHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_maxHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_blockSizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.blockSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_blockSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_blockSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_blockSizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBlockSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_blockSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_blockSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_minBlockSizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.minBlockSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_minBlockSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_minBlockSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_minBlockSizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinBlockSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_minBlockSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_minBlockSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_maxBlockSizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.maxBlockSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_maxBlockSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_maxBlockSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_maxBlockSizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxBlockSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_maxBlockSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_maxBlockSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_inlineSizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.inlineSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inlineSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_inlineSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_inlineSizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInlineSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inlineSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_inlineSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_minInlineSizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.minInlineSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_minInlineSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_minInlineSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_minInlineSizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinInlineSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_minInlineSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_minInlineSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_maxInlineSizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.maxInlineSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_maxInlineSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_maxInlineSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_maxInlineSizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxInlineSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_maxInlineSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_maxInlineSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_min_dash_widthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.minWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_min_dash_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_min_dash_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_min_dash_widthSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_min_dash_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_min_dash_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_max_dash_widthGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.maxWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_max_dash_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_max_dash_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_max_dash_widthSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_max_dash_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_max_dash_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_min_dash_heightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.minHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_min_dash_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_min_dash_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_min_dash_heightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinHeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_min_dash_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_min_dash_heightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_max_dash_heightGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.maxHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_max_dash_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_max_dash_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_max_dash_heightSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxHeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_max_dash_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_max_dash_heightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_block_dash_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.blockSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_block_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_block_dash_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_block_dash_sizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBlockSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_block_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_block_dash_sizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_min_dash_block_dash_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.minBlockSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_min_dash_block_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_min_dash_block_dash_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_min_dash_block_dash_sizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinBlockSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_min_dash_block_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_min_dash_block_dash_sizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_max_dash_block_dash_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.maxBlockSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_max_dash_block_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_max_dash_block_dash_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_max_dash_block_dash_sizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxBlockSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_max_dash_block_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_max_dash_block_dash_sizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_inline_dash_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.inlineSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_inline_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_inline_dash_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_inline_dash_sizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInlineSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_inline_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_inline_dash_sizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_min_dash_inline_dash_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.minInlineSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_min_dash_inline_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_min_dash_inline_dash_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_min_dash_inline_dash_sizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinInlineSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_min_dash_inline_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_min_dash_inline_dash_sizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_max_dash_inline_dash_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.maxInlineSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_max_dash_inline_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_max_dash_inline_dash_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_max_dash_inline_dash_sizeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxInlineSize(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_max_dash_inline_dash_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_max_dash_inline_dash_sizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_placeSelfGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.placeSelf())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_placeSelf, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_placeSelfGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_placeSelfSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaceSelf(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_placeSelf, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_placeSelfSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_alignSelfGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.alignSelf())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_alignSelf, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_alignSelfGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_alignSelfSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlignSelf(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_alignSelf, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_alignSelfSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_justifySelfGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.justifySelf())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_justifySelf, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_justifySelfGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_justifySelfSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setJustifySelf(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_justifySelf, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_justifySelfSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_place_dash_selfGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.placeSelf())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_place_dash_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_place_dash_selfGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_place_dash_selfSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaceSelf(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_place_dash_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_place_dash_selfSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_align_dash_selfGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.alignSelf())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_align_dash_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_align_dash_selfGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_align_dash_selfSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlignSelf(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_align_dash_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_align_dash_selfSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_justify_dash_selfGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.justifySelf())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_justify_dash_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_justify_dash_selfGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_justify_dash_selfSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setJustifySelf(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_justify_dash_self, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_justify_dash_selfSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_positionAnchorGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.positionAnchor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_positionAnchor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_positionAnchorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_positionAnchorSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPositionAnchor(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_positionAnchor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_positionAnchorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_position_dash_anchorGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.positionAnchor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_position_dash_anchor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_position_dash_anchorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_position_dash_anchorSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPositionAnchor(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_position_dash_anchor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_position_dash_anchorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_positionAreaGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.positionArea())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_positionArea, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_positionAreaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_positionAreaSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPositionArea(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_positionArea, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_positionAreaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSPositionTryDescriptors_position_dash_areaGetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.positionArea())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSPositionTryDescriptors_position_dash_area, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::get<jsCSSPositionTryDescriptors_position_dash_areaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSPositionTryDescriptors_position_dash_areaSetter(JSGlobalObject& lexicalGlobalObject, JSCSSPositionTryDescriptors& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPositionArea(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSPositionTryDescriptors_position_dash_area, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSPositionTryDescriptors>::set<setJSCSSPositionTryDescriptors_position_dash_areaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSPositionTryDescriptors::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSPositionTryDescriptors, UseCustomHeapCellType::No>(vm, "JSCSSPositionTryDescriptors"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSPositionTryDescriptors.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSPositionTryDescriptors = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSPositionTryDescriptors.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSPositionTryDescriptors = std::forward<decltype(space)>(space); }
    );
}

void JSCSSPositionTryDescriptors::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSPositionTryDescriptors*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSPositionTryDescriptors@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25CSSPositionTryDescriptorsE[]; }
#endif
template<std::same_as<CSSPositionTryDescriptors> T>
static inline void verifyVTable(CSSPositionTryDescriptors* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSPositionTryDescriptors@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25CSSPositionTryDescriptorsE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSPositionTryDescriptors has subclasses. If CSSPositionTryDescriptors has subclasses that get passed
        // to toJS() we currently require CSSPositionTryDescriptors you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSPositionTryDescriptors>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSPositionTryDescriptors>(impl.ptr());
#endif
    return createWrapper<CSSPositionTryDescriptors>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSPositionTryDescriptors& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSPositionTryDescriptors* JSCSSPositionTryDescriptors::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSPositionTryDescriptors*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
