/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBarcodeFormat.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(BarcodeFormat enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 14> values {
        MAKE_STATIC_STRING_IMPL("aztec"),
        MAKE_STATIC_STRING_IMPL("code_128"),
        MAKE_STATIC_STRING_IMPL("code_39"),
        MAKE_STATIC_STRING_IMPL("code_93"),
        MAKE_STATIC_STRING_IMPL("codabar"),
        MAKE_STATIC_STRING_IMPL("data_matrix"),
        MAKE_STATIC_STRING_IMPL("ean_13"),
        MAKE_STATIC_STRING_IMPL("ean_8"),
        MAKE_STATIC_STRING_IMPL("itf"),
        MAKE_STATIC_STRING_IMPL("pdf417"),
        MAKE_STATIC_STRING_IMPL("qr_code"),
        MAKE_STATIC_STRING_IMPL("unknown"),
        MAKE_STATIC_STRING_IMPL("upc_a"),
        MAKE_STATIC_STRING_IMPL("upc_e"),
    };
    static_assert(static_cast<size_t>(BarcodeFormat::Aztec) == 0, "BarcodeFormat::Aztec is not 0 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Code_128) == 1, "BarcodeFormat::Code_128 is not 1 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Code_39) == 2, "BarcodeFormat::Code_39 is not 2 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Code_93) == 3, "BarcodeFormat::Code_93 is not 3 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Codabar) == 4, "BarcodeFormat::Codabar is not 4 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Data_matrix) == 5, "BarcodeFormat::Data_matrix is not 5 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Ean_13) == 6, "BarcodeFormat::Ean_13 is not 6 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Ean_8) == 7, "BarcodeFormat::Ean_8 is not 7 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Itf) == 8, "BarcodeFormat::Itf is not 8 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Pdf417) == 9, "BarcodeFormat::Pdf417 is not 9 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Qr_code) == 10, "BarcodeFormat::Qr_code is not 10 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Unknown) == 11, "BarcodeFormat::Unknown is not 11 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Upc_a) == 12, "BarcodeFormat::Upc_a is not 12 as expected");
    static_assert(static_cast<size_t>(BarcodeFormat::Upc_e) == 13, "BarcodeFormat::Upc_e is not 13 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, BarcodeFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<BarcodeFormat> parseEnumerationFromString<BarcodeFormat>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, BarcodeFormat>, 14> mappings {
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "aztec"_s, BarcodeFormat::Aztec },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "codabar"_s, BarcodeFormat::Codabar },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "code_128"_s, BarcodeFormat::Code_128 },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "code_39"_s, BarcodeFormat::Code_39 },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "code_93"_s, BarcodeFormat::Code_93 },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "data_matrix"_s, BarcodeFormat::Data_matrix },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "ean_13"_s, BarcodeFormat::Ean_13 },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "ean_8"_s, BarcodeFormat::Ean_8 },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "itf"_s, BarcodeFormat::Itf },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "pdf417"_s, BarcodeFormat::Pdf417 },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "qr_code"_s, BarcodeFormat::Qr_code },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "unknown"_s, BarcodeFormat::Unknown },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "upc_a"_s, BarcodeFormat::Upc_a },
        std::pair<ComparableASCIILiteral, BarcodeFormat> { "upc_e"_s, BarcodeFormat::Upc_e },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<BarcodeFormat> parseEnumeration<BarcodeFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<BarcodeFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<BarcodeFormat>()
{
    return "\"aztec\", \"code_128\", \"code_39\", \"code_93\", \"codabar\", \"data_matrix\", \"ean_13\", \"ean_8\", \"itf\", \"pdf417\", \"qr_code\", \"unknown\", \"upc_a\", \"upc_e\""_s;
}

} // namespace WebCore

