/** @file
 * VirtualBox API class wrapper code for ISession.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_SESSION

#include "SessionWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(SessionWrap)

//
// ISession properties
//

STDMETHODIMP SessionWrap::COMGETTER(State)(SessionState_T *aState)
{
    LogRelFlow(("{%p} %s: enter aState=%p\n", this, "Session::getState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aState);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_STATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getState(aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_STATE_RETURN(this, hrc, 0 /*normal*/,*aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_STATE_RETURN(this, hrc, 1 /*hrc exception*/,*aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_STATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aState=%RU32 hrc=%Rhrc\n", this, "Session::getState", *aState, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::COMGETTER(Type)(SessionType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "Session::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "Session::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "Session::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "Session::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "Session::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::setName", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::COMGETTER(Machine)(IMachine **aMachine)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p\n", this, "Session::getMachine", aMachine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachine);
        ComTypeOutConverter<IMachine> TmpMachine(aMachine);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_MACHINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachine(TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_MACHINE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_MACHINE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_MACHINE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachine=%p hrc=%Rhrc\n", this, "Session::getMachine", *aMachine, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::COMGETTER(Console)(IConsole **aConsole)
{
    LogRelFlow(("{%p} %s: enter aConsole=%p\n", this, "Session::getConsole", aConsole));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aConsole);
        ComTypeOutConverter<IConsole> TmpConsole(aConsole);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_CONSOLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getConsole(TmpConsole.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_CONSOLE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpConsole.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_CONSOLE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_CONSOLE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aConsole=%p hrc=%Rhrc\n", this, "Session::getConsole", *aConsole, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::COMGETTER(InternalAndReservedAttribute1ISession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::COMGETTER(InternalAndReservedAttribute2ISession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::COMGETTER(InternalAndReservedAttribute3ISession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::COMGETTER(InternalAndReservedAttribute4ISession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::COMGETTER(InternalAndReservedAttribute5ISession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::COMGETTER(InternalAndReservedAttribute6ISession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::COMGETTER(InternalAndReservedAttribute7ISession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::COMGETTER(InternalAndReservedAttribute8ISession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IInternalSessionControl properties
//

STDMETHODIMP SessionWrap::COMGETTER(PID)(ULONG *aPID)
{
    LogRelFlow(("{%p} %s: enter aPID=%p\n", this, "Session::getPID", aPID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPID);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_PID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPID(aPID);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_PID_RETURN(this, hrc, 0 /*normal*/,*aPID);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_PID_RETURN(this, hrc, 1 /*hrc exception*/,*aPID);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_PID_RETURN(this, hrc, 9 /*unhandled exception*/,*aPID);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPID=%RU32 hrc=%Rhrc\n", this, "Session::getPID", *aPID, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::COMGETTER(RemoteConsole)(IConsole **aRemoteConsole)
{
    LogRelFlow(("{%p} %s: enter aRemoteConsole=%p\n", this, "Session::getRemoteConsole", aRemoteConsole));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRemoteConsole);
        ComTypeOutConverter<IConsole> TmpRemoteConsole(aRemoteConsole);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_REMOTECONSOLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRemoteConsole(TmpRemoteConsole.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_REMOTECONSOLE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpRemoteConsole.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_REMOTECONSOLE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_REMOTECONSOLE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRemoteConsole=%p hrc=%Rhrc\n", this, "Session::getRemoteConsole", *aRemoteConsole, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::COMGETTER(NominalState)(MachineState_T *aNominalState)
{
    LogRelFlow(("{%p} %s: enter aNominalState=%p\n", this, "Session::getNominalState", aNominalState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNominalState);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_NOMINALSTATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNominalState(aNominalState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_NOMINALSTATE_RETURN(this, hrc, 0 /*normal*/,*aNominalState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_NOMINALSTATE_RETURN(this, hrc, 1 /*hrc exception*/,*aNominalState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_GET_NOMINALSTATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aNominalState);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNominalState=%RU32 hrc=%Rhrc\n", this, "Session::getNominalState", *aNominalState, hrc));
    return hrc;
}


//
// ISession methods
//

STDMETHODIMP SessionWrap::UnlockMachine()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Session::unlockMachine"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UNLOCKMACHINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = unlockMachine();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UNLOCKMACHINE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UNLOCKMACHINE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UNLOCKMACHINE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::unlockMachine", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::InternalAndReservedMethod1ISession()
{
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::InternalAndReservedMethod2ISession()
{
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::InternalAndReservedMethod3ISession()
{
    return E_NOTIMPL;
}

STDMETHODIMP SessionWrap::InternalAndReservedMethod4ISession()
{
    return E_NOTIMPL;
}

//
// IInternalSessionControl methods
//

#ifndef VBOX_WITH_XPCOM
STDMETHODIMP SessionWrap::AssignMachine(IMachine *aMachine,
                                        LockType_T aLockType,
                                        IN_BSTR aTokenId)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p aLockType=%RU32 aTokenId=%ls\n", this, "Session::assignMachine", aMachine, aLockType, aTokenId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IMachine> TmpMachine(aMachine);
        
        BSTRInConverter TmpTokenId(aTokenId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNMACHINE_MIDL_ENTER(this, (void *)TmpMachine.ptr(), aLockType, TmpTokenId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = assignMachine(TmpMachine.ptr(),
                                aLockType,
                                TmpTokenId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNMACHINE_MIDL_RETURN(this, hrc, 0 /*normal*/, (void *)TmpMachine.ptr(), aLockType, TmpTokenId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNMACHINE_MIDL_RETURN(this, hrc, 1 /*hrc exception*/, 0, aLockType, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNMACHINE_MIDL_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aLockType, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::assignMachine", hrc));
    return hrc;
}
#endif /* !VBOX_WITH_XPCOM */

#ifdef VBOX_WITH_XPCOM
STDMETHODIMP SessionWrap::AssignMachine(IMachine *aMachine,
                                        LockType_T aLockType,
                                        IToken *aToken)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p aLockType=%RU32 aToken=%p\n", this, "Session::assignMachine", aMachine, aLockType, aToken));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IMachine> TmpMachine(aMachine);
        
        ComTypeInConverter<IToken> TmpToken(aToken);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNMACHINE_XPIDL_ENTER(this, (void *)TmpMachine.ptr(), aLockType, (void *)TmpToken.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = assignMachine(TmpMachine.ptr(),
                                aLockType,
                                TmpToken.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNMACHINE_XPIDL_RETURN(this, hrc, 0 /*normal*/, (void *)TmpMachine.ptr(), aLockType, (void *)TmpToken.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNMACHINE_XPIDL_RETURN(this, hrc, 1 /*hrc exception*/, 0, aLockType, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNMACHINE_XPIDL_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aLockType, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::assignMachine", hrc));
    return hrc;
}
#endif /* VBOX_WITH_XPCOM */

STDMETHODIMP SessionWrap::AssignRemoteMachine(IMachine *aMachine,
                                              IConsole *aConsole)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p aConsole=%p\n", this, "Session::assignRemoteMachine", aMachine, aConsole));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IMachine> TmpMachine(aMachine);
        ComTypeInConverter<IConsole> TmpConsole(aConsole);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNREMOTEMACHINE_ENTER(this, (void *)TmpMachine.ptr(), (void *)TmpConsole.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = assignRemoteMachine(TmpMachine.ptr(),
                                      TmpConsole.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNREMOTEMACHINE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpMachine.ptr(), (void *)TmpConsole.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNREMOTEMACHINE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ASSIGNREMOTEMACHINE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::assignRemoteMachine", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::UpdateMachineState(MachineState_T aMachineState)
{
    LogRelFlow(("{%p} %s: enter aMachineState=%RU32\n", this, "Session::updateMachineState", aMachineState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UPDATEMACHINESTATE_ENTER(this, aMachineState);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = updateMachineState(aMachineState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UPDATEMACHINESTATE_RETURN(this, hrc, 0 /*normal*/, aMachineState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UPDATEMACHINESTATE_RETURN(this, hrc, 1 /*hrc exception*/, aMachineState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UPDATEMACHINESTATE_RETURN(this, hrc, 9 /*unhandled exception*/, aMachineState);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::updateMachineState", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::Uninitialize()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Session::uninitialize"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UNINITIALIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = uninitialize();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UNINITIALIZE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UNINITIALIZE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_UNINITIALIZE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::uninitialize", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnNetworkAdapterChange(INetworkAdapter *aNetworkAdapter,
                                                 BOOL aChangeAdapter)
{
    LogRelFlow(("{%p} %s: enter aNetworkAdapter=%p aChangeAdapter=%RTbool\n", this, "Session::onNetworkAdapterChange", aNetworkAdapter, aChangeAdapter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<INetworkAdapter> TmpNetworkAdapter(aNetworkAdapter);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONNETWORKADAPTERCHANGE_ENTER(this, (void *)TmpNetworkAdapter.ptr(), aChangeAdapter != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onNetworkAdapterChange(TmpNetworkAdapter.ptr(),
                                         aChangeAdapter != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONNETWORKADAPTERCHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpNetworkAdapter.ptr(), aChangeAdapter != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONNETWORKADAPTERCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aChangeAdapter != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONNETWORKADAPTERCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aChangeAdapter != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onNetworkAdapterChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnAudioAdapterChange(IAudioAdapter *aAudioAdapter)
{
    LogRelFlow(("{%p} %s: enter aAudioAdapter=%p\n", this, "Session::onAudioAdapterChange", aAudioAdapter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IAudioAdapter> TmpAudioAdapter(aAudioAdapter);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONAUDIOADAPTERCHANGE_ENTER(this, (void *)TmpAudioAdapter.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onAudioAdapterChange(TmpAudioAdapter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONAUDIOADAPTERCHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpAudioAdapter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONAUDIOADAPTERCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONAUDIOADAPTERCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onAudioAdapterChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnHostAudioDeviceChange(IHostAudioDevice *aDevice,
                                                  BOOL aIsNew,
                                                  AudioDeviceState_T aState,
                                                  IVirtualBoxErrorInfo *aErrorInfo)
{
    LogRelFlow(("{%p} %s: enter aDevice=%p aIsNew=%RTbool aState=%RU32 aErrorInfo=%p\n", this, "Session::onHostAudioDeviceChange", aDevice, aIsNew, aState, aErrorInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IHostAudioDevice> TmpDevice(aDevice);
        
        
        ComTypeInConverter<IVirtualBoxErrorInfo> TmpErrorInfo(aErrorInfo);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONHOSTAUDIODEVICECHANGE_ENTER(this, (void *)TmpDevice.ptr(), aIsNew != FALSE, aState, (void *)TmpErrorInfo.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onHostAudioDeviceChange(TmpDevice.ptr(),
                                          aIsNew != FALSE,
                                          aState,
                                          TmpErrorInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONHOSTAUDIODEVICECHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDevice.ptr(), aIsNew != FALSE, aState, (void *)TmpErrorInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONHOSTAUDIODEVICECHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aIsNew != FALSE, aState, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONHOSTAUDIODEVICECHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aIsNew != FALSE, aState, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onHostAudioDeviceChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnSerialPortChange(ISerialPort *aSerialPort)
{
    LogRelFlow(("{%p} %s: enter aSerialPort=%p\n", this, "Session::onSerialPortChange", aSerialPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<ISerialPort> TmpSerialPort(aSerialPort);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSERIALPORTCHANGE_ENTER(this, (void *)TmpSerialPort.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onSerialPortChange(TmpSerialPort.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSERIALPORTCHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpSerialPort.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSERIALPORTCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSERIALPORTCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onSerialPortChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnParallelPortChange(IParallelPort *aParallelPort)
{
    LogRelFlow(("{%p} %s: enter aParallelPort=%p\n", this, "Session::onParallelPortChange", aParallelPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IParallelPort> TmpParallelPort(aParallelPort);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONPARALLELPORTCHANGE_ENTER(this, (void *)TmpParallelPort.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onParallelPortChange(TmpParallelPort.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONPARALLELPORTCHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpParallelPort.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONPARALLELPORTCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONPARALLELPORTCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onParallelPortChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnStorageControllerChange(IN_BSTR aMachineId,
                                                    IN_BSTR aControllerName)
{
    LogRelFlow(("{%p} %s: enter aMachineId=%ls aControllerName=%ls\n", this, "Session::onStorageControllerChange", aMachineId, aControllerName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        UuidInConverter TmpMachineId(aMachineId);
        BSTRInConverter TmpControllerName(aControllerName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSTORAGECONTROLLERCHANGE_ENTER(this, TmpMachineId.uuid().toStringCurly().c_str(), TmpControllerName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onStorageControllerChange(TmpMachineId.uuid(),
                                            TmpControllerName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSTORAGECONTROLLERCHANGE_RETURN(this, hrc, 0 /*normal*/, TmpMachineId.uuid().toStringCurly().c_str(), TmpControllerName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSTORAGECONTROLLERCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSTORAGECONTROLLERCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onStorageControllerChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnMediumChange(IMediumAttachment *aMediumAttachment,
                                         BOOL aForce)
{
    LogRelFlow(("{%p} %s: enter aMediumAttachment=%p aForce=%RTbool\n", this, "Session::onMediumChange", aMediumAttachment, aForce));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IMediumAttachment> TmpMediumAttachment(aMediumAttachment);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONMEDIUMCHANGE_ENTER(this, (void *)TmpMediumAttachment.ptr(), aForce != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onMediumChange(TmpMediumAttachment.ptr(),
                                 aForce != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONMEDIUMCHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpMediumAttachment.ptr(), aForce != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONMEDIUMCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aForce != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONMEDIUMCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aForce != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onMediumChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnStorageDeviceChange(IMediumAttachment *aMediumAttachment,
                                                BOOL aRemove,
                                                BOOL aSilent)
{
    LogRelFlow(("{%p} %s: enter aMediumAttachment=%p aRemove=%RTbool aSilent=%RTbool\n", this, "Session::onStorageDeviceChange", aMediumAttachment, aRemove, aSilent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IMediumAttachment> TmpMediumAttachment(aMediumAttachment);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSTORAGEDEVICECHANGE_ENTER(this, (void *)TmpMediumAttachment.ptr(), aRemove != FALSE, aSilent != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onStorageDeviceChange(TmpMediumAttachment.ptr(),
                                        aRemove != FALSE,
                                        aSilent != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSTORAGEDEVICECHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpMediumAttachment.ptr(), aRemove != FALSE, aSilent != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSTORAGEDEVICECHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aRemove != FALSE, aSilent != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSTORAGEDEVICECHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aRemove != FALSE, aSilent != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onStorageDeviceChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnVMProcessPriorityChange(VMProcPriority_T aPriority)
{
    LogRelFlow(("{%p} %s: enter aPriority=%RU32\n", this, "Session::onVMProcessPriorityChange", aPriority));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONVMPROCESSPRIORITYCHANGE_ENTER(this, aPriority);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onVMProcessPriorityChange(aPriority);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONVMPROCESSPRIORITYCHANGE_RETURN(this, hrc, 0 /*normal*/, aPriority);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONVMPROCESSPRIORITYCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aPriority);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONVMPROCESSPRIORITYCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aPriority);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onVMProcessPriorityChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnClipboardModeChange(ClipboardMode_T aClipboardMode)
{
    LogRelFlow(("{%p} %s: enter aClipboardMode=%RU32\n", this, "Session::onClipboardModeChange", aClipboardMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCLIPBOARDMODECHANGE_ENTER(this, aClipboardMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onClipboardModeChange(aClipboardMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCLIPBOARDMODECHANGE_RETURN(this, hrc, 0 /*normal*/, aClipboardMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCLIPBOARDMODECHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aClipboardMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCLIPBOARDMODECHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aClipboardMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onClipboardModeChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnClipboardFileTransferModeChange(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "Session::onClipboardFileTransferModeChange", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCLIPBOARDFILETRANSFERMODECHANGE_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onClipboardFileTransferModeChange(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCLIPBOARDFILETRANSFERMODECHANGE_RETURN(this, hrc, 0 /*normal*/, aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCLIPBOARDFILETRANSFERMODECHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCLIPBOARDFILETRANSFERMODECHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onClipboardFileTransferModeChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnDnDModeChange(DnDMode_T aDndMode)
{
    LogRelFlow(("{%p} %s: enter aDndMode=%RU32\n", this, "Session::onDnDModeChange", aDndMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONDNDMODECHANGE_ENTER(this, aDndMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onDnDModeChange(aDndMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONDNDMODECHANGE_RETURN(this, hrc, 0 /*normal*/, aDndMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONDNDMODECHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aDndMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONDNDMODECHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aDndMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onDnDModeChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnCPUChange(ULONG aCpu,
                                      BOOL aAdd)
{
    LogRelFlow(("{%p} %s: enter aCpu=%RU32 aAdd=%RTbool\n", this, "Session::onCPUChange", aCpu, aAdd));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCPUCHANGE_ENTER(this, aCpu, aAdd != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onCPUChange(aCpu,
                              aAdd != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCPUCHANGE_RETURN(this, hrc, 0 /*normal*/, aCpu, aAdd != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCPUCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aCpu, aAdd != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCPUCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aCpu, aAdd != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onCPUChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnCPUExecutionCapChange(ULONG aExecutionCap)
{
    LogRelFlow(("{%p} %s: enter aExecutionCap=%RU32\n", this, "Session::onCPUExecutionCapChange", aExecutionCap));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCPUEXECUTIONCAPCHANGE_ENTER(this, aExecutionCap);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onCPUExecutionCapChange(aExecutionCap);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCPUEXECUTIONCAPCHANGE_RETURN(this, hrc, 0 /*normal*/, aExecutionCap);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCPUEXECUTIONCAPCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aExecutionCap);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONCPUEXECUTIONCAPCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aExecutionCap);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onCPUExecutionCapChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnVRDEServerChange(BOOL aRestart)
{
    LogRelFlow(("{%p} %s: enter aRestart=%RTbool\n", this, "Session::onVRDEServerChange", aRestart));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONVRDESERVERCHANGE_ENTER(this, aRestart != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onVRDEServerChange(aRestart != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONVRDESERVERCHANGE_RETURN(this, hrc, 0 /*normal*/, aRestart != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONVRDESERVERCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aRestart != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONVRDESERVERCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aRestart != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onVRDEServerChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnRecordingStateChange(RecordingState_T aState,
                                                 IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aState=%RU32 aProgress=%p\n", this, "Session::onRecordingStateChange", aState, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONRECORDINGSTATECHANGE_ENTER(this, aState);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onRecordingStateChange(aState,
                                         TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONRECORDINGSTATECHANGE_RETURN(this, hrc, 0 /*normal*/, aState, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONRECORDINGSTATECHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aState, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONRECORDINGSTATECHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aState, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProgress=%p hrc=%Rhrc\n", this, "Session::onRecordingStateChange", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnRecordingScreenStateChange(RecordingState_T aState,
                                                       ULONG aScreen)
{
    LogRelFlow(("{%p} %s: enter aState=%RU32 aScreen=%RU32\n", this, "Session::onRecordingScreenStateChange", aState, aScreen));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONRECORDINGSCREENSTATECHANGE_ENTER(this, aState, aScreen);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onRecordingScreenStateChange(aState,
                                               aScreen);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONRECORDINGSCREENSTATECHANGE_RETURN(this, hrc, 0 /*normal*/, aState, aScreen);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONRECORDINGSCREENSTATECHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aState, aScreen);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONRECORDINGSCREENSTATECHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aState, aScreen);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onRecordingScreenStateChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnUSBControllerChange()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Session::onUSBControllerChange"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBCONTROLLERCHANGE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onUSBControllerChange();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBCONTROLLERCHANGE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBCONTROLLERCHANGE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBCONTROLLERCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onUSBControllerChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnSharedFolderChange(BOOL aGlobal)
{
    LogRelFlow(("{%p} %s: enter aGlobal=%RTbool\n", this, "Session::onSharedFolderChange", aGlobal));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSHAREDFOLDERCHANGE_ENTER(this, aGlobal != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onSharedFolderChange(aGlobal != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSHAREDFOLDERCHANGE_RETURN(this, hrc, 0 /*normal*/, aGlobal != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSHAREDFOLDERCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aGlobal != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSHAREDFOLDERCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aGlobal != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onSharedFolderChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnGuestDebugControlChange(IGuestDebugControl *aGuestDebugControl)
{
    LogRelFlow(("{%p} %s: enter aGuestDebugControl=%p\n", this, "Session::onGuestDebugControlChange", aGuestDebugControl));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IGuestDebugControl> TmpGuestDebugControl(aGuestDebugControl);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONGUESTDEBUGCONTROLCHANGE_ENTER(this, (void *)TmpGuestDebugControl.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onGuestDebugControlChange(TmpGuestDebugControl.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONGUESTDEBUGCONTROLCHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpGuestDebugControl.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONGUESTDEBUGCONTROLCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONGUESTDEBUGCONTROLCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onGuestDebugControlChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnUSBDeviceAttach(IUSBDevice *aDevice,
                                            IVirtualBoxErrorInfo *aError,
                                            ULONG aMaskedInterfaces,
                                            IN_BSTR aCaptureFilename)
{
    LogRelFlow(("{%p} %s: enter aDevice=%p aError=%p aMaskedInterfaces=%RU32 aCaptureFilename=%ls\n", this, "Session::onUSBDeviceAttach", aDevice, aError, aMaskedInterfaces, aCaptureFilename));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IUSBDevice> TmpDevice(aDevice);
        ComTypeInConverter<IVirtualBoxErrorInfo> TmpError(aError);
        
        BSTRInConverter TmpCaptureFilename(aCaptureFilename);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBDEVICEATTACH_ENTER(this, (void *)TmpDevice.ptr(), (void *)TmpError.ptr(), aMaskedInterfaces, TmpCaptureFilename.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onUSBDeviceAttach(TmpDevice.ptr(),
                                    TmpError.ptr(),
                                    aMaskedInterfaces,
                                    TmpCaptureFilename.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBDEVICEATTACH_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDevice.ptr(), (void *)TmpError.ptr(), aMaskedInterfaces, TmpCaptureFilename.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBDEVICEATTACH_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aMaskedInterfaces, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBDEVICEATTACH_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aMaskedInterfaces, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onUSBDeviceAttach", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnUSBDeviceDetach(IN_BSTR aId,
                                            IVirtualBoxErrorInfo *aError)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aError=%p\n", this, "Session::onUSBDeviceDetach", aId, aError));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        UuidInConverter TmpId(aId);
        ComTypeInConverter<IVirtualBoxErrorInfo> TmpError(aError);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBDEVICEDETACH_ENTER(this, TmpId.uuid().toStringCurly().c_str(), (void *)TmpError.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onUSBDeviceDetach(TmpId.uuid(),
                                    TmpError.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBDEVICEDETACH_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpError.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBDEVICEDETACH_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONUSBDEVICEDETACH_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onUSBDeviceDetach", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnShowWindow(BOOL aCheck,
                                       BOOL *aCanShow,
                                       LONG64 *aWinId)
{
    LogRelFlow(("{%p} %s: enter aCheck=%RTbool aCanShow=%p aWinId=%p\n", this, "Session::onShowWindow", aCheck, aCanShow, aWinId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCanShow);
        CheckComArgOutPointerValidThrow(aWinId);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSHOWWINDOW_ENTER(this, aCheck != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onShowWindow(aCheck != FALSE,
                               aCanShow,
                               aWinId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSHOWWINDOW_RETURN(this, hrc, 0 /*normal*/, aCheck != FALSE, *aCanShow != FALSE, *aWinId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSHOWWINDOW_RETURN(this, hrc, 1 /*hrc exception*/, aCheck != FALSE, *aCanShow != FALSE, *aWinId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONSHOWWINDOW_RETURN(this, hrc, 9 /*unhandled exception*/, aCheck != FALSE, *aCanShow != FALSE, *aWinId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCanShow=%RTbool *aWinId=%RI64 hrc=%Rhrc\n", this, "Session::onShowWindow", *aCanShow, *aWinId, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnBandwidthGroupChange(IBandwidthGroup *aBandwidthGroup)
{
    LogRelFlow(("{%p} %s: enter aBandwidthGroup=%p\n", this, "Session::onBandwidthGroupChange", aBandwidthGroup));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IBandwidthGroup> TmpBandwidthGroup(aBandwidthGroup);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONBANDWIDTHGROUPCHANGE_ENTER(this, (void *)TmpBandwidthGroup.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onBandwidthGroupChange(TmpBandwidthGroup.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONBANDWIDTHGROUPCHANGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpBandwidthGroup.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONBANDWIDTHGROUPCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONBANDWIDTHGROUPCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onBandwidthGroupChange", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::AccessGuestProperty(IN_BSTR aName,
                                              IN_BSTR aValue,
                                              IN_BSTR aFlags,
                                              ULONG aAccessMode,
                                              BSTR *aRetValue,
                                              LONG64 *aRetTimestamp,
                                              BSTR *aRetFlags)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aValue=%ls aFlags=%ls aAccessMode=%RU32 aRetValue=%p aRetTimestamp=%p aRetFlags=%p\n", this, "Session::accessGuestProperty", aName, aValue, aFlags, aAccessMode, aRetValue, aRetTimestamp, aRetFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRetValue);
        CheckComArgOutPointerValidThrow(aRetTimestamp);
        CheckComArgOutPointerValidThrow(aRetFlags);


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpValue(aValue);
        BSTRInConverter TmpFlags(aFlags);
        
        BSTROutConverter TmpRetValue(aRetValue);
        
        BSTROutConverter TmpRetFlags(aRetFlags);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ACCESSGUESTPROPERTY_ENTER(this, TmpName.str().c_str(), TmpValue.str().c_str(), TmpFlags.str().c_str(), aAccessMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = accessGuestProperty(TmpName.str(),
                                      TmpValue.str(),
                                      TmpFlags.str(),
                                      aAccessMode,
                                      TmpRetValue.str(),
                                      aRetTimestamp,
                                      TmpRetFlags.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ACCESSGUESTPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str(), TmpFlags.str().c_str(), aAccessMode, TmpRetValue.str().c_str(), *aRetTimestamp, TmpRetFlags.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ACCESSGUESTPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, aAccessMode, 0, *aRetTimestamp, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ACCESSGUESTPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, aAccessMode, 0, *aRetTimestamp, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRetValue=%ls *aRetTimestamp=%RI64 *aRetFlags=%ls hrc=%Rhrc\n", this, "Session::accessGuestProperty", *aRetValue, *aRetTimestamp, *aRetFlags, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::EnumerateGuestProperties(IN_BSTR aPatterns,
                                                   ComSafeArrayOut(BSTR, aKeys),
                                                   ComSafeArrayOut(BSTR, aValues),
                                                   ComSafeArrayOut(LONG64, aTimestamps),
                                                   ComSafeArrayOut(BSTR, aFlags))
{
    LogRelFlow(("{%p} %s: enter aPatterns=%ls aKeys=%p aValues=%p aTimestamps=%p aFlags=%p\n", this, "Session::enumerateGuestProperties", aPatterns, aKeys, aValues, aTimestamps, aFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeys);
        CheckComArgOutPointerValidThrow(aValues);
        CheckComArgOutPointerValidThrow(aTimestamps);
        CheckComArgOutPointerValidThrow(aFlags);


        BSTRInConverter TmpPatterns(aPatterns);
        ArrayBSTROutConverter TmpKeys(ComSafeArrayOutArg(aKeys));
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));
        ArrayOutConverter<LONG64> TmpTimestamps(ComSafeArrayOutArg(aTimestamps));
        ArrayBSTROutConverter TmpFlags(ComSafeArrayOutArg(aFlags));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ENUMERATEGUESTPROPERTIES_ENTER(this, TmpPatterns.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = enumerateGuestProperties(TmpPatterns.str(),
                                           TmpKeys.array(),
                                           TmpValues.array(),
                                           TmpTimestamps.array(),
                                           TmpFlags.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ENUMERATEGUESTPROPERTIES_RETURN(this, hrc, 0 /*normal*/, TmpPatterns.str().c_str(), (uint32_t)TmpKeys.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/, (uint32_t)TmpTimestamps.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ENUMERATEGUESTPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ENUMERATEGUESTPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeys=%zu *aValues=%zu *aTimestamps=%zu *aFlags=%zu hrc=%Rhrc\n", this, "Session::enumerateGuestProperties", ComSafeArraySize(*aKeys), ComSafeArraySize(*aValues), ComSafeArraySize(*aTimestamps), ComSafeArraySize(*aFlags), hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::OnlineMergeMedium(IMediumAttachment *aMediumAttachment,
                                            ULONG aSourceIdx,
                                            ULONG aTargetIdx,
                                            IProgress *aProgress)
{
    LogRelFlow(("{%p} %s: enter aMediumAttachment=%p aSourceIdx=%RU32 aTargetIdx=%RU32 aProgress=%p\n", this, "Session::onlineMergeMedium", aMediumAttachment, aSourceIdx, aTargetIdx, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IMediumAttachment> TmpMediumAttachment(aMediumAttachment);
        
        
        ComTypeInConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONLINEMERGEMEDIUM_ENTER(this, (void *)TmpMediumAttachment.ptr(), aSourceIdx, aTargetIdx, (void *)TmpProgress.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = onlineMergeMedium(TmpMediumAttachment.ptr(),
                                    aSourceIdx,
                                    aTargetIdx,
                                    TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONLINEMERGEMEDIUM_RETURN(this, hrc, 0 /*normal*/, (void *)TmpMediumAttachment.ptr(), aSourceIdx, aTargetIdx, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONLINEMERGEMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/, 0, aSourceIdx, aTargetIdx, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ONLINEMERGEMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aSourceIdx, aTargetIdx, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::onlineMergeMedium", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::ReconfigureMediumAttachments(ComSafeArrayIn(IMediumAttachment *, aAttachments))
{
    LogRelFlow(("{%p} %s: enter aAttachments=%zu\n", this, "Session::reconfigureMediumAttachments", aAttachments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayComTypeInConverter<IMediumAttachment> TmpAttachments(ComSafeArrayInArg(aAttachments));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_RECONFIGUREMEDIUMATTACHMENTS_ENTER(this, (uint32_t)TmpAttachments.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = reconfigureMediumAttachments(TmpAttachments.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_RECONFIGUREMEDIUMATTACHMENTS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpAttachments.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_RECONFIGUREMEDIUMATTACHMENTS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_RECONFIGUREMEDIUMATTACHMENTS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::reconfigureMediumAttachments", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::EnableVMMStatistics(BOOL aEnable)
{
    LogRelFlow(("{%p} %s: enter aEnable=%RTbool\n", this, "Session::enableVMMStatistics", aEnable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ENABLEVMMSTATISTICS_ENTER(this, aEnable != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = enableVMMStatistics(aEnable != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ENABLEVMMSTATISTICS_RETURN(this, hrc, 0 /*normal*/, aEnable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ENABLEVMMSTATISTICS_RETURN(this, hrc, 1 /*hrc exception*/, aEnable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_ENABLEVMMSTATISTICS_RETURN(this, hrc, 9 /*unhandled exception*/, aEnable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::enableVMMStatistics", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::PauseWithReason(Reason_T aReason)
{
    LogRelFlow(("{%p} %s: enter aReason=%RU32\n", this, "Session::pauseWithReason", aReason));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_PAUSEWITHREASON_ENTER(this, aReason);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = pauseWithReason(aReason);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_PAUSEWITHREASON_RETURN(this, hrc, 0 /*normal*/, aReason);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_PAUSEWITHREASON_RETURN(this, hrc, 1 /*hrc exception*/, aReason);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_PAUSEWITHREASON_RETURN(this, hrc, 9 /*unhandled exception*/, aReason);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::pauseWithReason", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::ResumeWithReason(Reason_T aReason)
{
    LogRelFlow(("{%p} %s: enter aReason=%RU32\n", this, "Session::resumeWithReason", aReason));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_RESUMEWITHREASON_ENTER(this, aReason);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = resumeWithReason(aReason);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_RESUMEWITHREASON_RETURN(this, hrc, 0 /*normal*/, aReason);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_RESUMEWITHREASON_RETURN(this, hrc, 1 /*hrc exception*/, aReason);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_RESUMEWITHREASON_RETURN(this, hrc, 9 /*unhandled exception*/, aReason);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::resumeWithReason", hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::SaveStateWithReason(Reason_T aReason,
                                              IProgress *aProgress,
                                              ISnapshot *aSnapshot,
                                              IN_BSTR aStateFilePath,
                                              BOOL aPauseVM,
                                              BOOL *aLeftPaused)
{
    LogRelFlow(("{%p} %s: enter aReason=%RU32 aProgress=%p aSnapshot=%p aStateFilePath=%ls aPauseVM=%RTbool aLeftPaused=%p\n", this, "Session::saveStateWithReason", aReason, aProgress, aSnapshot, aStateFilePath, aPauseVM, aLeftPaused));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLeftPaused);


        
        ComTypeInConverter<IProgress> TmpProgress(aProgress);
        ComTypeInConverter<ISnapshot> TmpSnapshot(aSnapshot);
        BSTRInConverter TmpStateFilePath(aStateFilePath);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_SAVESTATEWITHREASON_ENTER(this, aReason, (void *)TmpProgress.ptr(), (void *)TmpSnapshot.ptr(), TmpStateFilePath.str().c_str(), aPauseVM != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = saveStateWithReason(aReason,
                                      TmpProgress.ptr(),
                                      TmpSnapshot.ptr(),
                                      TmpStateFilePath.str(),
                                      aPauseVM != FALSE,
                                      aLeftPaused);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_SAVESTATEWITHREASON_RETURN(this, hrc, 0 /*normal*/, aReason, (void *)TmpProgress.ptr(), (void *)TmpSnapshot.ptr(), TmpStateFilePath.str().c_str(), aPauseVM != FALSE, *aLeftPaused != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_SAVESTATEWITHREASON_RETURN(this, hrc, 1 /*hrc exception*/, aReason, 0, 0, 0, aPauseVM != FALSE, *aLeftPaused != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_SAVESTATEWITHREASON_RETURN(this, hrc, 9 /*unhandled exception*/, aReason, 0, 0, 0, aPauseVM != FALSE, *aLeftPaused != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aLeftPaused=%RTbool hrc=%Rhrc\n", this, "Session::saveStateWithReason", *aLeftPaused, hrc));
    return hrc;
}

STDMETHODIMP SessionWrap::CancelSaveStateWithReason()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Session::cancelSaveStateWithReason"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_CANCELSAVESTATEWITHREASON_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = cancelSaveStateWithReason();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_CANCELSAVESTATEWITHREASON_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_CANCELSAVESTATEWITHREASON_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SESSION_CANCELSAVESTATEWITHREASON_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Session::cancelSaveStateWithReason", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SessionWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(SessionWrap, ISession, IInternalSessionControl)
#endif // VBOX_WITH_XPCOM
