//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdSkelImaging/animationSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdSkelImagingAnimationSchemaTokens,
    USD_SKEL_IMAGING_ANIMATION_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTokenArrayDataSourceHandle
UsdSkelImagingAnimationSchema::GetJoints() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdSkelImagingAnimationSchemaTokens->joints);
}

HdVec3fArrayDataSourceHandle
UsdSkelImagingAnimationSchema::GetTranslations() const
{
    return _GetTypedDataSource<HdVec3fArrayDataSource>(
        UsdSkelImagingAnimationSchemaTokens->translations);
}

HdQuatfArrayDataSourceHandle
UsdSkelImagingAnimationSchema::GetRotations() const
{
    return _GetTypedDataSource<HdQuatfArrayDataSource>(
        UsdSkelImagingAnimationSchemaTokens->rotations);
}

HdVec3hArrayDataSourceHandle
UsdSkelImagingAnimationSchema::GetScales() const
{
    return _GetTypedDataSource<HdVec3hArrayDataSource>(
        UsdSkelImagingAnimationSchemaTokens->scales);
}

HdTokenArrayDataSourceHandle
UsdSkelImagingAnimationSchema::GetBlendShapes() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdSkelImagingAnimationSchemaTokens->blendShapes);
}

HdFloatArrayDataSourceHandle
UsdSkelImagingAnimationSchema::GetBlendShapeWeights() const
{
    return _GetTypedDataSource<HdFloatArrayDataSource>(
        UsdSkelImagingAnimationSchemaTokens->blendShapeWeights);
}

/*static*/
HdContainerDataSourceHandle
UsdSkelImagingAnimationSchema::BuildRetained(
        const HdTokenArrayDataSourceHandle &joints,
        const HdVec3fArrayDataSourceHandle &translations,
        const HdQuatfArrayDataSourceHandle &rotations,
        const HdVec3hArrayDataSourceHandle &scales,
        const HdTokenArrayDataSourceHandle &blendShapes,
        const HdFloatArrayDataSourceHandle &blendShapeWeights
)
{
    TfToken _names[6];
    HdDataSourceBaseHandle _values[6];

    size_t _count = 0;

    if (joints) {
        _names[_count] = UsdSkelImagingAnimationSchemaTokens->joints;
        _values[_count++] = joints;
    }

    if (translations) {
        _names[_count] = UsdSkelImagingAnimationSchemaTokens->translations;
        _values[_count++] = translations;
    }

    if (rotations) {
        _names[_count] = UsdSkelImagingAnimationSchemaTokens->rotations;
        _values[_count++] = rotations;
    }

    if (scales) {
        _names[_count] = UsdSkelImagingAnimationSchemaTokens->scales;
        _values[_count++] = scales;
    }

    if (blendShapes) {
        _names[_count] = UsdSkelImagingAnimationSchemaTokens->blendShapes;
        _values[_count++] = blendShapes;
    }

    if (blendShapeWeights) {
        _names[_count] = UsdSkelImagingAnimationSchemaTokens->blendShapeWeights;
        _values[_count++] = blendShapeWeights;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

UsdSkelImagingAnimationSchema::Builder &
UsdSkelImagingAnimationSchema::Builder::SetJoints(
    const HdTokenArrayDataSourceHandle &joints)
{
    _joints = joints;
    return *this;
}

UsdSkelImagingAnimationSchema::Builder &
UsdSkelImagingAnimationSchema::Builder::SetTranslations(
    const HdVec3fArrayDataSourceHandle &translations)
{
    _translations = translations;
    return *this;
}

UsdSkelImagingAnimationSchema::Builder &
UsdSkelImagingAnimationSchema::Builder::SetRotations(
    const HdQuatfArrayDataSourceHandle &rotations)
{
    _rotations = rotations;
    return *this;
}

UsdSkelImagingAnimationSchema::Builder &
UsdSkelImagingAnimationSchema::Builder::SetScales(
    const HdVec3hArrayDataSourceHandle &scales)
{
    _scales = scales;
    return *this;
}

UsdSkelImagingAnimationSchema::Builder &
UsdSkelImagingAnimationSchema::Builder::SetBlendShapes(
    const HdTokenArrayDataSourceHandle &blendShapes)
{
    _blendShapes = blendShapes;
    return *this;
}

UsdSkelImagingAnimationSchema::Builder &
UsdSkelImagingAnimationSchema::Builder::SetBlendShapeWeights(
    const HdFloatArrayDataSourceHandle &blendShapeWeights)
{
    _blendShapeWeights = blendShapeWeights;
    return *this;
}

HdContainerDataSourceHandle
UsdSkelImagingAnimationSchema::Builder::Build()
{
    return UsdSkelImagingAnimationSchema::BuildRetained(
        _joints,
        _translations,
        _rotations,
        _scales,
        _blendShapes,
        _blendShapeWeights
    );
}

/*static*/
UsdSkelImagingAnimationSchema
UsdSkelImagingAnimationSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return UsdSkelImagingAnimationSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                UsdSkelImagingAnimationSchemaTokens->skelAnimation))
        : nullptr);
}

/*static*/
const TfToken &
UsdSkelImagingAnimationSchema::GetSchemaToken()
{
    return UsdSkelImagingAnimationSchemaTokens->skelAnimation;
}

/*static*/
const HdDataSourceLocator &
UsdSkelImagingAnimationSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingAnimationSchema::GetJointsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingAnimationSchemaTokens->joints);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingAnimationSchema::GetTranslationsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingAnimationSchemaTokens->translations);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingAnimationSchema::GetRotationsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingAnimationSchemaTokens->rotations);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingAnimationSchema::GetScalesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingAnimationSchemaTokens->scales);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingAnimationSchema::GetBlendShapesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingAnimationSchemaTokens->blendShapes);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingAnimationSchema::GetBlendShapeWeightsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingAnimationSchemaTokens->blendShapeWeights);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE
